#
#  Name: makefile.mak
#
#  Description: Make definitions for TBird shared data server
#
#  COPYRIGHT (C) 1992 MICROTEK INTERNATIONAL, INC.
#

.AUTODEPEND
#.SWAP

#
# files
#
SRC = .
ASMSRC = asm
BIN = bin
CCDIR = d:\C600\bin
INC = d:\C600\include
LNKDIR = d:\lnkloc\bin
TMPDIR = c:\temp

#
# paths
#
.PATH.lst = $(SRC)
.PATH.c   = $(SRC)
.PATH.db  = $(ASMSRC)
.PATH.tbl = $(ASMSRC)
.PATH.equ = $(ASMSRC)
.PATH.def = $(ASMSRC)
.PATH.asm = $(ASMSRC)
.PATH.a00 = $(ASMSRC)
.PATH.obj = $(BIN)
.PATH.lib = $(BIN)
.PATH.ssi = $(BIN)
.PATH.lnk = $(BIN)
.PATH.ABS = $(BIN)
.PATH.HEX = $(BIN)

#               *Translator Definitions*
LINK = $(LNKDIR)\xlink86
LOC = $(LNKDIR)\xloc86
PROM = $(LNKDIR)\prom86
OH86 = $(LNKDIR)\xoh86
CV2OMF = $(LNKDIR)\cv2omf
CONV = $(USDDIR)\CONVERT
CHKSUM = mice3chk
CC = $(CCDIR)\cl
#CC = $(CCDIR)\bcc
MASM = $(CCDIR)\masm
#MASM = $(CCDIR)\tasm
CFLAG = /AM /G1 /Gs /Od /Oi /Zp /c /FPa /Zi /W3
#CFLAG = /AM /G1 /Gs /Od /Zp /c /FPa /Zi /W3
#CFLAG = /AL /G1 /Gs /Od /Oi /Zp /c /FPa /Zi /W3
#CFLAG = -c -f- -mm -v -vi -y -w
CODEGEN = codegen

#               *Implicit Rules*
.C.obj:
#$(CC) $(CFLAG) /I. /I./asm /I$(INC) /Fa$(BIN)\$& /Fo$(SRC)\bin\$&.obj $(SRC)\$&.C
 $(CC) $(CFLAG) /I. /I./asm /I$(INC) /Fo$(SRC)\bin\$&.obj $(SRC)\$&.C
# $(CC) $(CFLAG) /I. /I$(INC) /Fc$(SRC)\$&.COD /Fo$(BIN)\$&.obj $(SRC)\$&.C
#$(CC) $(CFLAG) -I. -I$(INC) -o$(BIN)\$&.obj $(SRC)\$&.C
# find ": error " $(SRC)\err.lst > $&.lst
# find ": warning " $(TMPDIR)\err.lst >> $&.lst

.A00.obj:
# $(MASM) /Mx /Zi $&.Asm,$(BIN)\$&,$(SRC)\$&;
 $(MASM) /Mx /Zi /W2 /z /Zd /I$(ASMSRC) $(ASMSRC)\$&.A00,$(BIN)\$&,$(SRC)\ERR;
#$(MASM) /Mx /Zi /w /z /i$(ASMSRC) $(ASMSRC)\$&.A00,$(BIN)\$&,$(SRC)\ERR;
# find "error " $(SRC)\err.lst > $&.lst
# find "warning " $(TMPDIR)\err.lst >> $&.lst

# define all objs
LNK_depends =  start.obj bdm5202.obj boot.obj test.obj emudebug.obj\
               emucomm.obj emumain.obj emullfw.obj emulib.obj emumem.obj \
               emuerror.obj emusetup.obj emuemul.obj emutrace.obj 
#

ROM128K.HEX : MAIN5202.BIN
 iunHEX 0 0 $(BIN)\MAIN5202 $(BIN)\ROM128K

MAIN5202.BIN : MAIN5202.OMF
 $(PROM)  $(BIN)\MAIN5202.ABS TO $(BIN)\MAIN5202.BIN ADDRESSES(0e0000H, 0fFFFFH) CHECKSUM

MAIN5202.OMF : MAIN5202.ABS
 $(CV2OMF) $(BIN)\MAIN5202.ABS TO $(BIN)\MAIN5202.OMF

MAIN5202.ABS : MAIN5202.LNK
 $(LOC)  @&&!
            $(BIN)\MAIN5202.LNK TO $(BIN)\$&.ABS &
            NOIC &               Do not generate new segment for register initialization
            ORDER(CLASSES(&
                 FAR_DATA_BEG,FAR_DATA,FAR_DATA_END,&
                 DATA_BEG,&
                 DATA,&
                 CONST,&
                 DATA_END,&
                 MSG,&
                 BSS, &
                 BSS_END,&
                 CODE,&
                 CODE_END&
            )) &
            RESERVE(00H TO 03FFH) &
            ADDRESSES(CLASSES( &
               BOOT(0fff80H),&
               TRACE_MEM(020000H),&
               TBUF(080000h),&
               CODE(0e0000H), DATA_BEG(00400H),&
               STACK(00c400H),&
               DEBSYM(040000H),DEBTYP(048000H)),&
               GROUPS(DGROUP(00400H)) &
            )&
            SEGSIZE(STACK(04000H))&
            MAP &
            ST(BOOT_INIT)&
            BS
!


#               *Explicit Rules*

# .A00  condition definition start!
start.obj : start.a00 commdata.h cppcb.def cpinit.def ioport.def macro.def\
            wromC0.def wromD0.def wromC1.def wromD1.def bdm_cmd.def version.h
bdm5202.obj : bdm5202.a00 bdm_cmd.def const.h macro.def cppcb.def emudebug.h\
              ioport.def version.h
boot.obj : boot.a00 cppcb.def cpinit.def version.h
test.obj : test.a00

# .C condition definition
emucomm.obj: emucomm.c emucomm.h emulib.h emuext.h emutypes.h emuerror.h\
             commdata.h
emumain.obj: emumain.c emucomm.h
emullfw.obj: emullfw.c emullfw.h const.h emutypes.h
emudebug.obj: emudebug.c emullfw.h emucomm.h emudebug.h version.h
emulib.obj: emulib.c emulib.h emutypes.h
emumem.obj: emumem.c emumem.h emutypes.h
emuerror.obj: emuerror.c emuerror.h emutypes.h
emusetup.obj: emusetup.c emusetup.h emutypes.h
emuemul.obj: emuemul.c emuemul.h emutypes.h
emutrace.obj: emutrace.c emutrace.h emutypes.h

#MAIN5202.hex : MAIN5202.abs
#$(OH86) $&
# $(CHKSUM) $&.hex 0 0d0000 0ffffb 0ffffe

MAIN5202.LNK : $(LNK_depends)
 $(LINK) @&&!
             $(BIN)\start.obj,$(BIN)\emucomm.obj,$(BIN)\emumain.obj,&
             $(BIN)\emullfw.obj,$(BIN)\emulib.obj,$(BIN)\emumem.obj,&
             $(BIN)\emuerror.obj,$(BIN)\emusetup.obj,$(BIN)\emutrace.obj,&
             $(BIN)\emuemul.obj,$(BIN)\emudebug.obj,$(BIN)\test.obj, &
             $(BIN)\bdm5202.obj,$(BIN)\boot.obj,$(BIN)\mLIBce.ssi &
             TO $(BIN)\MAIN5202.LNK
!

