/***************************************************************************
**
**  Name:  emusetup.c
**
**  Description:
**     Michelle setup-group routines.
**     include:
**     "Get the identity of the Michelle FW version, HW configuration
**      and HW model type",
**     "Set access size to be byte/word/dword-accessing",
**     "Set or read the memory-write verify-flag",
**     "Control ready using external/internal",
**     "Set or read the memory mapping",
**     "Read all setup information",
**     "Set control signals",
**    * "set or read the wait-state" --- This is a issue to be discussed.
**      We will decide this latter.
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/arcppc/fw/860/emusetup.c_v  $
** 
**    Rev 1.0   18 Jul 1997 15:12:56   cjchen
** Initial revision.
** 
**    Rev 1.0   11 Feb 1997 16:16:56   kevin
** Initial revision.
** 
**    Rev 1.0   03 Jun 1996 14:19:06   gene
** Initial revision.
** 
** Copyright (C) 1992 Microtek International, Inc.
**
****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _EMU_SETUP_
#include "emusetup.h"
#endif

#ifndef _EMU_LIB_
#include "emulib.h"
#endif

#ifndef _EMU_TRACE_
#include "emutrace.h"
#endif

#ifndef _EMU_LLFW_
#include "emullfw.h"
#endif

#ifndef _EMU_EXTERNAL_
#include "emuext.h"
#endif

#include <string.h>
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                         /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/***************************************************************************
**
**  EmuGetStatus
**
**  Description: Michelle setup-group routine, to read the current setting
**               of the Michelle.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." be Normal return
**        "Emulator Fatal Error" for HW error
**        return data -- "length" + "events" + "qualify: + "trigger" +
**                       "MAP" + control signals" +
**                       "ready setting"
**
**                     * "ID" is a issue to be discussed later
**
****************************************************************************/
VOID EmuGetStatus(VOID) {
   //U16 flyFlag;

//  AccessIceFlag(READ_ONE,FLYING,&flyFlag);    // gene
//  if (flyFlag) OutputStatus(CPU_FLY,ON);
//  else if (!CheckEpStop()) OutputStatus(CPU_RUN,ON);
//  else OutputStatus(BROKE,ON);
}

/***************************************************************************
**
**  EmuGetID
**
**  Description: Michelle setup-group routine, to get the emulator's ID to
**               make sure that driver program has connected to a correct
**               emulator.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**        return data -- "length" + "ID"
**
****************************************************************************/
VOID EmuGetID(VOID) {
U8 dataLen;

   OutputStatus(GOOD,OFF);
   dataLen = MAX_ID;
   // get probe,trace,cp board info from llfw and save to idData
   OutData(dataLen,idData,ON);
   OutEnd();
}

/****************************************************************************
**
**  EmuSetAccessSize()
**
**  Description: Michelle setup-group routine, to set the bus access size.
**               "size" = 0 --> Byte-access (8-Bit),
**               "size" = 1 --> Word-access (16-Bit),
**               "size" = 2 --> DWord-access (32-Bit)
**
**  Parameters:
**     input:
**        size -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetAccessSize(SIZE size) {
STATUS status;

   status = AccessIceFlag(WRITE_ONE,SIZE_FLAG,&size);
   OutputStatus(status,ON);/* Before next data add to outputStream. len - 1 */
}

/****************************************************************************
**
**  EmuGetAccessSize()
**
**  Description: Michelle setup-group routine, to set the bus access size.
**               "size" = 0 --> Byte-access (8-Bit),
**               "size" = 1 --> Byte-access (16-Bit),
**               "size" = 2 --> Byte-access (32-Bit)
**
**  Parameters:
**     input:
**        size -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuGetAccessSize(VOID) {
STATUS status;
SIZE size;

   status = AccessIceFlag(READ_ONE,SIZE_FLAG,&size);
   OutputStatus(status,OFF);/* Before next data add to outputStream. len - 1 */
   OutData(sizeof(size),&size,ON);
   OutEnd();

}

/****************************************************************************
**
**  EmuSetWait()
**
**  Description: Michelle setup-group routine, to insert wait state for
**               Michelle. Insert wait state, "count" id the number of
**               clocks of the wait-state.
**
**  Parameters:
**     input:
**        count -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetWait(U16 count) {
   
   OutputStatus(GOOD,ON);/* Before next data add to outputStream. len - 1 */

}


/****************************************************************************
**
**  EmuGetWait()
**
**  Description: Michelle setup-group routine, to insert wait state for
**               Michelle. Insert wait state, "count" id the number of
**               clocks of the wait-state.
**
**  Parameters:
**     input:
**        count -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuGetWait(VOID) {
U16 count;

   AccessIceFlag(READ_ONE,WAIT_FLAG,&count);
   OutputStatus(GOOD,OFF);/* Before next data add to outputStream. len - 1 */
   OutData(sizeof(count),&count,ON);
   OutEnd();

}

/****************************************************************************
**
**  EmuSetSync()
**
**  Description: Michelle setup-group routine, to insert wait state for
**               Michelle. Insert wait state, "count" id the number of
**               clocks of the wait-state.
**
**  Parameters:
**     input:
**        count -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetSync(U16 state) {

   AccessIceFlag(WRITE_ONE,SYNC_FLAG,&state);
   switch (state) {
      case 0:
//         DisableSSI();
//         DisableSSO();
         AccessIceFlag(WRITE_ONE,SYNC_IN,&C_OFF);
        break;
      case 1:
//         EnableSSI();
//         DisableSSO();
         AccessIceFlag(WRITE_ONE,SYNC_IN,&C_ON);
        break;
      case 2:
//         DisableSSI();
//         EnableSSO();
         AccessIceFlag(WRITE_ONE,SYNC_IN,&C_OFF);
        break;
      case 3:
//         EnableSSI();
//         EnableSSO();
         AccessIceFlag(WRITE_ONE,SYNC_IN,&C_ON);
        break;
   }
   OutputStatus(GOOD,ON);/* Before next data add to outputStream. len - 1 */

}

/****************************************************************************
**
**  EmuGetSync()
**
**  Description: Michelle setup-group routine, to insert wait state for
**               Michelle. Insert wait state, "count" id the number of
**               clocks of the wait-state.
**
**  Parameters:
**     input:
**        count -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuGetSync(VOID) {
U16 sync;

   AccessIceFlag(READ_ONE,SYNC_FLAG,&sync);
   OutputStatus(GOOD,OFF);/* Before next data add to outputStream. len - 1 */
   OutData(sizeof(sync),&sync,ON);
   OutEnd();
}

/****************************************************************************
**
**  EmuSetVerify()
**
**  Description: Michelle setup-group routine, to insert wait state for
**               Michelle. Insert wait state, "count" id the number of
**               clocks of the wait-state.
**
**  Parameters:
**     input:
**        count -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetVerify(U16 verifyFlag) {

   AccessIceFlag(WRITE_ONE,VERIFY_FLAG,&verifyFlag);

   OutputStatus(GOOD,ON);/* Before next data add to outputStream. len - 1 */
}

/****************************************************************************
**
**  EmuGetVerify()
**
**  Description: Michelle setup-group routine, to insert wait state for
**               Michelle. Insert wait state, "count" id the number of
**               clocks of the wait-state.
**
**  Parameters:
**     input:
**        count -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuGetVerify(VOID) {
STATUS status;
U16 verifyFlag;

   status = AccessIceFlag(READ_ONE,VERIFY_FLAG,&verifyFlag);
   OutputStatus(status,OFF);/* Before next data add to outputStream. len - 1 */
   OutData(sizeof(verifyFlag),&verifyFlag,ON);
   OutEnd();
}

VOID EmuEnSwBkpt(VOID) {

//   SwbpEnable();
   OutputStatus(GOOD,ON);/* Before next data add to outputStream. len - 1 */
}

VOID EmuDisSwBkpt(VOID) {

//   SwbpDisable();
   OutputStatus(GOOD,ON);/* Before next data add to outputStream. len - 1 */
}

VOID EmuSetBkptCode(BKPT_OP_CODE bkptOpCode) {

//   SelectBreakCode((U16)bkptOpCode);
   OutputStatus(GOOD,ON);/* Before next data add to outputStream. len - 1 */
}

/******************************** E O F ***********************************/

