/****************************************************************************
**
**  Name:  emutypes.h
**
**  Description:
**     Primary type declarations for "Michelle" project.
**     NOTE:  This should not be included explicitly
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/arcppc/fw/860/emutypes.h_v  $
** 
**    Rev 1.3   18 Sep 1997 10:19:30   kevin
** added SET_ISCT_SER and SET_BKPT_NONMASK command IDs
** 
**    Rev 1.2   28 Aug 1997 10:23:20   cjchen
** 
**    Rev 1.1   19 Aug 1997 16:02:58   cjchen
** 
**    Rev 1.0   18 Jul 1997 15:12:58   cjchen
** Initial revision.
** 
** Initial revision.
**
**  Copyright (C) 1997 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _EMU_BASE_TYPES_


                  /****************************
                  *                           *
                  *        DEFINITIONS        *
                  *                           *
                  ****************************/

/* basic definitions */

#define ACK                 0x6
#define NACK                0x15
#define SPACE               0x20
#define FALSE               0x00000000
#define TRUE                !FALSE
#define YES                 TRUE
#define NO                  FALSE
#define ON                  TRUE
#define OFF                 FALSE
#define SUCCESS             0
#define GOOD                SUCCESS
#define OK                  GOOD
//#define MAP_END_RECORD      0xaa55
#define STREAM_BUFF_LEN     512
#define NULL                0
//#define INTER_REG_ADDR 0xfffff000ul

/* Microsoft-style keywords */
#define PASCAL         pascal
#define EXPORT         FAR PASCAL
#define STATIC         static
#define CONST          const
#define PRIVATE        STATIC

/* primary typedef's */
typedef void           VOID;
typedef char           CHAR;
typedef far            FAR;
typedef near           NEAR;
typedef unsigned char  U8;
typedef signed   char  S8;
typedef unsigned int   U16;
typedef signed   int   S16;
typedef unsigned long  U32;
typedef signed   long  S32;
typedef unsigned int   LOOP_VAR;  /* used only as a loop index */
typedef U8             BOOLEAN;
typedef unsigned char  *STRING;
typedef S16            STATUS;
typedef U8             HW_STATUS;
typedef STATUS         ERROR;
typedef STATUS         RETCODE;

#define MAX_STREAM_LEN     0x400

enum {
   NORMAL_RUN = 0,FREE_RUN,FLY_RUN,MONITOR_RUN,TEST_RUN,SRCSTEP_RUN,
}RUN_MODE;

enum {
   I80C188XL = 1, I80C188EA, I80C188EB, I80C188EC,
   I80C186XL,     I80C186EA, I80C186EB, I80C186EC,
   I80166, I80167, I80195, I80196, I80197, M68000, M68302, M68306
}CPU_MODULE;

enum {
   END_TEST, MCE16A, EMM1, EMM2, EMM3, EMM4, COV_RBW_MEMORY, TRACE_BOARD, START_TEST
}FUNCTION_TEST_CMD;

enum { XL_EA = 1, EB, EC} PHY_CPU;

enum {MCE16A_BOARD = 0x20, MCE16B_BOARD = 0x21,
      MCE32A_BOARD = 0x40, MCE32B_BOARD = 0x41
}MCE_BOARD;

typedef enum { /* Motorola address spaces */
   SPACE_UNDEF0, SPACE_UD, SPACE_UP, SPACE_UNDEF3, SPACE_UNDEF4,
   SPACE_SD, SPACE_SP, SPACE_CPU, SPACE_DONT_CARE, SPACE_END = 0x7fff
} ADDR_SPACE;

typedef struct Addr{
   U32 pos;
   U16 space;
}ADDR;

typedef enum {
   FIRMWARE_TYPE,
   FIRMWARE_VER,
   CPU_TYPE,
   CPU_VER,
   TRACE_EXIST,
   INIT_HW_STATUS,
   FRIMWARE_MODULE,
   MAX_ID
}ID_INFO;

/* define the command ID od the Michelle firmware function */
typedef enum {
   COMMAND_START,          /* 0  -- 0x0  */
   GET_ID,                 /* 1  -- 0x1  */ // special command, must place 1st.
   CHECKSUM,               /* 2  -- 0x2  */
   CLR_EVENT,              /* 3  -- 0x3  */
   CLR_TRIG,               /* 4  -- 0x4  */
   COMPARE,                /* 5  -- 0x5  */
   COPY,                   /* 6  -- 0x6  */
   FUNCTION_TEST,          /* 7  -- 0x7  */
   ESC_COMMAND,            /* 8  -- 0x8  */
   FILL,                   /* 9  -- 0x9  */
   GET_ALL_CO_REG,         /* 10 -- 0xa  */
   GET_ALL_INTERNAL_REG,   /* 11 -- 0xb  */
   GET_ALL_REG,            /* 12 -- 0xc  */
   GET_CO_COVERAGE,        /* 13 -- 0xd  */
   GET_CO_REG,             /* 14 -- 0xe  */
   GET_CONTROL,            /* 15 -- 0xf  */
   GET_DEPTH,              /* 16 -- 0x10 */
   GET_EVENT,              /* 17 -- 0x11 */
   GET_MAP,                /* 18 -- 0x12 */
   GET_MAP_SIZE,           /* 19 -- 0x13 */
   GET_MODE,               /* 20 -- 0x14 */
   GET_READY,              /* 21 -- 0x15 */
   GET_REG,                /* 22 -- 0x16 */
   GET_SIZE,               /* 23 -- 0x17 */
   GET_STAT,               /* 24 -- 0x18 */
   GET_SYNC,               /* 25 -- 0x19 */
   GET_VERIFY,             /* 26 -- 0x1a */
   GET_WAIT,               /* 27 -- 0x1b */
   GO_COMMAND,             /* 28 -- 0x1c */
   HALT,                   /* 29 -- 0x1d */
   INPUT,                  /* 30 -- 0x1e */
   LIST_TRACE,             /* 31 -- 0x1f */
   OUTPUT,                 /* 32 -- 0x20 */
   READ_MEM_N,             /* 33 -- 0x21 */
   RESET,                  /* 34 -- 0x22 */
   SEARCH,                 /* 35 -- 0x23 */
   SET_TRACE_BUFF,         /* 36 -- 0x24 */
   SET_CONTROL,            /* 37 -- 0x25 */
   SET_CO_COVERAGE,        /* 38 -- 0x26 */
   SET_CO_REG,             /* 39 -- 0x27 */
   SET_EVENT,              /* 40 -- 0x28 */
   SET_EX_BKPT,            /* 41 -- 0x29 */
   SET_ID,                 /* 42 -- 0x2a */
   SET_MEM_N,              /* 43 -- 0x2b */
   SET_MAP,                /* 44 -- 0x2c */
   SET_MODE,               /* 45 -- 0x2d */
   SET_REG,                /* 46 -- 0x2e */
   SET_READY,              /* 47 -- 0x2f */
   SET_SIZE,               /* 48 -- 0x20 */
   SET_SYNC,               /* 49 -- 0x31 */
   SET_TRACE_BREAK,        /* 50 -- 0x32 */
   SET_TRIG,               /* 51 -- 0x33 */
   SET_TIME_COUNT,         /* 52 -- 0x34 */
   SET_VERIFY,             /* 53 -- 0x35 */
   SET_WAIT,               /* 54 -- 0x36 */
   STEP,                   /* 55 -- 0x37 */
   STEP_ONE,               /* 56 -- 0x38 */
   TEST,                   /* 57 -- 0x39 */
   SET_EXT_EVENT,          /* 58 -- 0x3a */
   SET_ALL_EVENT,          /* 59 -- 0x3b */
   SET_TIMER_REG,          /* 60 -- 0x3c */
   GET_CPU_STATUS,         /* 61 -- 0x3d */
   ABORT,                  /* 62 -- 0x3e */
   GET_TRIG,               /* 63 -- 0x3f */
   GET_LAST_BUFF,          /* 64 -- 0x40 */
   DIAGNOSTIC,             /* 65 -- 0x41 */
   ENABLE_SW_BKPT,         /* 66 -- 0x42 */
   DISABLE_SW_BKPT,        /* 67 -- 0x43 */
   SET_BKPT_CODE,          /* 68 -- 0x44 */
   SET_INT_REG,            /* 69 -- 0x45 */
   GET_INT_REG,            /* 70 -- 0x46 */
   SET_QUAL_TRACE,         /* 71 -- 0x47 */
   DISABLE_QUAL,           /* 72 -- 0x48 */
   TRACE_RESET,            /* 73 -- 0x49 */
   GOEP_DELAY,             /* 74 -- 0x4A */
   SET_UPM,                /* 75 -- 0x4B */
   GET_UPM,                /* 76 -- 0x4C */
   SET_BKPT_NONMASK,       /* 77 -- 0x4D */
   SET_ISCT_SER,           /* 78 -- 0x4E */
   MAX_COMMAND          /* All new command must add before this command. */
} COMMAND_ID;

typedef enum {
   S_BYTE = 0, /* bit 0 ; 1 BYTE */
   S_HALFWORD = 1, /* bit 1 ; 2 BYTES */
   S_WORD = 2  /* bit 2 ; 4 BYTES*/
} SIZE;

typedef enum {
   PHY_CPU_TYPE,
   ESC_FLAG,
   RUNNING,       /*  */
   LAM_EXIT,      /*  */
   EMULATIN,      /*  */
   TIME_OVER,     /*  */
   TRACEING,      /*  */
   VERIFY_FLAG,
   SIZE_FLAG,
   EMM_SIZE,
   TIMER_FLAG,
   MODE_FLAG,
   READY_FLAG,
   WAIT_FLAG,
   SYNC_FLAG,
   TRACE_MODE,
   TRACE_BUFF,
   TRACE_BREAK,
   BUFFER_FILL,
   RESET_FLAG,
   TRACED_BUFF_NO,
   COUNTER1,
   COUNTER0,
   SYNC_IN,
   PENDING,
   EP_RUN,
   FLYING,
   PHY_TRIG_SET,
   CPU_STATUS,
   BROKE_REASON_HIGH_32,
   BROKE_REASON_LOW_32,

   MAX_ICE_FLAG_NO
   /* When you want to add a new flag to ICE_FLAG,
      please add before MAX_ICE_FLAG_NO. */
} ICE_FLAG;

typedef enum {
   HW_ERROR_FLAG,
   LLFW_ERROR,
   HW_ERROR,

   MAX_LLFW_FLAG_NO
   /* When you want to add a new flag to LLFW_FLAG,
      please add before MAX_LLFW_FLAG_NO. */
} LLFW_FLAG;

typedef enum {
   GO_TYPE,
   BKPT,

   MAX_STATUS_FLAG_NO
   /* When you want to add a new status flag to STATUS_FLAG,
      please add before MAX_STATUS_FLAG_NO. */
} STATUS_FLAG;

typedef enum {
   READ_ONE,        /* 0*/
   READ_ALL,        /* 1*/
   WRITE_ONE,       /* 2*/
   WRITE_ALL,       /* 3*/
   CLEAR_ONE,       /* 4*/
   CLEAR_ALL,       /* 5*/
   DISABLE_ONE,     /* 6*/
   DISABLE_ALL,     /* 7*/
   ENABLE_ONE,      /* 8*/
   ENABLE_ALL,      /* 9*/
   FW_WRITE_ALL,    /* 10 used by F/W write back A7/PC after EPstatus,StopEP,etc*/

   MAX_ACCESS_NO
   /* When you want to add a new status flag to ACCESS_MODE,
      please add before MAX_ACCESS_NO. */
}ACCESS_MODE;

typedef enum {
   M68_REG,       /*  */
   INTERNAL_REG
}REG_MODE;

typedef enum {
   R_GPR00,R_GPR01,R_GPR02,R_GPR03,R_GPR04,
   R_GPR05,R_GPR06,R_GPR07,R_GPR08,R_GPR09,
   R_GPR10,R_GPR11,R_GPR12,R_GPR13,R_GPR14,
   R_GPR15,R_GPR16,R_GPR17,R_GPR18,R_GPR19,
   R_GPR20,R_GPR21,R_GPR22,R_GPR23,R_GPR24,
   R_GPR25,R_GPR26,R_GPR27,R_GPR28,R_GPR29,
   R_GPR30,R_GPR31,
                          R_XER,      R_LR,        R_CTR,
   R_DSISR,   R_DAR,      R_DC,       R_SRR0,      R_SRR1,
   R_SPRG0,   R_SPRG1,    R_SPRG2,    R_SPRG3,     R_PVR,
   R_TB_READ, R_TBU_READ, R_TB_WRITE, R_TBU_WRITE, R_EIE,
   R_EID,     E_NRI,      R_CMPA,     R_CMPB,      R_CMPC,
   R_CMPD,    R_ICR,      R_DER,      R_COUNTA,    R_COUNTB,
   R_CMPE,    R_CMPF,     R_CMPG,     R_CMPH,      R_LCTRL1,
   R_LCTRL2,  R_ICTRL,    R_BAR,      R_DPDR,      R_DPIR,
   R_IMMR,    R_IC_CST,   R_IC_ADR,   R_IC_DAT,    R_DC_CST,
   R_DC_ADR,  R_DC_DAT,   R_MI_CTR,   R_MI_AP,     R_MI_EPN,
   R_MI_TWC,  R_MI_RPN,   R_MI_DBCAM, R_MI_DBRAM0, R_MI_DBRAM1,
   R_MD_CTR,  R_M_CASID,  R_MD_AP,    R_MD_EPN,    R_M_TWB,
   R_MD_TWC,  R_MD_RPN,   R_M_TW,     R_MD_DBCAM,  R_MD_DBRAM0,
   R_MD_DBRAM1, R_END=100,
   R_CR=0x80,
   MAX_CPU_REG_NO
}CPU_REG;

typedef enum {
   BREG_PC,
   MAX_BASE_REG_NO
} BASE_REG;

/******************************** Struct type define **********************/
/*
typedef struct Result {
   COMMAND_ID cmdNo;
   U32  status;
   U8   returnValue[100];
}RESULT;
*/

typedef enum { UNDEFINE_ADDR, SINGLE_ADDR, RANGE_ADDR, MASK_ADDR } ADDR_SPEC;
typedef enum { UNDEFINE_DATA = 0, SINGLE_DATA = 1, MASK_DATA = 3 } DATA_SPEC;

typedef U32 EP_ADDR;
typedef U32 EP_DATA;
typedef U16 EP_SPARE;

typedef struct {
   U16 statusFc;           // bit  0  1  2  3  4  5  6
                           //     sp,up,sr,sw,ur,uw,ak  0 = Don't care
   U8 statusDsLow,         // LowByte = 2, HighByte = 1, Word = 0.
      statusDsHigh;        // 0 = Don't care, 0xff : set one.
   U16 statusCsLow,        // bit    8    7   6   5   4   3   2   1   0
       statusCsHigh;       //     DRAM  CS7 CS6 CS5 CS4 CS3 CS2 CS1 CS0
                           // 0 = Don't care , 0xffff select one
}EP_STATUS;

typedef struct {
   U32 status2Low,
       status2High;
}EP_STATUS2;

typedef struct {
   U16 enable;
   ADDR_SPEC addrSpec;
   EP_ADDR addrLow;
   EP_ADDR addrHigh;
   EP_SPARE spareLow,     // 8 bit spare, High byte is not used.
            spareHigh;    // 0: don't care  1: set.
   DATA_SPEC dataSpec;
   EP_DATA dataLow;
   EP_DATA dataHigh;
   U16 statusFlag;
   EP_STATUS status;
   EP_STATUS2 status2;
   U8  notCondition;      // bit 0: address 1:data
}BUS_EVENT;

typedef struct {
  U16 enable;
  ADDR addr; /* CS:IP */
}EXEC_EVENT;

/*
typedef struct {
   U16  qFlag;
   U32  startAddr,
        endAddr;
   U16 statusFlag;  // 0: use stauts, MICEview ; 1:use status2, PowerView.
   EP_STATUS status;
   EP_STATUS2 status2;
   U16  traceBitData,
        traceBitWild;
}QUALIFY_LIST;
*/

typedef struct {
   U16 traceBufId;
   S32 startFrame;
   U16 traceform;
   U16 frameLen;
}TRACE_HEAD;

typedef enum {
A_LINE = 0xa0,F_LINE = 0xf0,
}BKPT_OP_CODE;

/******************************* E O F ***********************************/



































