#
#  Name: makefile.mak
#
#  Description: Make definitions for TBird shared data server
#
#  COPYRIGHT (C) 1992 MICROTEK INTERNATIONAL, INC.
#

.AUTODEPEND
#.SWAP

#
# files
#
SRC = .
ASMSRC = asm
BIN = bin
CCDIR = C:\tools\C600\bin
INC = C:\tools\C600\include
LNKDIR = C:\tools\lnkloc\bin
TMPDIR = c:\temp

#
# paths
#
.PATH.lst = $(SRC)
.PATH.c   = $(SRC)
.PATH.db  = $(ASMSRC)
.PATH.tbl = $(ASMSRC)
.PATH.equ = $(ASMSRC)
.PATH.def = $(ASMSRC)
.PATH.asm = $(ASMSRC)
.PATH.a00 = $(ASMSRC)
.PATH.obj = $(BIN)
.PATH.lib = $(BIN)
.PATH.ssi = $(BIN)
.PATH.lnk = $(BIN)
.PATH.ABS = $(BIN)
.PATH.HEX = $(BIN)

#               *Translator Definitions*
LINK = $(LNKDIR)\xlink86
LOC = $(LNKDIR)\xloc86
PROM = $(LNKDIR)\prom86
OH86 = $(LNKDIR)\xoh86
CV2OMF = $(LNKDIR)\cv2omf
CONV = $(USDDIR)\CONVERT
CHKSUM = mice3chk
CC = $(CCDIR)\cl
MASM = $(CCDIR)\masm
CFLAG = /AM /G1 /Gs /Od /Oi /Zp /c /FPa /Zi /W3
CODEGEN = codegen

#               *Implicit Rules*
.C.obj:
#$(CC) $(CFLAG) /I. /I./asm /I$(INC) /Fa$(BIN)\$& /Fo$(SRC)\bin\$&.obj $(SRC)\$&.C
 $(CC) $(CFLAG) /I. /I./asm /I$(INC) /Fo$(SRC)\bin\$&.obj $(SRC)\$&.C

.A00.obj:
 $(MASM) /Mx /Zi /W2 /z /Zd /I$(ASMSRC) $(ASMSRC)\$&.A00,$(BIN)\$&,$(SRC)\ERR;

# define all objs
LNK_depends =  start.obj bios.obj boot.obj jtaglib.obj \
               bdm860.obj bdm_cmd.obj \
               emucomm.obj emumain.obj \
               emuemul.obj emullfw.obj emulib.obj emumem.obj \
               emuerror.obj emusetup.obj emutrace.obj
#


MPC860.HEX : MPC860.BIN
 iunHEX 0 0 $(BIN)\MPC860

MPC860.BIN : MPC860.OMF
 $(PROM)  $(BIN)\MPC860.ABS TO $(BIN)\MPC860.BIN ADDRESSES(0E0000H, 0FBFEFH) CHECKSUM

MPC860.OMF : MPC860.ABS
 $(CV2OMF) $(BIN)\MPC860.ABS TO $(BIN)\MPC860.OMF

MPC860.ABS : MPC860.LNK
 $(LOC)  @&&!
            $(BIN)\MPC860.LNK TO $(BIN)\$&.ABS &
            NOIC &               Do not generate new segment for register initialization
            ORDER(CLASSES(&
                 FAR_DATA_BEG,FAR_DATA,FAR_DATA_END,&
                 DATA_BEG,&
                 DATA,&
                 CONST,&
                 DATA_END,&
                 MSG,&
                 BSS, &
                 BSS_END,&
                 CODE,&
                 CODE_END,&
                 FPGA&
            )) &
            RESERVE(00H TO 03FFH) &
            ADDRESSES(CLASSES( &
               BIOS(0FC000h),&
               BOOT(0fff80H),&
               CODE(0e0000H), DATA_BEG(00400H),&
               STACK(00c400H),&
               DEBSYM(040000H),DEBTYP(048000H)),&
               GROUPS(DGROUP(00400H)) &
            )&
            SEGSIZE(STACK(04000H))&
            MAP &
            ST(BOOT_INIT)&
            BS
!


#               *Explicit Rules*

# .A00  condition definition start!
start.obj   : start.a00 commdata.h cppcb.def cpinit.def macro.def\
              strings.def xlx_bdm.def jtagport.def
jtaglib.obj : jtaglib.a00 cppcb.def cpinit.def macro.def jtagport.def
bios.obj    : bios.a00
boot.obj    : boot.a00 cppcb.def cpinit.def
bdm860.obj  : bdm860.a00 reg.equ bdm_cmd.equ
bdm_cmd.obj : bdm_cmd.a00 reg.equ bdm_cmd.equ bdm_cmd.def bdm_cmd.tbl

# .C condition definition
emucomm.obj: emucomm.c emutypes.h emucomm.h commdata.h emullfw.h strings.def\
             emuext.h const.h emulib.h
emumain.obj: emumain.c emutypes.h emucomm.h commdata.h emullfw.h strings.def\
             emuglb.h const.h version.h emuemul.h
emuemul.obj: emuemul.c emuemul.h emutrace.h emullfw.h emuext.h
emullfw.obj: emullfw.c emullfw.h const.h emutypes.h
emulib.obj: emulib.c emulib.h emutypes.h
emumem.obj: emumem.c emumem.h emutypes.h
emuerror.obj: emuerror.c emuerror.h emutypes.h
emusetup.obj: emusetup.c emusetup.h emutypes.h
emutrace.obj: emutrace.c emutrace.h emutypes.h emullfw.h

MPC860.LNK : $(LNK_depends)
 $(LINK) @&&!
             $(BIN)\start.obj,$(BIN)\bios.obj,$(BIN)\boot.obj,&
             $(BIN)\bdm860.obj,$(BIN)\bdm_cmd.obj,&
             $(BIN)\jtaglib.obj,&
             $(BIN)\emucomm.obj,$(BIN)\emumain.obj,&
             $(BIN)\emuemul.obj,$(BIN)\emullfw.obj,$(BIN)\emulib.obj,&
             $(BIN)\emumem.obj,$(BIN)\emuerror.obj,$(BIN)\emusetup.obj,&
             $(BIN)\emutrace.obj,$(BIN)\mLIBce.ssi &
             TO $(BIN)\MPC860.LNK
!

