/****************************************************************************
**
**  Name:  network.c
**
**  Description:
**     Routines to support the network server function.
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/arcppc/inc/network.h_v  $
** 
**    Rev 1.0   15 Jan 1997 17:36:12   kevin
** Initial revision.
** 
**    Rev 1.0   03 Jun 1996 11:25:12   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 10:26:12   gene
** Initial revision.
**  
**     Rev 1.1   21 Aug 1991 11:23:22   tom
**  Updated types, include file format.
 * 
 *    Rev 1.0   14 Jun 1991 13:36:34   jim
 * Initial revision.
**
**  $Header:   S:/tbird/arcppc/inc/network.h_v   1.0   15 Jan 1997 17:36:12   kevin  $
**
*****************************************************************************/

#define _NETWORK_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASETYPE_
#include "basetype.h"
#endif
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define NUM_TMODS 3

typedef U8 *PROBE;

typedef U32 TBIRDID;

typedef struct {
   TBIRDID id;
   PROBE   probe;
   BOOLEAN paPresent;
   BOOLEAN tmodPresent[NUM_TMODS];
} TBIRD_CONFIG;

typedef struct {
   U32        numTBird;
   TBIRD_CONFIG *config;
} NETWORK_CONFIG;

                        /****************************
                         *                          *
                         *        PROTOTYPES        *
                         *                          *
                         ****************************/

/****************************************************************************
**
**  NetConnect
**
**  Description: 
**     When the server receives this command it will ask the protocol software
**     to establish a virtual circuit.  The type of circuit (e.g. TCP/IP or
**     SPX/IPX ) will be network specific.  When the connected TBird has an
**     unsolicited message for the host, the WakeUp function will be called. 
**  
**  Parameters:
**     input:
**        id:  Identification of TBird to connect to.
**        NetWakeUp:  Function that is called when an unsolicited message is
**           received.
**
*****************************************************************************/
RETCODE EXPORT NetConnect (TBIRDID *id, RETCODE (*NetWakeUp)());

/****************************************************************************
**
**  NetDisconnect
**
**  Description: 
**     When the server receives this command it will ask the protocol software
**     to destory the virtual circuit that was established by NetConnect().
**  
**  Parameters:
**     input:
**        id:  Identification of TBird to disconnect from.
**
*****************************************************************************/
RETCODE EXPORT NetDisconnect (TBIRDID *id);

/****************************************************************************
**
**  NetGetConfig
**
**  Description: 
**     When the server receives this command, it will interogate the network
**     for ALL TBirds that are connected, and request their configuration.
**  
**  Parameters:
**     input:
**        tbirdConfig:  A structure containing an array of configuration
**           elements.  There is an element for each TBird on the network.
**           Each element contains the probe that is connected and the number
**           TMods installed.
**           NOTE : TBIRDID is added by the server, not stored on the TBird.
**
*****************************************************************************/
RETCODE EXPORT NetGetConfig (NETWORK_CONFIG tbirdConfig);

/****************************************************************************
**
**  NetSendData
**
**  Description: 
**     When the server receives this command it will ask the protocol software
**     to start a send operations.
**  
**  Parameters:
**     input:
**        id:  Identification of TBird to send data to.
**        len:  The length (number of bytes) of the output data buffer.
**        dataBuf:  A pointer to a buffer that contains the message to
**           be sent to the TBird.
**        rtnLen:  The address of a variable that will contain the
**           length of the returned message.         
**        rtnDataBuf:  The address of a buffer that will receive the return
**           message for the selected TBird.
**        NetReceive:  A pointer to the function the caller wants called when
**           a response message is sent by the TBird.
**
*****************************************************************************/
RETCODE EXPORT NetSendData (TBIRDID *id, U32 len, U8 *dataBuf, U32 *rtnLen,
   U8 *rtnDataBuf, RETCODE (*NetReceive)());

/****************************************************************************
**
**  NetSetLoopBack
**
**  Description: 
**     When the server receives this command, it will ask the protocol software
**     to place itself and the LAN board into "loop-back mode" for testing.
**     It is expected that whoever issues this command will also send
**     a message and test that the response message is identical.  Also, the
**     caller will issue the SetPassThru command to return the network to
**     normal mode.
**  
**  Parameters:
**     None.
**
*****************************************************************************/
RETCODE EXPORT NetSetLoopBack (VOID);

/****************************************************************************
**
**  NetSetPassThru
**
**  Description: 
**     When the server receives this command, it will ask the protocol software
**     to place itself and the LAN board into a normal operating mode.
**  
**  Parameters:
**     None.
**
*****************************************************************************/
RETCODE EXPORT NetSetPassThru (VOID);

/******************************** E O F ***********************************/
