/****************************************************************************
**
**  Name:  proc.h
**
**  Description:
**     Header file for processor dependent calls
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arcppc/inc/proc.h_v  $
** 
**    Rev 1.2   17 Jan 1997 14:21:12   kevin
** added PowerPC family
** 
**    Rev 1.1   17 Jan 1997 14:10:22   kevin
** added PPC 860 and 603e
** 
**    Rev 1.0   15 Jan 1997 17:36:14   kevin
** Initial revision.
** 
**    Rev 1.0   03 Jun 1996 11:25:18   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 10:26:14   gene
** Initial revision.
** 
**    Rev 1.20   19 Apr 1994 16:09:06   marilyn
** Fixed typo in ProcInsertSpecificCpu prototype.
** 
**    Rev 1.19   22 Mar 1994 10:27:08   marilyn
** Added ProcInsertSpecificCpu.
** 
**    Rev 1.18   17 Mar 1994 10:42:12   tom
** C++ reserved word "template" caused the file to cause compile errors when
** included in .cpp files.
** 
**    Rev 1.17   16 Mar 1994 14:38:14   ernie
** Added ProcInsertSystemName function
** 
**    Rev 1.16   11 Mar 1994 10:54:16   marilyn
** Added PROC_DWORD to PROC_INSTR_FETCH_SIZE enum.
** 
**    Rev 1.15   03 Mar 1994 11:58:58   john
** Added definition for CPU32+
** 
**    Rev 1.14   28 Feb 1994 16:31:28   marilyn
** Removed temporary address specific interfaces to the address server.
** 
**    Rev 1.13   14 Feb 1994 13:11:52   marilyn
** Updated for intel processor support.  Address specific routines moved to
** the address server.
** 
**    Rev 1.12   15 Jun 1993 11:22:30   mindy
** 
**    Rev 1.11   05 May 1993 15:26:12   doug
** support demonstration (no hardware) version of software
** 
**    Rev 1.10   07 Apr 1993 17:40:32   mindy
** added two routines for trace/event generic support
** 
**    Rev 1.9   01 Apr 1993 13:03:50   ernie
** Changed reserved name 'template' in prototype to work with C++
** 
**    Rev 1.8   31 Mar 1993 13:45:22   ernie
** Added ProcInsertSpecificProcessor() and ProcInsertCpu() entry points.
** These are used by server authors to genericize their code.  Using these
** calls, we can add new processors without having to change most servers,
** even those which use processor-specific configuration files.  These
** calls should be used to construct the filename rather than hardcoding
** the name in each server.
** 
**    Rev 1.7   31 Mar 1993 08:26:56   ernie
** Added extern C so this file can be used by C++ modules
** 
**    Rev 1.6   30 Mar 1993 07:59:44   ernie
** Added ProcReturnCpu() entry point
** 
**    Rev 1.5   12 Jan 1993 09:28:46   john
** changed prototype for returnspecificprocessor
** 
**    Rev 1.4   10 Dec 1992 11:18:40   john
** Added function call to allow host to determine what system it is
** attached to.
** 
**    Rev 1.3   17 Aug 1992 09:17:00   brucea
** Added: ProcReturnMaxInputAddrDigits, ProcReturnMaxOutputAddrDigits
** 
**    Rev 1.2   14 Aug 1992 17:55:08   brucea
** Changed: PROC_SPECIFIC_PROCESSOR enum to include MC in the front of the
**    processor name
** Added: ProcReturnMaxInputAddress
**        ProcReturnMaxOutputAddress
**        ProcReturnProcessorName
** 
**    Rev 1.1   14 Jul 1992 14:34:00   brucea
** Added: ProcReturnSpecificProcessor
** Changed: all interfaces to return RETCODE and pass param by reference
** 
**    Rev 1.0   13 Jul 1992 11:23:16   brucea
** Initial revision.
** 
**  $Header:   S:/tbird/arcppc/inc/proc.h_v   1.2   17 Jan 1997 14:21:12   kevin  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _PROC_
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _SDTEMPL_
#include "sdtempl.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

                       /****************************
                        *                          *
                        *          ERRORS          *
                        *                          *
                        ****************************/



                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

typedef enum {
   PROC_CPU_68000,
   PROC_CPU_68010,
   PROC_CPU_68020,
   PROC_CPU_68030,
   PROC_CPU_68040,
   PROC_CPU_CPU32,
   PROC_CPU_CPU32P,
   PROC_CPU_CPU16,
   PROC_CPU_80186,
   PROC_CPU_80386,
   PROC_CPU_80486,
   PROC_CPU_POWERPC,
   PROC_CPU_DUMMY = 0xFFFF
} PROC_CPU;

typedef enum {
   LITTLE_ENDIAN,
   BIG_ENDIAN
} ENDIAN_TYPE;

typedef enum {
   FAMILY_UNKNOWN, /* treated as a 32 bit linear (logical) space */
   FAMILY_68K, /* Motorola 68k family */
   FAMILY_POWERPC, /* PowerPC family */
   FAMILY_X86 /* Intel (and others) X86 family */
} PROCESSOR_FAMILY;

typedef enum {
   PROC_BYTE,
   PROC_WORD,
   PROC_LONG,
   PROC_DWORD
} PROC_INSTR_FETCH_SIZE;

typedef enum {
   PROC_POWERPACK,
   PROC_POWERSCOPE,
   PROC_MICEPACK,
   PROC_DUMMY = 0xFFFF
} PROC_SYSTEM_TYPE;

#define PROC_MAX_PROCESSOR_NAME 16

                       /****************************
                        *                          *
                        *    PUBLIC PROTOTYPES     *
                        *                          *
                        ****************************/


//--------------------------------------------------------------------------
// ProcReturnCpu
//
// Purpose: returns type of cpu installed (cpu16, cpu32, etc)
//
// Output parameter:
//    cpu = cpu installed
//--------------------------------------------------------------------------
RETCODE EXPORT ProcReturnCpu(PROC_CPU FAR *cpu);


//--------------------------------------------------------------------------
// ProcReturnDemonstrationVersion
//
// Purpose: returns whether the software is a no hardware (demonstration)
//          version or is a hardware version.
//
// Output parameter:
//    demoVersion:  true if demo, false if regular hardware version
//--------------------------------------------------------------------------
RETCODE EXPORT ProcReturnDemonstrationVersion(BOOLEAN FAR *demoVersion);


//--------------------------------------------------------------------------
// ProcGetProcessorName
//
// Purpose: returns name string given a processor enumeration
//
// Input:
//    specificProcessor: PROBE_TYPE enumeration
// Output:
//    processorName: processor name string
//--------------------------------------------------------------------------
RETCODE EXPORT ProcGetProcessorName(PROBE_TYPE specificProcessor,
                                    LPSTR processorName);

//--------------------------------------------------------------------------
// ProcGetProcessorType
//
// Purpose: returns processor enumeration given name string 
//
// Input:
//    processorName: processor name string
// Output:
//    specificProcessor: PROBE_TYPE enumeration
//--------------------------------------------------------------------------
RETCODE EXPORT ProcGetProcessorType(LPSTR processorName,
                                    PROC_SYSTEM_TYPE system,
                                    PROBE_TYPE *specificProcessor);


//--------------------------------------------------------------------------
// ProcReturnByteOrder
//
// Purpose: returns type of bus - little endian or big endian
//
// Output parameter:
//    byteOrder: ordering of data
//       low byte first (LITTLE_ENDIAN) e.g. Intel, or
//       high byte first (BIG_ENDIAN)   e.g. Moto
//--------------------------------------------------------------------------
RETCODE EXPORT ProcReturnByteOrder(ENDIAN_TYPE FAR *byteOrder);


//--------------------------------------------------------------------------
// ProcReturnBytesPerInstr
//
// Output parameter:
//    bytesPerInstr: minimum number of bytes making up an instruction
//          e.g. X86 = 1, 680X0 = 2
//--------------------------------------------------------------------------
RETCODE EXPORT ProcReturnBytesPerInstr(U16 FAR *bytesPerInstr);


//--------------------------------------------------------------------------
// ProcReturnFetchBoundary
//
// Purpose:
//    returns the instruction fetch boundary; i.e. what the smallest
//    address boundary the processor fetches instructions;
//    e.g. 680X0 = 4, 68332 = 2 (width of data bus)
//    Used for guaranteeing that address triggers are set up so they will
//    see the code fetch.  It is possible to set an address that will
//    never be seen on the address bus, and this should be avoided.  TBird
//    SW should warn the user when they enter this condition.
//
// Output parameter:
//    fetchBoundary: byte, word, or long
//--------------------------------------------------------------------------
RETCODE EXPORT
ProcReturnFetchBoundary(PROC_INSTR_FETCH_SIZE FAR *fetchBoundary);


//--------------------------------------------------------------------------
// ProcReturnProcFamily
//
// Purpose: returns the type of processor family
//
// Output parameter:
//    procFamily: can be used to steer code to handle processor capabilities
//       in a certain way.
//--------------------------------------------------------------------------
RETCODE EXPORT ProcReturnProcFamily(PROCESSOR_FAMILY FAR *procFamily);


//--------------------------------------------------------------------------
// ProcReturnSpecificProcessor
//
// Purpose: returns the specific processor type;
//
// Output parameter:
//    specificProc: can be used when specific information is required of a
//    processor to determine what the code should do
//--------------------------------------------------------------------------
RETCODE EXPORT
ProcReturnSpecificProcessor(PROBE_TYPE FAR *specificProcessor);


//--------------------------------------------------------------------------
// ProcReturnProcessorName
//
// Output parameter:
//    processorName: string pointer to memory filled in with cvurrent
//                   processor name the size will not exceed 20 characters
//--------------------------------------------------------------------------
RETCODE EXPORT
ProcReturnProcessorName(LPSTR processorName);

//--------------------------------------------------------------------------
// ProcReturnSystemType
//
// Purpose: return the type of system the host is connecting to.
//          ie. powerpack, powerscope, micepack...
//
// Output parameter:
//--------------------------------------------------------------------------
RETCODE EXPORT
ProcReturnSystemType(PROC_SYSTEM_TYPE *systemType);

//--------------------------------------------------------------------------
// ProcInsertSpecificProcessor
//
// Purpose: Create a filename from a template string and the specific
//  processor type.  Allows callers to remain unchanged when new processors
//  are added.  Does sprintf(lpResult, lpTemplate, <processor number>)
//  operation.
//
// NOTE: processor codes are limited to 5 characters maximum.  If using
// this interface to create file names please consider the 8 character
// maximum of DOS file names.
//--------------------------------------------------------------------------
RETCODE EXPORT ProcInsertSpecificProcessor(LPSTR lpTemplate, LPSTR lpResult);

//--------------------------------------------------------------------------
// ProcInsertSystemName
//
// Purpose: Create a filename from a template string and the specific
//  system name.  Allows callers to remain unchanged when new processors
//  are added.  Does sprintf(lpResult, lpTemplate, <system name>)
//  operation.  Example:  pp332, mp306, etc.
//--------------------------------------------------------------------------
RETCODE EXPORT ProcInsertSystemName(LPSTR templateString, LPSTR result);

//--------------------------------------------------------------------------
// ProcInsertCpu
//
// Purpose: Create a filename from a template string and the cpu type.
//  Allows callers to remain unchanged when new cpu types
//  are added.  Does sprintf(lpResult, lpTemplate, <cpu type>) operation.
//
// NOTE: processor type codes are limited to 5 characters maximum.  If using
// this interface to create file names please consider the 8 character
// maximum of DOS file names.
//--------------------------------------------------------------------------
RETCODE EXPORT ProcInsertCpu(LPSTR lpTemplate, LPSTR lpResult);

//--------------------------------------------------------------------------
// ProcInsertSpecificCpu
//
// Purpose: Create a filename from a template string based on the cpu
//  type.  When cpu type does not differentiate between processors at the
//  signal level, returns a more specific cpu name.
//  Allows callers to remain unchanged when new cpu types
//  are added.  Does sprintf(lpResult, lpTemplate, <cpu type>) operation.
//
// NOTE: processor type codes are limited to 5 characters maximum.  If using
// this interface to create file names please consider the 8 character
// maximum of DOS file names.
//--------------------------------------------------------------------------
RETCODE EXPORT ProcInsertSpecificCpu(LPSTR lpTemplate, LPSTR lpResult);

//--------------------------------------------------------------------------
// ProcReturnFunctionCodesMapable
//
// ** MOTOROLA SPECIFIC **
//
// Purpose: Returns TRUE if function codes pins (fc2-0) can be mapped.  This
//          implies there are times when the address space is not available
//          because the output on fc2-0 is acting as a chip select or io
//          pin.
//
// Output parameter:
//--------------------------------------------------------------------------
RETCODE EXPORT
ProcReturnFunctionCodesMapable(BOOLEAN FAR *mapable);

//--------------------------------------------------------------------------
// ProcReturnBusControlMapable
//
// ** MOTOROLA SPECIFIC **
//
// Purpose: Returns TRUE if bus control pins (br, bg, bgack) can be mapped.
//          If mappable the output on (br, bg, bgack) could be acting as
//          either chip selects or io pins.
//
// Output parameter:
//--------------------------------------------------------------------------
RETCODE EXPORT
ProcReturnBusControlMapable(BOOLEAN FAR *mapable);

//--------------------------------------------------------------------------
// ProcDefaultStackSize
//
// ** MOTOROLA SPECIFIC **
//
// Purpose: Returns the number of bytes the processor uses as its default.
//          All variables are rounded to this number of bytes when pushed.
//
//--------------------------------------------------------------------------
RETCODE EXPORT ProcDefaultStackSize(U32 FAR *size);

/**************************************************************************
**
** InitCServer
**
** Description: Initialize the commands for the Proc Server.
**
** Parameters:
**    input:
**       cliHandle:  CLI Server Handle
**       dllHandle:  DLL Handle.
**
**    output: None
**
***************************************************************************/
RETCODE EXPORT InitCServer(HANDLE cliHandle, HANDLE dllHandle);

/***************************************************************************
**
**  ProcTestMode
**
**  description:
**     Set testing mode for the proc server.  In testing mode the SDS
**     is ignored and the testCpu is used as the specific processor.
**
**  input:
**     cmdString:  input text
**     argc:  argument count
**     argv:  offsets into cmdString where arguments start
**
**  output:
**     none
**
*****************************************************************************/
RETCODE EXPORT ProcTestMode(LPSTR cmdString, U32 argc, U32 argv[]);

/***************************************************************************
**
**  ProcTestCpu
**
**  description:
**     Set testing cpu for the proc server.  In testing mode the SDS
**     is ignored and the testCpu is used as the specific processor.
**
**  input:
**     cmdString:  input text
**     argc:  argument count
**     argv:  offsets into cmdString where arguments start
**
**  output:
**     none
**
*****************************************************************************/
RETCODE EXPORT ProcTestCpu(LPSTR cmdString, U32 argc, U32 argv[]);


/***************************************************************************
**
**  ProcTestDump
**
**  description:
**     Dump out all processor specific information to the shell.
**     Performs code coverage type testing for a processor.
**
**  input:
**     cmdString:  input text
**     argc:  argument count
**     argv:  offsets into cmdString where arguments start
**
**  output:
**     none
**
*****************************************************************************/
RETCODE EXPORT ProcTestDump(LPSTR cmdString, U32 argc, U32 argv[]);


#ifdef __cplusplus
}
#endif
//******************************** E O F ***********************************/
