/****************************************************************************
**
**  Name:  sdprobe.h
**
**  Description:
**     Processor-specific shared data assignments of registers and signals
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/arcppc/inc/sdprobe.h_v  $
** 
**    Rev 1.1   11 Mar 1997 11:16:06   kevin
** Got rid of unused definitions
** 
**    Rev 1.0   15 Jan 1997 17:36:16   kevin
** Initial revision.
** 
**    Rev 1.0   03 Jun 1996 11:25:22   gene
** Initial revision.
** 
**    Rev 1.0   14 Sep 1995 14:22:18   kevin
** Initial revision.
** 
**    Rev 1.20   18 May 1994 09:39:04   dennis
** Added register and signal descriptions for 68040.
** 
**    Rev 1.19   10 May 1994 10:04:46   ernie
** Added 386 support: SD_PMODE, SD_COP_TYPE, register definitions, and
** signal definitions.
** 
**    Rev 1.18   21 Apr 1994 16:24:58   john
** Added SIM_VALID member
** 
**    Rev 1.17   30 Mar 1994 15:02:12   STEVE
** Forgot to include definition of BDM_SPEED.
** 
**    Rev 1.16   30 Mar 1994 10:38:08   ernie
** Added bdmspeed member
** 
**    Rev 1.15   04 Mar 1994 10:43:32   john
** Added definitions for CPU32+ signals
** 
**    Rev 1.14   07 Oct 1993 12:40:08   ernie
** Added SD_STEP_MASK member
** 
**    Rev 1.13   22 Jul 1993 14:46:44   mindy
** changed fw_lines to avoid crossing boundry
** 
**    Rev 1.12   22 Jul 1993 12:18:34   mindy
** made fwline area larger.
** 
**    Rev 1.11   13 Jul 1993 08:12:14   ernie
** Added bus error retry member
** 
**    Rev 1.10   26 May 1993 10:45:56   ernie
** Reduced number of characters in an sd name
** 
**    Rev 1.9   24 Mar 1993 08:27:16   ernie
** Merged branch
** 
**    Rev 1.8.1.1   05 Mar 1993 15:12:06   ernie
** Added cpu16 register names
** 
**    Rev 1.8.1.0   25 Feb 1993 08:03:46   ernie
** No change.
** 
**    Rev 1.8   16 Dec 1992 15:36:52   mindy
** moved dq to fw
** 
**    Rev 1.7   09 Dec 1992 10:40:26   mindy
** changed dq'r interface
** 
**    Rev 1.6   02 Nov 1992 12:53:32   ernie
** Added abort for dq sync function
** 
**    Rev 1.5   14 Oct 1992 14:44:44   ernie
** Added dequeuer sync-up interfaces
** 
**    Rev 1.4   14 Sep 1992 08:12:50   ernie
** Added SD_SIM_ADDRESS shared data member
** 
**    Rev 1.3   19 Aug 1992 08:18:06   ernie
** Added processor-specific shared data members for configuring chip-
** select hardware.
** 
**    Rev 1.2   05 Aug 1992 15:31:16   ernie
** Added hidden registers to register list for diagnostic purposes.
** 
**    Rev 1.1   21 Jul 1992 12:40:38   doug
** a) the pc, stack, and frame pointers must be first 3
** b) added a7 to simplify stack code (firmware handles overlaps)
** 
**    Rev 1.0   20 Jul 1992 09:44:48   doug
** Initial revision.
** 
**  $Header:   S:/tbird/arcppc/inc/sdprobe.h_v   1.1   11 Mar 1997 11:16:06   kevin  $
**
*****************************************************************************/
#define _SDPROBE_

#ifndef _SDTEMPL_
#include "sdtempl.h"
#endif

#ifndef _SDNUM_
#include "sdnum.h"
#endif

typedef enum {
   BDM_SLOW, BDM_FAST,
   BDM_END=0x7fff
} BDM_SPEED;

//vvv typedef enum {
//vvv   PMODE_REAL, PMODE_V86, PMODE_P16, PMODE_P32, PMODE_SMM,
//vvv   PMODE_END=0x7fff
//vvv } PMODE;

typedef enum {
   COP_NONE, COP_287, COP_387,
   COP_END=0x7fff
} COP_TYPE;

typedef struct {
   S32 frameNo;
   U32 addr;
   BOOLEAN inst;
   BOOLEAN write;
   U16 data[9];
} FW_LINES;

/* CPU32 register names */
#define SD_PC SD_REG00
#define SD_A7 SD_REG01
#define SD_A6 SD_REG02
#define SD_D0 SD_REG03
#define SD_D1 SD_REG04
#define SD_D2 SD_REG05
#define SD_D3 SD_REG06
#define SD_D4 SD_REG07
#define SD_D5 SD_REG08
#define SD_D6 SD_REG09
#define SD_D7 SD_REG0A
#define SD_A0 SD_REG0B
#define SD_A1 SD_REG0C
#define SD_A2 SD_REG0D
#define SD_A3 SD_REG0E
#define SD_A4 SD_REG0F
#define SD_A5 SD_REG10
#define SD_SR SD_REG11
#define SD_SSP SD_REG12
#define SD_USP SD_REG13
#define SD_SFC SD_REG14
#define SD_DFC SD_REG15
#define SD_VBR SD_REG16
#define SD_FAR SD_REG17
#define SD_PCC SD_REG18
#define SD_SSW SD_REG19

/* Numeric definitions for registers */
#define SDN_PC SDN_REG00
#define SDN_SP SDN_REG01
#define SDN_SR SDN_REG02

/* CPU32 and CPU16 signal names */
#define SD_CLK_SIG   SD_SIG00
#define SD_RESET_SIG SD_SIG01

#define SDN_CLK_SIG   SDN_SIG00
#define SDN_RESET_SIG SDN_SIG01

/* CPU32P signal names */
#define SD_CLK_SIG   SD_SIG00
#define SD_RESETH_SIG SD_SIG01
#define SD_RESETS_SIG SD_SIG02

#define SDN_CLK_SIG   SDN_SIG00
#define SDN_RESETH_SIG SDN_SIG01
#define SDN_RESETS_SIG SDN_SIG02

/* 386 signals */
#define SD_READY_SIG  SD_SIG00
#define SD_RESET_SIG  SD_SIG01
#define SD_HOLD_SIG   SD_SIG02
#define SD_NMI_SIG    SD_SIG03
#define SD_INTR_SIG   SD_SIG04
#define SD_INT0_3_SIG SD_SIG04  /* 386EX naming */
#define SD_A20M_SIG   SD_SIG05
#define SD_INT4_7_SIG SD_SIG05  /* 386EX naming */
#define SD_NA_SIG     SD_SIG06
#define SD_SMI_SIG    SD_SIG07
#define SD_COP_SIG    SD_SIG08

#define SDN_READY_SIG  SDN_SIG00
#define SDN_RESET_SIG  SDN_SIG01
#define SDN_HOLD_SIG   SDN_SIG02
#define SDN_NMI_SIG    SDN_SIG03
#define SDN_INTR_SIG   SDN_SIG04
#define SDN_INT0_3_SIG SDN_SIG04  /* 386EX naming */
#define SDN_A20M_SIG   SDN_SIG05
#define SDN_INT4_7_SIG SDN_SIG05  /* 386EX naming */
#define SDN_NA_SIG     SDN_SIG06
#define SDN_SMI_SIG    SDN_SIG07
#define SDN_COP_SIG    SDN_SIG08

/* 68040 signals */
#define SD_CDIS_SIG SD_SIG00
#define SD_RSTI_SIG SD_SIG01
#define SD_TEA_SIG SD_SIG02
#define SD_IPL_SIG SD_SIG03
#define SD_MDIS_SIG SD_SIG04

/* 68040 signals */
#define SDN_CDIS_SIG SDN_SIG00
#define SDN_RSTI_SIG SDN_SIG01
#define SDN_TEA_SIG SDN_SIG02
#define SDN_IPL_SIG SDN_SIG03
#define SDN_MDIS_SIG SDN_SIG04

/* Defines for cpu32 and cpu32+ */
#define NUM_REGISTERS 0x17
#define NUM_REGISTERS_INCLUDING_HIDDEN 0x19 /* Does not include SSW */


#ifdef SHARED_DATA_MEMBERS
/*
** Processor-specific shared data member definitions
*/
#define SIZE_FW_INST   2800  /* (sizeof(FW_LINES)*100 */

#define SD_CONFIG_CS_HW_CMD "configcs hardware command"
#define SD_CONFIG_CS_HW_RESULT "configcs hardware result"
#define SD_SIM_ADDRESS "sim register bank address"
#define SD_SIM_VALID "sim valid"
#define SD_FIND_FLUSH_BUFFER  "find flush buffer"
#define SD_FIND_FLUSH_START   "find flush start"
#define SD_FIND_FLUSH_ABORT   "find flush abort"
#define SD_FIND_FLUSH_FOUND   "find flush found"
#define SD_FIND_FLUSH_INSTS   "find flush instructions"
#define SD_FIND_FLUSH_COUNT   "find flush instruction count"
#define SD_FIND_FLUSH_END     "find flush ending frame"
#define SD_DQSYNC_FETCH_FRAME "dqsync fetch frame"
#define SD_DQSYNC_EXEC_FRAME  "dqsync exec frame"
#define SD_BERR_RETRY         "bus error retry"
#define SD_STEP_MASK          "step mask"
#define SD_BDM_SPEED          "bdm speed"
#define SD_PMODE              "pmode"
#define SD_COP_TYPE           "coprocessor type"

/*
** Write TRUE to the CMD member to cause firmware to read current contents
** of chip select registers.  This information is immediately used to
** reconfigure map and execution breakpoints, and is loaded into local
** storage and used for subsequent map and execution breakpoints.  Chip
** select information is also used to configure the source of DQ and
** source for A19-A23 for the trace.  The result of the operation is
** written to the result member.
*/
{1, SD_CONFIG_CS_HW_CMD,   SDN_CONFIG_CS_HW_CMD,   SIZE_BOOL,   WR, RD }
{1, SD_CONFIG_CS_HW_RESULT,SDN_CONFIG_CS_HW_RESULT,SIZE_RETCODE,RD, WR }
/*
** SD_SIM_VALID indicates the sim is accessable.  This is extremely
** important for the 330/340/360 processors.
**
** SD_SIM_ADDRESS indicates the starting address of the SIM register
** block.  For the 332, this will be either 0xfffa00 or 0x7ffa00.  This
** information is used by the event and trigger servers.
*/
{1, SD_SIM_VALID,          SDN_SIM_VALID,          SIZE_BOOL,   RD, WR }
{1, SD_SIM_ADDRESS,        SDN_SIM_ADDRESS,        SIZE_LONG,   RD, WR }

/*
** This block is for accelerating the dequeuer.  Write trace buffer
** information (logical frame numbers) to buffer and starting frame.
** Writing start kicks off the firmware.  Found indicates whether
** a flush was found. 
** Flush inst contains an array of FW_LINES of instructions or data
** accesses. Flush count is the number of "dq" lines. And finally
** flush end is the frame number of the last dq'd instruction.
*/
{1, SD_FIND_FLUSH_BUFFER,  SDN_FIND_FLUSH_BUFFER,  SIZE_WORD,   WR, RD }
{1, SD_FIND_FLUSH_START,   SDN_FIND_FLUSH_START,   SIZE_LONG,   WR, RD }
{1, SD_FIND_FLUSH_ABORT,   SDN_FIND_FLUSH_ABORT,   SIZE_BOOL,   WR, RD }
{1, SD_FIND_FLUSH_FOUND,   SDN_FIND_FLUSH_FOUND,   SIZE_BYTE,   RD, WR }
{1, SD_FIND_FLUSH_INSTS,   SDN_FIND_FLUSH_INSTS,   SIZE_FW_INST,RD, WR }
{1, SD_FIND_FLUSH_COUNT,   SDN_FIND_FLUSH_COUNT,   SIZE_WORD,   RW, RW }
{1, SD_FIND_FLUSH_END,     SDN_FIND_FLUSH_END,     SIZE_LONG,   RD, WR }
/*
** Bus error retry member.  When set TRUE, unterminated memory cycles
** are ended by asserting BERR (or READY# in 386).
*/
{1, SD_BERR_RETRY,         SDN_BERR_RETRY,         SIZE_BOOL,   WR, RD }

/*
** Step mask.  When TRUE, single steps are performed by setting the
** interrupt mask to 7, stepping, then restoring the original mask.
** Used for cpu16, cpu32 and cpu32+ only.
*/
{1, SD_STEP_MASK,          SDN_STEP_MASK,          SIZE_BOOL,   WR, RD }

{1, SD_BDM_SPEED,          SDN_BDM_SPEED,          SIZE_ENUM,   WR, RD }

/*
** pmode:  Reports the current processor mode.  386 only.
*/
{1, SD_PMODE,              SDN_PMODE,              SIZE_ENUM,   RD, RW }

/*
** Coptype: reports type of coprocessor present.
*/
{1, SD_COP_TYPE,           SDN_COP_TYPE,           SIZE_ENUM,   RD, RW }

#endif
