#ifndef _SDS2ABI_
#define  _SDS2ABI_

#ifndef  _ABI_
#include "abi.h"
#endif

#ifndef _MP_TRACE_
#include "mp_trc.h"
#endif

#ifndef _MP_TRIG_
#include "mp_trig.h"
#endif

#ifndef  _MP_SHARE_
#include "mp_share.h"
#endif

#ifndef _WHPTEXEC_
#include "whptexec.h"
#endif

#ifndef VERIFY_INFO_DEFINED
typedef struct {
   MEMBER_INDEX offset;
   MEMBER_INDEX space;
   MEMBER_INDEX expected;
   MEMBER_INDEX actual;
} VERIFY_INFO;
#define  VERIFY_INFO_DEFINED
#endif


RETCODE EXPORT iceMapError(STATUS status);
RETCODE EXPORT GetReg(CPU_REG regId, U32 *regValue);
RETCODE EXPORT GetRegFromHost(CPU_REG regId, U32 *regValue);
RETCODE EXPORT SetReg(CPU_REG regId, U32 regValue);
RETCODE EXPORT Sds2AbiFwReadMem(U32 offset, ADDR_SPACE space, U32 length,
			  ACCESS_SIZE access, U8 *data);
RETCODE EXPORT Sds2AbiFwFillMem(U32 offset, ADDR_SPACE space, U32 length,
       U32 pLength, ACCESS_SIZE access, BOOLEAN verify,
       VERIFY_INFO *verifyInfo, U8 *data);
RETCODE EXPORT Sds2AbiFillMemAction(U32 offset, ADDR_SPACE space, U32 length,
       U32 pLength, ACCESS_SIZE access, BOOLEAN verify,
       VERIFY_INFO *verifyInfo, U8 *data);
RETCODE  EXPORT Sds2AbiInitCoreMembers(VOID);
RETCODE         EXPORT Sds2AbiLoadMicePackFw(U16 port);
RETCODE EXPORT Sds2AbiFwRestoreFCRegs(U32 *regs);
RETCODE EXPORT Sds2AbiFwSaveFCRegs(U32 *regs);
RETCODE  Sds2AbiReadMemAction(U32 offset, ADDR_SPACE space, U32 length,
			  ACCESS_SIZE access, U8 *data);
RETCODE  Sds2AbiFwHalt(VOID);
RETCODE  Sds2AbiFwStep(U32 count);
RETCODE  Sds2AbiFwBkptHit(VOID);
RETCODE EXPORT Sds2AbiFwPowerOn(VOID);
RETCODE  Sds2AbiFwUnloadBreakpoints(VOID);
RETCODE  Sds2AbiFwUnloadWatchpoints(VOID);
RETCODE  Sds2AbiFwLoadBreakpoints(BOOLEAN loadNow);
RETCODE  Sds2AbiFwUnloadRegistersCpu306(BOOLEAN patchPCSP);
RETCODE EXPORT Sds2AbiFwUnloadRegisters(BOOLEAN patchPCSP);
RETCODE  Sds2AbiFwLoadRegistersCpu306(VOID);
RETCODE EXPORT Sds2AbiFwLoadRegisters(VOID);
RETCODE EXPORT Sds2AbiFwGetMapGranularity(U32 *gran);
RETCODE EXPORT Sds2AbiFwGetMapSize(U32 *size);
RETCODE EXPORT Sds2AbiFwGetMapBlocks(U32 *block);
RETCODE EXPORT Sds2AbiFwPingProbe(VOID);
RETCODE EXPORT Sds2AbiConvertTraceMode(TRACE_MODE traceMode, U16 *mpTraceMode);
RETCODE EXPORT Sds2AbiSetTimerCounter(U16 id, U32 tc);
RETCODE EXPORT Sds2AbiGetTraceBufferInfo(U16 buffer, U32 *beforeFrames,
	    U32 *afterFrames, U32 *trigFrame);
RETCODE EXPORT Sds2AbiGetTraceBufferLogicInfo(U16 buffer, S32 *start, S32 *end);
VOID EXPORT Sds2AbiIsTraceBufferFull(U16 buffer, BOOLEAN *full);
U32 EXPORT Sds2AbiGetTriggerFrame(U16 buffer);
RETCODE EXPORT Sds2AbiSetEvent(U16 evID, BUS_EVENT *bus);
RETCODE EXPORT Sds2AbiClearEvent(U16 evID);
RETCODE EXPORT Sds2AbiSetTrig(U16 trigLevel, MP_TRIGGER *trig);
RETCODE EXPORT Sds2AbiClearTrig(U16 trigLevel);
RETCODE EXPORT Sds2AbiGetTraceInfo(U16 *level, U16 *subBuf,
	 U16 *cnt0, U16 *cnt1, U16 *maxBuf);
BOOLEAN EXPORT Sds2AbiIsTraceBufferEmpty(U16 buffer);
RETCODE EXPORT Sds2AbiSetNumTraceBuffers(U16 bufNo);
RETCODE EXPORT Sds2AbiProgramMtat(VOID);
RETCODE EXPORT Sds2AbiGetTraceFrames(U16 buffer, U32 frameNo, U32 *framesRead, TRACE_FRAME *frames);
RETCODE EXPORT Sds2AbiSetMap(DESCRIPTOR desc);
RETCODE EXPORT Sds2AbiSetBreakOnFull(BOOLEAN enable);
RETCODE EXPORT Sds2AbiGetBreakOnFull(U16 *TraceBreak);
RETCODE EXPORT Sds2AbiSetControl(U16 control);
RETCODE EXPORT Sds2AbiSetExtEvent(U16 ext);
RETCODE EXPORT Sds2AbiSetVerify(U16 verifyFlag);
RETCODE EXPORT Sds2AbiSetQualTrace(U32 addr,U32 addrMask,U16 qStatus,
	   U16 qStatusMask);
RETCODE EXPORT Sds2AbiDisableQual(VOID);
RETCODE EXPORT Sds2AbiTraceReset(VOID);

#ifdef __cplusplus
extern "C" {
#endif

RETCODE EXPORT Sds2AbiSetIntReg(U16 offset,U16 len,U32 data);
RETCODE EXPORT Sds2AbiGetIntReg(U16 offset,U16 len,U32 FAR *data);

#ifdef __cplusplus
}
#endif

#endif /* end of #ifndef _SDS2ABI_ */
