
#define _SYMELF_

                       /****************************
                        *                          *
                        *      # DEFINITIONS       *
                        *                          *
                        ****************************/

#ifdef __cplusplus
extern "C" {
#endif

                       /**************************
                        *                        *
                        *    TYPE DEFINITIONS    *
                        *                        *
                        **************************/
/* (C) class types */
typedef struct {
    LPSTR name;             /* name of field; use MAX_SYMNAME_LENGTH */
    TYPE_INDEX typeIndex;   /* index to type or return type*/
    U16 offset;             /* offset */
    BOOLEAN isMethod;       /* 0:variable, 1:method */
    OFFSET_ADDR_RANGE_TYPE fnAddr; /* start and end address of the method function */
    U8 access;              /* 0:PUBLIC, 1:PRIVATE, 2:PROTECTED */
} TYPE_C_STRUCT;


                        /****************************
                         *                          *
                         *        PROTOTYPES        *
                         *                          *
                         ****************************/

/*--------------------------------------------------------------------------*/
/* SymAddTypeClass
**
** Purpose:
**    Given a type index, add a class component.  SW must
**    increment local component count.
**
** Input parameters:
**    typeIndex: index of type
**    class: no. of elements making up the component
**
** Output parameters:
**
** Error: Reports error if:
**    <typeIndex> doesn't point to an entry in the type table or to a
**      (C) type
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddTypeClass(TYPE_INDEX typeIndex, TYPE_C_STRUCT *cls);

/*--------------------------------------------------------------------------*/
/* SymGetTypeClass
**
** Purpose:
**    Look up the name of a class component given an index to
**    the type.  Return the component's information and the component
**    index (where 0 is the first index).
**
** Input parameters:
**    typeIndex: index of type
**    clsName: name of class component to be looked up
**
** Output parameters:
**    cls: number of elements making up the component
**    componentIndex: component index found, where first is 0
**    noMatch: FALSE if name didn't match any stored name
**
**
** Error: Reports error if:
**    <typeIndex> doesn't point to an entry in the type table or to a
**      (C) type
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetTypeClass(TYPE_INDEX        typeIndex,
                LPSTR             clsName,
                TYPE_C_STRUCT FAR *cls,
                U16           FAR *componentIndex,
                BOOLEAN       FAR *noMatch);


/*--------------------------------------------------------------------------*/
/* SymGetTypeClassNth
**
** Purpose:
**    Given a data class (C), retrieve nth component
**
** Input parameters:
**    typeIndex: index of type
**    n: nth component to be extracted where 0 is first
**
** Output parameters:
**    cls: no. of  elements of nth class component
**
** Error: Reports error if:
**    <typeIndex> doesn't point to an entry in the type table or to an
**      unknown type
**    Value of n beyond the number of components
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetTypeClassNth(TYPE_INDEX          typeIndex,
                   U16                 n,
                   TYPE_C_STRUCT FAR   *cls);

#ifdef __cplusplus
}
#endif
