/****************************************************************************
**
**  Name:  ERR.H
**
**  Description:
**      Error defines for ELF/Dwarf Loader.
**
**  Status:  CODED
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef __ERR__
#define __ERR__

/* TBird error definitions */
#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

/* errors are now in errtext/mkerrors.h */

/* returns from _Query */
#define QOK         0
#define QCANCEL     1

enum INFOMSG {LD_COMPLETE, LD_CODE_LOADED, LD_SYM_LOADED};


/* modes for _InfoMsg display */
#define IM_COLLECT  0   /* collect string */
#define IM_DISPLAY  1   /* display all collected */

extern CHAR *lerrmsg[];
extern BOOL runMode;

S16 SendMessageToCLI(CHAR *);

/* Prototypes in ERR.C */
VOID Warning(RETCODE);
VOID WarningEx(RETCODE, LPSTR);
U16  Query(RETCODE);
VOID InfoMsg(CHAR *);
VOID InitInfostring(VOID);

#endif
