#define _LHEADER_

#ifndef _BASICTYP_
#include "basictyp.h"
#endif
 
#define EI_NIDENT 16
#define EI_MAG0    0
#define EI_CLASS   4
#define EI_DATA    5
#define EI_VERSION 6
#define EI_PAD     7

#define ELFCLASSNONE 0
#define ELFCLASS32   1
#define ELFCLASS64   2

#define ELFDATANONE 0
#define ELFDATA2LSB 1
#define ELFDATA2MSB 2

#define ET_NONE 0
#define ET_REL  1
#define ET_EXEC 2
#define ET_DYN  3
#define ET_CORE 4
#define ET_LOPROC 0xFF00
#define ET_HIPROC 0xFFFF

#define EM_POWERPC 20

#define PT_NULL    0
#define PT_LOAD    1
#define PT_DYNAMIC 2
#define PT_INTERP  3
#define PT_NOTE    4
#define PT_SHLIB   5
#define PT_PHDR    6
#define PT_LOPROC  0x70000000
#define PT_HIPROC  0x7FFFFFFF

#define PHF_EXEC   0x1
#define PHF_WRITE  0x2
#define PHF_READ   0x4

#define SHT_NULL     0
#define SHT_PROGBITS 1
#define SHT_SYMTAB   2
#define SHT_STRTAB   3
#define SHT_RELA     4
#define SHT_HASH     5
#define SHT_DYNAMIC  6
#define SHT_NOTE     7
#define SHT_NOBITS   8
#define SHT_REL      9
#define SHT_SHLIB    10
#define SHT_DYNSYM   11
#define SHT_LOPROC   0x70000000
#define SHT_HIPROC   0x7FFFFFFF
#define SHT_LOUSER   0x80000000
#define SHT_HIUSER   0xFFFFFFFF

#define SHF_WRITE     0x1
#define SHF_ALLOC     0x2
#define SHF_EXECINSTR 0x4
#define SHF_MASKPROC  0xF0000000

#define LANG_C86          0x00000001
#define LANG_C            0x00000002
#define LANG_C_PLUS_PLUS  0x00000004

/*ELF HEADER*/
typedef struct{
	U8 e_ident[EI_NIDENT];
	U16 e_type;
	U16 e_machine;
	U32 e_version;
	U32 e_entry; /*the program entry address*/
	U32 e_phoff; /*the file offset to the Program Header Table*/
	U32 e_shoff; /*the file offset to the Section Header Table*/
	U32 e_flags;
	U16 e_ehsize; /*the size of the ELF Header*/
	U16 e_phentsize; /*the size of each entry in the Program Header Table*/
	U16 e_phnum; /*the number of entries in the Program Header Table*/
	U16 e_shentsize; /*the size of each entry in the Section Header Table*/
	U16 e_shnum; /*the number of entries in the Section Header Table*/
	U16 e_shstrndx; /*the Section Index of the entry containing the
			  section header string table*/
} Elf32_Endr;

/*Program Execution Header*/
typedef struct{
	U32 p_type; /*the type of the segment*/
	U32 p_offset; /*the file offset where the raw data of the segment resides*/
	U32 p_vaddr;
	U32 p_paddr;
	U32 p_filesz;
	U32 p_memsz;
	U32 p_flags; /* 1:EXEC, 2:WRITE, 4:READ*/
	U32 p_align;
} Elf32_Phdr;

/*Section Header Table*/
typedef struct{
	U32 sh_name; /*the name of the section,it is an index into the
		       section header string table*/
	U32 sh_type;
	U32 sh_flags;
	U32 sh_addr;
	U32 sh_offset;
	U32 sh_size;
	U32 sh_link;
	U32 sh_info;
	U32 sh_addralign;
	U32 sh_entsize;/*is the size for each entry in section that
			 contains fixed-sized entries*/
	char sec_name[ELF_IDNLEN];
}Elf32_Shdr;

typedef struct{
	U32 st_name;
	U32 st_value;
	U32 st_size;
	U8  st_info;
	U8  st_other;
	U16 st_shndx;
}Elf32_Sym;
