/****************************************************************************
**
**  Name:  LTYPE.C
**
**  MOD_reference_to and MOD_volatile are not implemented - Hera 3/5/97
**
**  Description:
**      Type processing routines for ELF/Dwarf loader.
**
**  $Log:   S:/tbird/arcppc/lelf/ltype.c_v  $
** 
**    Rev 1.10   31 Mar 1998 11:58:02   Winky
** C++
** 
**    Rev 1.7   31 Mar 1997 08:45:52   hera
** 
**    Rev 1.6   24 Mar 1997 13:58:46   hera
** Add GetTypeProc() and ProcessTypeinSU
**
**  Status:  CODED
**
**
**  $Header:   S:/tbird/arcppc/lelf/ltype.c_v   1.10   31 Mar 1998 11:58:02   Winky  $
**
*****************************************************************************/
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
			****************************/
#include <io.h>
#include <limits.h>
#ifndef __LDR__
#include "ldr.h"
#endif
#ifndef _HEAP_
#include "heap.h"
#endif
#ifndef _SYMBLSVR_
#include "symblsvr.h"
#endif
#ifndef _SYMELF_
#include "symelf.h"
#endif
#ifndef __ERR__
#include "err.h"
#endif
#ifndef __LDEBUG__
#include "ldebug.h"
#endif
#ifndef __LMANGLE__
#include "lmangle.h"
#endif
#ifndef __LDMANGLE__
#include "ldmangle.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
/* Max index type value */
#define MAX_INDEX_TYPE 0x0FFFFFFFL
ClassLink *CLbegin = NULL, *CLend;

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
extern U16 ldrDemangle;
extern U32 DebugOffset;
extern long Tag_Size;
extern Offset2Index *pOffset2IndexHead,*pOffset2IndexTail,*pOffset2IndexTemp;

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
			****************************/
RETCODE PRIVATE ProcessTypeinSU(HANDLE hfile, StructInfo* Sptr);
RETCODE PRIVATE ProcessTypeinClass(HANDLE hfile, classInfo* Sptr);

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/
/******************************************************************************
**
**  GetTypePtr - Process Pointer type
**
******************************************************************************/
RETCODE GetTypePtr(U32 parentType, U32 Type)
{
   U32 symerr;

   if ((symerr = SymAddTypePointerTypeIndex(parentType, Type)) != GOOD)
	    return(ER_SYM_TYPE);

   return(GOOD);
}  /* GetTypePtr */

/*****************************************************************************
**
** GetTypeRef -- Process Reference type -- Hera 2/9/98
**
*****************************************************************************/
RETCODE GetTypeRef(U32 parentType, U32 Type) {
   U32 symerr;
   if ((symerr = SymAddTypeReferenceTypeIndex(parentType, Type)) != GOOD)
      return (ER_SYM_TYPE);
   return(GOOD);
}

/******************************************************************************
**
**  GetTypeTypedef - Process typedef type
**
******************************************************************************/
RETCODE GetTypeTypedef(HANDLE hfile, U32 Offset, TYPE_HEADER_TYPE *parentTypehdr)
{
   U32 baseTypeIndex,NextTag;
   TYPE_HEADER_TYPE baseTypeHdr,typeHdrInfo;
   CHAR typeName[ELF_IDNLEN] = "";
   CHAR baseName[ELF_IDNLEN] = "";
   char byte;
   U16 Attribution,num,pointerTimes;
   int quit,index;
   BYTE modifier;
   U32 tmax,tindex,utype;
   RETCODE err;
   BOOLEAN found;

   pointerTimes = 0;
   quit = 0;
   typeHdrInfo.dirty = 0;//Hera 3/11/98
   while(!quit && Tag_Size > 0)
   {
     Attribution = GetELFU16(hfile);
     Tag_Size -= 2;

     switch(Attribution)
     {
	case AT_sibling:
	     NextTag = GetELFU32(hfile);
	     /*for (i = 0 ; i < CTIndex; i++)
		if (Offset == FOffset2TIndex[i].offset){
		   SeekELFFile(hfile,(DebugOffset+NextTag),SEEK_SET);
		   Tag_Size = 0;
                   return(GOOD);
		}*/
	     pOffset2IndexTemp = pOffset2IndexHead;
	     while (pOffset2IndexTemp != NULL) {
		if (Offset == pOffset2IndexTemp->offset){
		   SeekELFFile(hfile,(DebugOffset+NextTag),SEEK_SET);
		   Tag_Size = 0;
	           return(GOOD);
	        }
                else
	           pOffset2IndexTemp = pOffset2IndexTemp->next;
	     }
             Tag_Size -= 4;
	     break;
	case AT_name:
	     index = 0;
	     while((byte = GetELFByte(hfile)) != 0)
	        typeName[index++] = byte;
	     typeName[index]='\0';
             parentTypehdr->typeName = (LPSTR)typeName;
	     Tag_Size -= (index+1);
	     break;

	case AT_fund_type:
	     baseTypeIndex = GetELFU16(hfile);
	     Tag_Size -= 2;
	     break;

	case AT_user_def_type:
	     baseTypeIndex = GetELFU32(hfile);
	     /*pOffset2IndexTemp = pOffset2IndexHead;
	     while (pOffset2IndexTemp != NULL) {
	        if (baseTypeIndex == pOffset2IndexTemp->offset){
		   baseTypeIndex = pOffset2IndexTemp->tindex;
		   pOffset2IndexTemp = NULL;
	        }
                else
	           pOffset2IndexTemp = pOffset2IndexTemp->next;
	     }*/
	     SearchForType(baseTypeIndex,&baseTypeIndex,&found);
             if(!found) typeHdrInfo.dirty = 1;
	     Tag_Size -= 4;
	     break;

	case AT_mod_fund_type:
	{
	  int num_mod;
	  U8  MD;

	  num = GetELFU16(hfile);//number;
	  num_mod = num - 2; //modifier + type(2bytes)
	  modifier = MOD_const; //default
	  while(num_mod > 0)
	  {
	     MD = GetELFByte(hfile);
	     if(MD == MOD_pointer_to){
		modifier = MD;
		pointerTimes++;
	     }
	     else if(MD == MOD_reference_to) //Hera 2/9/98
		modifier = MD;
             num_mod--;
	  }
	  //MOD_reference_to and MOD_volatile are not implemented
          utype = (U32)GetELFU16(hfile);
	  while(modifier == MOD_pointer_to && pointerTimes)
	  {
	    typeHdrInfo.typeChoice = COMPLEX_TYPE_CLASS;
            typeHdrInfo.typeName = "\0";

            if ((err = SymGetTypeIndexMax(&tmax)) != GOOD)
                return(err);

	    tindex = tmax+1;
	    typeHdrInfo.t.complexType = Pointer;
            typeHdrInfo.sizeInMAUs = 4;
            typeHdrInfo.sizeCalculated = TRUE;
	    if (SymAddTypeHeader(tindex, &typeHdrInfo) != GOOD) 
                return(ER_SYM_TYPE);

	    err = GetTypePtr(tindex, utype);
            utype = tindex;
            pointerTimes--;
	  }
	  //Hera 2/9/98
	  if (modifier == MOD_reference_to) {
	     typeHdrInfo.typeChoice = COMPLEX_TYPE_CLASS;
	     typeHdrInfo.typeName = "\0";
	     if ((err = SymGetTypeIndexMax(&tmax)) != GOOD) return(err);
	     tindex = tmax + 1;
	     typeHdrInfo.t.complexType = Reference;
	     typeHdrInfo.sizeInMAUs = 4;
	     typeHdrInfo.sizeCalculated = TRUE;
	     if (SymAddTypeHeader(tindex, &typeHdrInfo) != GOOD)
		return(ER_SYM_TYPE);
	     err = GetTypeRef(tindex,utype);
	     utype = tindex;
          }
	  if(modifier == MOD_const)
	     tindex = utype;
          //Hera
	  //baseTypeIndex = GetELFU16(hfile) + modifier* NUM_FUN_TYPE;
	  Tag_Size -= (num+2);           
	  break;
	}

	case AT_mod_u_d_type:
	{
	     int num_mod;
	     BYTE MD;

	     num = GetELFU16(hfile); // number
	     num_mod = num - 4; //modifiers + file offset(4 bytes)
	     modifier = MOD_const; //default
	     while(num_mod > 0)
             {
		MD = GetELFByte(hfile); //modifier
		if(MD == MOD_pointer_to){
		   modifier = MD;
		   pointerTimes++;
		}
		else if (MD == MOD_reference_to) 
                   modifier = MD;
		num_mod--;
             }
	     utype = GetELFU32(hfile); //poiter to utype
	     /*pOffset2IndexTemp = pOffset2IndexHead;
	     while (pOffset2IndexTemp != NULL) {
	        if (utype == pOffset2IndexTemp->offset){
	           utype = pOffset2IndexTemp->tindex;
		   pOffset2IndexTemp = NULL;
                   //typeHdrInfo.dirty = 0;
	        }
                else{
		   pOffset2IndexTemp = pOffset2IndexTemp->next;
		   //typeHdrInfo.dirty = 1;
                }
	     }*/
	     SearchForType(utype,&utype,&found);             
             if(!found) typeHdrInfo.dirty = 1;
	     while(modifier == MOD_pointer_to && pointerTimes){
	        typeHdrInfo.typeChoice = COMPLEX_TYPE_CLASS;
                typeHdrInfo.typeName = "\0";

                  if ((err = SymGetTypeIndexMax(&tmax)) != GOOD)
         	      return(err);

	          tindex = tmax+1;
	          typeHdrInfo.t.complexType = Pointer;
                  typeHdrInfo.sizeInMAUs = 4;
                  typeHdrInfo.sizeCalculated = TRUE;
	          if (SymAddTypeHeader(tindex, &typeHdrInfo) != GOOD) 
                      return(ER_SYM_TYPE);

		  err = GetTypePtr(tindex, utype);
		  utype = tindex;
                  pointerTimes--;
	      }
	      //Hera 2/9/98
	      if (modifier == MOD_reference_to) {
	         typeHdrInfo.typeChoice = COMPLEX_TYPE_CLASS;
	         typeHdrInfo.typeName = "\0";
	         if ((err = SymGetTypeIndexMax(&tmax)) != GOOD) return(err);
	         tindex = tmax + 1;
	         typeHdrInfo.t.complexType = Reference;
	         typeHdrInfo.sizeInMAUs = 4;
	         typeHdrInfo.sizeCalculated = TRUE;
	         if (SymAddTypeHeader(tindex, &typeHdrInfo) != GOOD)
		    return(ER_SYM_TYPE);
	         err = GetTypeRef(tindex,utype);
	         utype = tindex;
	      }
	      if(modifier == MOD_const)
		 tindex = utype;

              baseTypeIndex = tindex;
	      Tag_Size -= (num+2);                  
	      break;
	}

	default:
	     if(Tag_Size > 0)
	       SeekELFFile(hfile, Tag_Size, SEEK_CUR);
	     Tag_Size = 0;       
	     quit = 1;
	     break;
     }
   }
   SeekELFFile(hfile, (DebugOffset+NextTag),SEEK_SET);
   baseTypeHdr.typeName = baseName;  
   if (SymGetTypeHeader(baseTypeIndex, &baseTypeHdr) == GOOD)
   {
      parentTypehdr->sizeInMAUs = baseTypeHdr.sizeInMAUs;
      parentTypehdr->sizeCalculated = TRUE;
   }

   if((err = SymGetTypeIndexMax(&tmax)) != GOOD)
      return(err);
   tindex = tmax+1;

   pOffset2IndexTemp =(Offset2Index*)TMalloc(sizeof(Offset2Index));
   pOffset2IndexTemp->next = NULL;
   pOffset2IndexTemp->tindex = tindex;
   pOffset2IndexTemp->offset = Offset;
   if (pOffset2IndexHead == NULL){
      pOffset2IndexHead = pOffset2IndexTemp;	 
      pOffset2IndexTail = pOffset2IndexHead;
   }
   else {
      pOffset2IndexTail->next = pOffset2IndexTemp;
      pOffset2IndexTail = pOffset2IndexTemp;
   }
//   FOffset2TIndex[CTIndex].tindex = tindex;
//   FOffset2TIndex[CTIndex++].offset = Offset;

   if ((SymAddTypeHeader(tindex, parentTypehdr) != GOOD) ||
      (SymAddTypeTypeIndex(tindex, baseTypeIndex) != GOOD))
      return(ER_SYM_TYPE);

   return(GOOD);
}  /* GetTypeTypedef */

/******************************************************************************
**
**  GetTypeSU - Process type structure/union
**  tindexParent - type index for parent
**  stype - type (struct/union) (not used currently)
**
******************************************************************************/
#pragma argsused /* stype */
RETCODE GetTypeSU(HANDLE hfile, U32 Offset, TYPE_HEADER_TYPE *parentTypeHdr)
{
   CHAR name[ELF_IDNLEN] = "",typeName[ELF_IDNLEN] = "";
   CHAR tmpName[ELF_IDNLEN] = "";
   U32 tindex,NextMember,tmax;
   U32 NUM_M_U_D_TYPE;
   TYPE_S_U_STRUCT su;
   S16 quit,q,index,BitFlag;
   CHAR byte;
   U16 Tag,Attribution,num, funcClass;
   TYPE_HEADER_TYPE typeHdrInfo;
   TYPE_HEADER_TYPE baseTypeHdr;
   StructInfo *SPtr = NULL,*tptr1,*tptr2;
   RETCODE err;
   U32 structoffset;

   structoffset = tell(hfile);
   typeHdrInfo.dirty = 0;
   NUM_M_U_D_TYPE = 0;
   quit = 0;
   while(!quit)
   {
      Tag_Size = GetELFU32(hfile);
      if(Tag_Size == 4)
      {
	Tag = TAG_padding;
	Tag_Size = 0;
      }
      else
      {
        Tag = GetELFU16(hfile);
	Tag_Size -= 6;
      }
      switch(Tag) 
      {
	case TAG_member:
	     q = 0;
	     BitFlag = 0;
	     tptr1 = (StructInfo*)TMalloc(sizeof(StructInfo));
	     memset(tptr1,0,sizeof(StructInfo));
	     tptr1->next = NULL;
             tptr1->tag = TAG_member;//Hera 2/6/98
	     if(SPtr == NULL)
	     {
               tptr2 = tptr1;
	       SPtr = tptr1;
	      }
	     else
             {
	       tptr2->next = tptr1;
	       tptr2 = tptr1;
	      }

	     while(!q && Tag_Size > 0)
	     {
	       Attribution = GetELFU16(hfile);
               Tag_Size -= 2;
	       switch(Attribution)
	       {
                 case AT_sibling:
		      NextMember = GetELFU32(hfile);
                      Tag_Size -= 4;
		      break;

		 case AT_name:
		      index = 0;
		      while((byte = GetELFByte(hfile)) != 0)
			name[index++] = byte;
		      name[index]='\0';
                      strcpy(tptr1->name,name);
		      Tag_Size -= (index+1);
		      break;

		 case AT_member:
		      GetELFU32(hfile);
		      Tag_Size -= 4;
		      break;

	       	 case AT_user_def_type:
		      tptr1->typeIndex = GetELFU32(hfile);
                      tptr1->attribution = AT_user_def_type;
                      Tag_Size -= 4;
	              break;

		 case AT_mod_u_d_type:
                 case AT_mod_fund_type:
		 {
		   int num_mod;
		   BYTE MD;

		   num = GetELFU16(hfile);
		   tptr1->attribution = Attribution;
		   if(Attribution == AT_mod_u_d_type)
		      num_mod = num - 4; //modifiers + file offset(4bytes)
                   else //AT_mod_fund_type
		      num_mod = num - 2;   //modifiers + type(2bytes)
		   while(num_mod > 0){
		     MD = GetELFByte(hfile);
		     if(MD == MOD_pointer_to){
			NUM_M_U_D_TYPE++;   //number of AT_mod_u_d_type + AT_mod_fund_type
                        (tptr1->pointerTimes)++;
			tptr1->modifier = MD;			
		      }
		      else if(MD == MOD_reference_to){
			 NUM_M_U_D_TYPE++;
			 tptr1->modifier = MD;
                      }
		      num_mod--;
		   }
		   if(tptr1->modifier != MOD_reference_to &&
		      tptr1->modifier != MOD_pointer_to) {
		       if(Attribution == AT_mod_fund_type){
			  tptr1->typeIndex = (U32)GetELFU16(hfile);
			  tptr1->attribution = AT_fund_type;
		       }
		       else {//AT_mod_u_d_type ????
			  tptr1->typeIndex = GetELFU32(hfile);
			  tptr1->attribution = AT_user_def_type;
                       }
                   }
		   else{ //MOD_reference_to && MOD_pointer_to
		      if(Attribution == AT_mod_u_d_type)
		         tptr1->utype = GetELFU32(hfile);
		      else if(Attribution == AT_mod_fund_type)
			 tptr1->utype = (U32)GetELFU16(hfile);
		   }
		    Tag_Size -= (num+2);
		    break;
		 }

		 case AT_fund_type:
		    tptr1->attribution = Attribution;
		    tptr1->typeIndex = GetELFU16(hfile);
		    Tag_Size -= 2;
		    break;

		 case AT_bit_size:
		 {
		      TYPE_BITFIELD_STRUCT bfHdrStruct;
		      typeHdrInfo.typeChoice = COMPLEX_TYPE_CLASS;
		      typeHdrInfo.sizeInMAUs = 0L;  /* default MAU size for all type */
		      typeHdrInfo.typeName = "\0";

		      if ((err = SymGetTypeIndexMax(&tmax)) != GOOD)
			  return(err);
		      tindex = tmax+1;
		      bfHdrStruct.baseTypeIndex = tptr1->typeIndex;
		      bfHdrStruct.size = GetELFU32(hfile);
		      switch(bfHdrStruct.baseTypeIndex)
		      {
			case FT_char: case FT_signed_char:
			case FT_short: case FT_signed_short:
			case FT_integer: case FT_signed_integer:
			case FT_long: case FT_signed_long:
			case FT_float: case FT_dbl_prec_float:
                        case FT_ext_prec_float:
			    bfHdrStruct.bitfieldSigned = 1; /*signed*/
			break;

			case FT_unsigned_char:
			case FT_unsigned_short:
			case FT_unsigned_integer:
			case FT_unsigned_long:
			    bfHdrStruct.bitfieldSigned = 0; /*unsigned*/
			break;

			default:
                            bfHdrStruct.bitfieldSigned = 0;
                      }

		      baseTypeHdr.typeName = (LPSTR)typeName;
		      if (SymGetTypeHeader(bfHdrStruct.baseTypeIndex, &baseTypeHdr) == GOOD)
		      {                          
			 typeHdrInfo.sizeInMAUs = baseTypeHdr.sizeInMAUs;
			 typeHdrInfo.sizeCalculated = TRUE;
		      }
		      typeHdrInfo.t.complexType = Bit_Type;
                      BitFlag = 1;
		      if ((SymAddTypeHeader(tindex,&typeHdrInfo) != GOOD) ||
			    (SymAddTypeBitfield(tindex, &bfHdrStruct) != GOOD)) 
			      return(ER_SYM_TYPE);
		      tptr1->typeIndex = tindex;
                      Tag_Size -= 4;
		      break;
		 }

		 case AT_bit_offset:
		      tptr1->offset = GetELFU16(hfile);
                      Tag_Size -= 2;
		      break;

		 case AT_location:
		      num = GetELFU16(hfile);   //number
		      GetELFByte(hfile); //OP_const
                      if(!BitFlag) //not bitfield type 
			 tptr1->offset = GetELFU32(hfile);
		      else // bitfield type
			 tptr1->offset += GetELFU32(hfile)*8;

		      GetELFByte(hfile); //OP_add
                      Tag_Size -= (num+2);
		      break;

		 default:
                      q = 1;		      
		      break;
                 }//While(!q)
	     }
	     SeekELFFile(hfile,(DebugOffset+NextMember),SEEK_SET);
	break;
        //Hera 1/23/98
	case TAG_subroutine_type:
	     NUM_M_U_D_TYPE++;
	     tptr1 = (StructInfo*)TMalloc(sizeof(StructInfo));
	     memset(tptr1,0,sizeof(StructInfo));
	     tptr1->next = NULL;

	     if(SPtr == NULL){
               tptr2 = tptr1;
	       SPtr = tptr1;
	      }
	     else{
	       tptr2->next = tptr1;
	       tptr2 = tptr1;
	     }
	     tptr1->offset = tell(hfile) - 6;
	     tptr1->tag = TAG_subroutine_type;
	     //Hera 2/10/98
	     {
		U16 atttmp;
		int num_mod;
		BYTE MD;

		GetELFU16(hfile); //Tag_sibling
		GetELFU32(hfile); //next address
		atttmp = GetELFU16(hfile);
		Tag_Size -= 8;
		if(atttmp == AT_mod_fund_type || atttmp == AT_mod_u_d_type){
		   num = GetELFU16(hfile);
                   Tag_Size -= 2;
		   if(atttmp == AT_mod_u_d_type)
		      num_mod = num - 4; //modifiers + file offset(4bytes)
                   else //AT_mod_fund_type
		      num_mod = num - 2;   //modifiers + type(2bytes)
		   while(num_mod > 0){
		     MD = GetELFByte(hfile);
		     if(MD == MOD_pointer_to || MD == MOD_reference_to)
		        NUM_M_U_D_TYPE++;
		     Tag_Size--;
		     num_mod--;
		   }
		}
             }//Hera
	     SeekELFFile(hfile,Tag_Size,SEEK_CUR);
	     Tag_Size = 0;
	     break;

	case TAG_formal_parameter:
	     {
		U16 atttmp;
		int num_mod;
		BYTE MD;

		GetELFU16(hfile); //TAG_sibling
		GetELFU32(hfile); //Next TAG
		atttmp = GetELFU16(hfile);
                Tag_Size -= 8;
		/*if(atttmp == AT_mod_fund_type || atttmp == AT_mod_u_d_type)
		   NUM_M_U_D_TYPE++;*/
		if(atttmp == AT_mod_fund_type || atttmp == AT_mod_u_d_type){
		   num = GetELFU16(hfile);
                   Tag_Size -= 2;
		   if(atttmp == AT_mod_u_d_type)
		      num_mod = num - 4; //modifiers + file offset(4bytes)
                   else //AT_mod_fund_type
		      num_mod = num - 2;   //modifiers + type(2bytes)
		   while(num_mod > 0)
                   {
		     MD = GetELFByte(hfile);
		     if(MD == MOD_pointer_to || MD == MOD_reference_to)
		        NUM_M_U_D_TYPE++;
		     Tag_Size--;
		     num_mod--;
		   }
		}
		SeekELFFile(hfile,Tag_Size,SEEK_CUR);//Hera 2/9/98
		if (GetELFU32(hfile) != 4)
                   SeekELFFile(hfile,(tell(hfile)-4),SEEK_SET);
		Tag_Size = 0;
	     } 
	     break;
        //Hera
        case TAG_array_type:
        case TAG_typedef:
        case TAG_structure_type:
        case TAG_union_type:
	case TAG_enumeration_type:
	//case TAG_subroutine_type:
	       ProcessDbgTypes(hfile, typeName, Tag);
	       break;

	case TAG_padding:
	  if((err = SymGetTypeIndexMax(&tmax)) != GOOD)
		   return(err);
	  tindex = tmax + NUM_M_U_D_TYPE+1;
	  pOffset2IndexTemp =(Offset2Index*)TMalloc(sizeof(Offset2Index));
	  pOffset2IndexTemp->next = NULL;
	  pOffset2IndexTemp->tindex = tindex;
	  pOffset2IndexTemp->offset = Offset;
          if (pOffset2IndexHead == NULL){
             pOffset2IndexHead = pOffset2IndexTemp;	 
             pOffset2IndexTail = pOffset2IndexHead;
          }
          else {
             pOffset2IndexTail->next = pOffset2IndexTemp;
             pOffset2IndexTail = pOffset2IndexTemp;
          }
	  ProcessTypeinSU(hfile, SPtr);

	  if (SymAddTypeHeader(tindex, parentTypeHdr) != GOOD)
	     return(ER_SYM_TYPE);
	  while(SPtr != NULL){
	     if (SPtr->tag == TAG_member){
	        su.offset = SPtr->offset;
	        su.name = (LPSTR)(SPtr->name);
		su.typeIndex = SPtr->typeIndex;             
	        if (SymAddTypeStructUnion(tindex, &su) != GOOD)
		   return(ER_SYM_TYPE);
             }
             tptr1 = SPtr;
             SPtr = SPtr->next; 
	     TFree((LPSTR)tptr1);
          }
	  quit = 1;
	  break;
	case TAG_global_subroutine:
	case TAG_subroutine:
	  SeekELFFile(hfile,structoffset,SEEK_SET);
	  while(SPtr != NULL){
	     tptr1 = SPtr;
	     SPtr = SPtr->next;
	     TFree((LPSTR)tptr1);
          }
	  return(TAG_global_subroutine);
        default:
          break;
      }
   }//While(!quit)
   return (GOOD);
}  /* GetTypeSU */

/******************************************************************************
**
**  GetTypeClass - Process type class
**  tindexParent - type index for parent
**  stype - type (class) (not used currently)
**
******************************************************************************/
#pragma argsused /* stype */
RETCODE GetTypeClass(HANDLE hfile, U32 Offset, TYPE_HEADER_TYPE *parentTypeHdr,
                  BOOLEAN oflag, U16 lflags)
{
   CHAR name[ELF_IDNLEN] = "",typeName[ELF_IDNLEN] = "";
   CHAR tmpName[ELF_IDNLEN] = "";
   U32 tempOffset,tindex,NextMember,tmax;
   U32 NUM_M_U_D_TYPE;
   U32 lastsize,parentOffset,baseOffset;
   TYPE_C_STRUCT cls;
   S16 quit,q,index,BitFlag;
   CHAR byte;
   U16 Tag,Attribution,num, funcClass;
   TYPE_HEADER_TYPE typeHdrInfo;
   TYPE_HEADER_TYPE baseTypeHdr;
   classInfo *SPtr = NULL,*tptr1,*tptr2;
   ClassLink *cltmp;
   RETCODE err;

   typeHdrInfo.dirty = 0;
   //Hera 2/26/98
   cltmp = (ClassLink*)TMalloc(sizeof(ClassLink));
   cltmp->next = NULL;
   cltmp->size = parentTypeHdr->sizeInMAUs;
   cltmp->foff = Offset; //file offset
   if(CLbegin == NULL)
      CLbegin = CLend = cltmp;
   else{
      CLend->next = cltmp;
      CLend = cltmp;
   }
   lastsize = 0;
   //Hera      
   NUM_M_U_D_TYPE = 0;
   quit = 0;
   while(!quit)
   {
      Tag_Size = GetELFU32(hfile);
      if(Tag_Size == 4)
      {
	Tag = TAG_padding;
	Tag_Size = 0;
      }
      else
      {
	Tag = GetELFU16(hfile);
	Tag_Size -= 6;
      }
      switch(Tag) 
      {
	// <Judy 7/4/97> Here is a problem!!!
        case TAG_global_subroutine:
        case TAG_subroutine:
             if (Tag==TAG_global_subroutine)
                funcClass = FUNC_GLOBAL;
             else
                funcClass = FUNC_LOCAL;
             tptr1 = (classInfo*)TMalloc(sizeof(classInfo));
             memset(tptr1,0,sizeof(classInfo));
	     tptr1->next = NULL;

	     if(SPtr == NULL)
	     {
               tptr2 = tptr1;
	       SPtr = tptr1;
	      }
	     else
             {
	       tptr2->next = tptr1;
	       tptr2 = tptr1;
	      }
	     tptr1->isMethod=1;
	     tptr1->tag = TAG_member;
             err = ProcessDbgClassFunctions(hfile,funcClass,oflag,lflags,
                   &NextMember,tptr1,&NUM_M_U_D_TYPE);
             SeekELFFile(hfile,(DebugOffset+NextMember),SEEK_SET);
             break;
	case TAG_inheritance:
	     baseOffset = 0;
	     err = GetInheritance(hfile,&parentOffset,&baseOffset,&NextMember);
             //Hera 2/26/98
	     cltmp = CLbegin;
	     while (cltmp != NULL){
		if (parentOffset == cltmp->foff){
		   lastsize = cltmp->size + baseOffset;
		   cltmp = NULL;
		}
                else
		   cltmp = cltmp->next;
	     }//Hera
             SeekELFFile(hfile,(DebugOffset+NextMember),SEEK_SET);
             break;
        // eof <Judy 7/4/97>
	case TAG_member:
	     q = 0;
	     BitFlag = 0;
             tptr1 = (classInfo*)TMalloc(sizeof(classInfo));
             memset(tptr1,0,sizeof(classInfo));
	     tptr1->next = NULL;
             tptr1->tag = TAG_member;
	     if(SPtr == NULL)
	     {
               tptr2 = tptr1;
	       SPtr = tptr1;
	      }
	     else
             {
	       tptr2->next = tptr1;
	       tptr2 = tptr1;
	      }

	     while(!q && Tag_Size > 0)
	     {
	       Attribution = GetELFU16(hfile);
               Tag_Size -= 2;
	       switch(Attribution)
	       {
                 case AT_sibling:
		      NextMember = GetELFU32(hfile);
                      Tag_Size -= 4;
		      break;

                 /* <Judy 7/7/1997> */
                 case AT_DIAB_mangled:
		 case AT_name:
		      index = 0;
		      while((byte = GetELFByte(hfile)) != 0)
			name[index++] = byte;
		      name[index]='\0';
                      if (Attribution == AT_DIAB_mangled) {
// <Judy 8/27/97>        tempOffset = tell(hfile);
                         LdmangleDiabDemangle(name, &tmpName);
//                       LdmangleDiabGetValue(hfile,FuncName,&value, &svalue);
//                       fnAddr.offsetStartAddr=value;
//                       fnAddr.offsetEndAddr=value+svalue;
//                       SeekELFFile(hfile,tempOffset,SEEK_SET);
                      }
                      strcpy(tptr1->name, name);
		      Tag_Size -= (index+1);
		      break;

		 case AT_member:
		      GetELFU32(hfile);
		      Tag_Size -= 4;
		      break;

	       	 case AT_user_def_type:
		      tptr1->typeIndex = GetELFU32(hfile);
                      tptr1->attribution = AT_user_def_type;
                      Tag_Size -= 4;
	              break;

		 case AT_mod_u_d_type:
                 case AT_mod_fund_type:
		 {
		   int num_mod;
		   BYTE MD;

		   num = GetELFU16(hfile);
		   tptr1->attribution = Attribution;
		   if(Attribution == AT_mod_u_d_type)
		      num_mod = num - 4; //modifiers + file offset(4bytes)
                   else //AT_mod_fund_type
		      num_mod = num - 2;   //modifiers + type(2bytes)
		   while(num_mod > 0){
		     MD = GetELFByte(hfile);
		     if(MD == MOD_pointer_to){
			NUM_M_U_D_TYPE++;   //number of AT_mod_u_d_type + AT_mod_fund_type
                        (tptr1->pointerTimes)++;
			tptr1->modifier = MD;			
		     }
		     else if(MD == MOD_reference_to){
			NUM_M_U_D_TYPE++;
			tptr1->modifier = MD;
                     }
		     num_mod--;
		    }
		    if(tptr1->modifier != MOD_reference_to &&
		       tptr1->modifier != MOD_pointer_to) {
		       if(Attribution == AT_mod_fund_type){
			  tptr1->typeIndex = (U32)GetELFU16(hfile);
			  tptr1->attribution = AT_fund_type;
                       }
		       else {//AT_mod_u_d_type ????
			  tptr1->typeIndex = GetELFU32(hfile);
			  tptr1->attribution = AT_user_def_type;
                       }
                    }
		    else{ //MD == MOD_reference_to && MD == MOD_pointer_to
		       if(Attribution == AT_mod_u_d_type)
		          tptr1->utype = GetELFU32(hfile);
		       else if(Attribution == AT_mod_fund_type)
			  tptr1->utype = (U32)GetELFU16(hfile);
		    }
		    Tag_Size -= (num+2);
		    break;
		 }

		 case AT_fund_type:
		    tptr1->attribution = Attribution;
		    tptr1->typeIndex = GetELFU16(hfile);
		    Tag_Size -= 2;
		    break;

		 case AT_bit_size:
		 {
		      TYPE_BITFIELD_STRUCT bfHdrStruct;
		      typeHdrInfo.typeChoice = COMPLEX_TYPE_CLASS;
		      typeHdrInfo.sizeInMAUs = 0L;  /* default MAU size for all type */
		      typeHdrInfo.typeName = "\0";

		      if ((err = SymGetTypeIndexMax(&tmax)) != GOOD)
			  return(err);
		      tindex = tmax+1;
		      bfHdrStruct.baseTypeIndex = tptr1->typeIndex;
		      bfHdrStruct.size = GetELFU32(hfile);
		      switch(bfHdrStruct.baseTypeIndex)
		      {
			case FT_char: case FT_signed_char:
			case FT_short: case FT_signed_short:
			case FT_integer: case FT_signed_integer:
			case FT_long: case FT_signed_long:
			case FT_float: case FT_dbl_prec_float:
                        case FT_ext_prec_float:
			    bfHdrStruct.bitfieldSigned = 1; /*signed*/
			break;

			case FT_unsigned_char:
			case FT_unsigned_short:
			case FT_unsigned_integer:
			case FT_unsigned_long:
			    bfHdrStruct.bitfieldSigned = 0; /*unsigned*/
			break;

			default:
                            bfHdrStruct.bitfieldSigned = 0;
                      }

		      baseTypeHdr.typeName = (LPSTR)typeName;
		      if (SymGetTypeHeader(bfHdrStruct.baseTypeIndex, &baseTypeHdr) == GOOD)
		      {                          
			 typeHdrInfo.sizeInMAUs = baseTypeHdr.sizeInMAUs;
			 typeHdrInfo.sizeCalculated = TRUE;
		      }
		      typeHdrInfo.t.complexType = Bit_Type;
                      BitFlag = 1;
		      if ((SymAddTypeHeader(tindex,&typeHdrInfo) != GOOD) ||
			    (SymAddTypeBitfield(tindex, &bfHdrStruct) != GOOD)) 
			      return(ER_SYM_TYPE);
		      tptr1->typeIndex = tindex;
                      Tag_Size -= 4;
		      break;
		 }

		 case AT_bit_offset:
		      tptr1->offset = GetELFU16(hfile);
                      Tag_Size -= 2;
		      break;

		 case AT_location:
		      num = GetELFU16(hfile);   //number
		      GetELFByte(hfile); //OP_const
                      if(!BitFlag) //not bitfield type 
			 tptr1->offset = GetELFU32(hfile);
			 //tptr1->offset = GetELFU32(hfile) - lastsize; //Hera 2/26/98
		      else // bitfield type
			 tptr1->offset += GetELFU32(hfile)*8;

		      GetELFByte(hfile); //OP_add
                      Tag_Size -= (num+2);
		      break;
                 case AT_public:
                      tptr1->access=1;
                      GetELFByte(hfile);
                      break;
                 case AT_private:
                      tptr1->access=2;
                      GetELFByte(hfile);
                      break;
                 case AT_protected:
                      tptr1->access=3;
                      GetELFByte(hfile);
                      break;
		 default:
                      q = 1;		      
		      break;
                 }//While(!q)
	     }
	     SeekELFFile(hfile,(DebugOffset+NextMember),SEEK_SET);
             break;
        case TAG_class_type: /* <Judy 7/7/1997> */
        case TAG_array_type:
        case TAG_typedef:
        case TAG_structure_type:
        case TAG_union_type:
	case TAG_enumeration_type:
        //case TAG_subroutine_type:
	      ProcessDbgTypes(hfile, typeName, Tag);
	      break;
	//Hera 1/23/98
	case TAG_subroutine_type:
	     NUM_M_U_D_TYPE++;
	     tptr1 = (classInfo*)TMalloc(sizeof(classInfo));
	     memset(tptr1,0,sizeof(classInfo));
	     tptr1->next = NULL;

	     if(SPtr == NULL){
               tptr2 = tptr1;
	       SPtr = tptr1;
	      }
	     else{
	       tptr2->next = tptr1;
	       tptr2 = tptr1;
	     }
	     tptr1->offset = tell(hfile) - 6;
	     tptr1->tag = TAG_subroutine_type;
	     //Hera 2/10/98
	     {
		U16 atttmp;
		int num_mod;
		BYTE MD;

		GetELFU16(hfile); //Tag_sibling
		GetELFU32(hfile); //next address
		atttmp = GetELFU16(hfile);
		Tag_Size -= 8;
		if(atttmp == AT_mod_fund_type || atttmp == AT_mod_u_d_type){
		   num = GetELFU16(hfile);
                   Tag_Size -= 2;
		   if(atttmp == AT_mod_u_d_type)
		      num_mod = num - 4; //modifiers + file offset(4bytes)
                   else //AT_mod_fund_type
		      num_mod = num - 2;   //modifiers + type(2bytes)
		   while(num_mod > 0){
		     MD = GetELFByte(hfile);
		     if(MD == MOD_pointer_to || MD == MOD_reference_to)
		        NUM_M_U_D_TYPE++;
		     Tag_Size--;
		     num_mod--;
		   }
		}
	     }//Hera
	     SeekELFFile(hfile,Tag_Size,SEEK_CUR);
	     Tag_Size = 0;
	     break;

	case TAG_formal_parameter:
	     {
		U16 atttmp;
		int num_mod;
		BYTE MD;

		GetELFU16(hfile); //TAG_sibling
		GetELFU32(hfile); //Next TAG
		atttmp = GetELFU16(hfile);
                Tag_Size -= 8;
		if(atttmp == AT_mod_fund_type || atttmp == AT_mod_u_d_type){
		   num = GetELFU16(hfile);
                   Tag_Size -= 2;
		   if(atttmp == AT_mod_u_d_type)
		      num_mod = num - 4; //modifiers + file offset(4bytes)
                   else //AT_mod_fund_type
		      num_mod = num - 2;   //modifiers + type(2bytes)
		   while(num_mod > 0)
                   {
		     MD = GetELFByte(hfile);
		     if(MD == MOD_pointer_to || MD == MOD_reference_to)
		        NUM_M_U_D_TYPE++;
		     Tag_Size --;
		     num_mod--;
		   }
                }
		SeekELFFile(hfile,Tag_Size,SEEK_CUR);
		if (GetELFU32(hfile) != 4)
		   SeekELFFile(hfile, (tell(hfile)-4),SEEK_SET);
		Tag_Size = 0;
	     }
	     break;
	//Hera

	case TAG_padding:
	  quit = 1;
          break;
        default:
          break;
      }
   }//While(!quit)

   if((err = SymGetTypeIndexMax(&tmax)) != GOOD)
            return(err);
   tindex = tmax + NUM_M_U_D_TYPE+1;
   pOffset2IndexTemp =(Offset2Index*)TMalloc(sizeof(Offset2Index));
   pOffset2IndexTemp->next = NULL;
   pOffset2IndexTemp->tindex = tindex;
   pOffset2IndexTemp->offset = Offset;
   if (pOffset2IndexHead == NULL){
      pOffset2IndexHead = pOffset2IndexTemp;
      pOffset2IndexTail = pOffset2IndexHead;
   }
   else {
      pOffset2IndexTail->next = pOffset2IndexTemp;
      pOffset2IndexTail = pOffset2IndexTemp;
   }
   //FOffset2TIndex[CTIndex].tindex = tindex;
   //FOffset2TIndex[CTIndex++].offset = Offset;
   //Define Type of fields in Struct or Union
   ProcessTypeinClass(hfile, SPtr);

   if((err = SymGetTypeIndexMax(&tmax)) != GOOD)
      return(err);
   tindex = tmax+1;

   if (SymAddTypeHeader(tindex, parentTypeHdr) != GOOD)
      return(ER_SYM_TYPE);
   while(SPtr != NULL){
      if(SPtr->tag == TAG_member) { 
         cls.offset = SPtr->offset;
         cls.name = (LPSTR)(SPtr->name);
	 cls.typeIndex = SPtr->typeIndex;
         cls.isMethod = SPtr->isMethod;
         if(cls.isMethod) {
            cls.fnAddr.offsetStartAddr = SPtr->fnAddr.offsetStartAddr;
            cls.fnAddr.offsetEndAddr = SPtr->fnAddr.offsetEndAddr;
         }
         cls.access= SPtr->access;
         if (SymAddTypeClass(tindex, &cls) != GOOD)
	    return(ER_SYM_TYPE);
      }
      tptr1 = SPtr;
      SPtr = SPtr->next;
      TFree((LPSTR)tptr1);
   }
   return (GOOD);
}  /* GetTypeClass */

/******************************************************************************
**
**  GetTypeEnum - Process enum type
**
** tindexParent - type index for parent 
**
******************************************************************************/
RETCODE GetTypeEnum(HANDLE hfile, U32 Offset, TYPE_HEADER_TYPE *parentTypeHdr)
{
   CHAR mbrName[ELF_IDNLEN];
   U32 mbrValue;   
   U32 num,tindex,tmax;
   RETCODE symerr = GOOD;  
   int index;
   char byte;

   if((symerr = SymGetTypeIndexMax(&tmax)) != GOOD)
      return(symerr);
   tindex = tmax+1;
   pOffset2IndexTemp =(Offset2Index*)TMalloc(sizeof(Offset2Index));
   pOffset2IndexTemp->next = NULL;
   pOffset2IndexTemp->tindex = tindex;
   pOffset2IndexTemp->offset = Offset;
   if (pOffset2IndexHead == NULL){
      pOffset2IndexHead = pOffset2IndexTemp;	 
      pOffset2IndexTail = pOffset2IndexHead;
   }
   else {
      pOffset2IndexTail->next = pOffset2IndexTemp;
      pOffset2IndexTail = pOffset2IndexTemp;
   }
//   FOffset2TIndex[CTIndex].tindex = tindex;
//   FOffset2TIndex[CTIndex++].offset = Offset;

   if ((symerr = SymAddTypeHeader(tindex, parentTypeHdr)) != GOOD)
      return(ER_SYM_TYPE);

   num = GetELFU32(hfile);   
   while(num > 0)
   {
     mbrValue = GetELFU32(hfile);
     num -= 4;
     index = 0;
     while((byte = GetELFByte(hfile)) != 0)
       mbrName[index++] = byte;
     mbrName[index] = '\0';
     num -= (index+1);
     if ((symerr = SymAddTypeEnum(tindex, mbrValue, mbrName)) != GOOD)
     	return(ER_SYM_TYPE);
   }
   Tag_Size = 0;
   return (GOOD);
}  /* GetTypeEnum */

/******************************************************************************
**
**  GetTypeArr - Process type array
**
******************************************************************************/
RETCODE GetTypeArr(HANDLE hfile, U32 Offset,
		   TYPE_HEADER_TYPE *parentTypeHdr) {
   TYPE_Z_STRUCT arrayHdrStruct;
   TYPE_HEADER_TYPE elementTypeHdr,typeHdrInfo;
   CHAR typeName[ELF_IDNLEN] = "";
   int quit;
   U32 Attribution,NextTag;
   U32 lowBound,highBound;
   int num;
   U16 EType,pointerTimes;
   U32 tmax,tindex,utype;
   BYTE Format,modifier;
   RETCODE err = GOOD;
   BOOLEAN found;

   typeHdrInfo.dirty = 0;//Hera 3/11/98
   pointerTimes = 0;
   quit = 0;
   while(!quit && Tag_Size > 0)
   {
      Attribution = GetELFU16(hfile);
      Tag_Size -= 2;

      switch(Attribution)
      {
	 case AT_sibling:
	      NextTag = GetELFU32(hfile);
	      Tag_Size -= 4;
	      break;

	 case AT_ordering:
	      GetELFU16(hfile);
	      Tag_Size -= 2;
	      break;

	 case AT_subscr_data:
              num = GetELFU16(hfile); //number
	      Format = GetELFByte(hfile); //Format    
	      if(Format <= 3)  //index type:fund_type =>lower 2bytes
                 GetELFU16(hfile);	          
	      else if(Format >= 4 && Format <= 7) //user_type => 4bytes
                 GetELFU32(hfile);              
	      lowBound = GetELFU32(hfile);
	      highBound = GetELFU32(hfile);

              //Only process FMT_FT_C_C and FMT_UT_C_C
	      if(Format%4 == 0) 
		 arrayHdrStruct.highBound = highBound;
	      
	      GetELFByte(hfile); //element_list
	      EType = GetELFU16(hfile);

	      switch(EType)
	      {
                case AT_fund_type:
		   arrayHdrStruct.typeIndex = (U32)GetELFU16(hfile);
		   break;

                case AT_user_def_type:
		   arrayHdrStruct.typeIndex = GetELFU32(hfile);
		   /*pOffset2IndexTemp = pOffset2IndexHead;
	           while (pOffset2IndexTemp != NULL) {
	              if (arrayHdrStruct.typeIndex == pOffset2IndexTemp->offset){
		         arrayHdrStruct.typeIndex = pOffset2IndexTemp->tindex;
			 pOffset2IndexTemp = NULL;
                         //typeHdrInfo.dirty = 0;
	              }
                      else{
			 pOffset2IndexTemp = pOffset2IndexTemp->next;
			 //typeHdrInfo.dirty = 1;
                      }
		   }*/
		   SearchForType(arrayHdrStruct.typeIndex,&(arrayHdrStruct.typeIndex),&found);
                   if(!found) typeHdrInfo.dirty = 1;
		   break;

		case AT_mod_fund_type:
	        {
		   int number,num_mod;
		   BYTE MD;

	           number = GetELFU16(hfile);//number;
		   modifier = MOD_const; //default
	           num_mod = number - 2; //modifiers+type(2bytes);
	           while(num_mod > 0){
                      MD = GetELFByte(hfile);
		      if(MD == MOD_pointer_to){
		         modifier = MD;
		         pointerTimes++;
		      }
		      else if(MD == MOD_reference_to)
                         modifier = MD;
		      num_mod--;
		   }
                   utype = (U32) GetELFU16(hfile);
		   while(modifier == MOD_pointer_to && pointerTimes){
	              typeHdrInfo.typeChoice = COMPLEX_TYPE_CLASS;
                      typeHdrInfo.typeName = "\0";
                  
                      if ((err = SymGetTypeIndexMax(&tmax)) != GOOD)
         	         return(err);

	              tindex = tmax+1;
	              typeHdrInfo.t.complexType = Pointer;
                      typeHdrInfo.sizeInMAUs = 4;
                      typeHdrInfo.sizeCalculated = TRUE;
	              if (SymAddTypeHeader(tindex, &typeHdrInfo) != GOOD) 
                         return(ER_SYM_TYPE);

		      err = GetTypePtr(tindex,utype);
		      arrayHdrStruct.typeIndex = tindex;
		      utype = tindex;
                      pointerTimes--;
		   }
		   //Hera 2/9/98
	           if (modifier == MOD_reference_to) {
	              typeHdrInfo.typeChoice = COMPLEX_TYPE_CLASS;
	              typeHdrInfo.typeName = "\0";
	              if ((err = SymGetTypeIndexMax(&tmax)) != GOOD) return(err);
	              tindex = tmax + 1;
	              typeHdrInfo.t.complexType = Reference;
	              typeHdrInfo.sizeInMAUs = 4;
	              typeHdrInfo.sizeCalculated = TRUE;
	              if (SymAddTypeHeader(tindex, &typeHdrInfo) != GOOD)
		         return(ER_SYM_TYPE);
	              err = GetTypeRef(tindex,utype);
	              utype = tindex;
	            }
	            if (modifier == MOD_const)            
		       arrayHdrStruct.typeIndex = utype;
		    break;
		}

	        case AT_mod_u_d_type:
                {
               	  int num_mod;
		  BYTE MD;

		  modifier = MOD_const; //default
	          num = GetELFU16(hfile); // number
	          num_mod = num - 4;//modifiers+file offset(4bytes)
	          while(num_mod > 0)
                  {
	             MD = GetELFByte(hfile); //modifier
		     if(MD == MOD_pointer_to){
			modifier = MD;
			pointerTimes++;
		     }
		     else if(MD == MOD_reference_to)
		        modifier = MD;     
		     num_mod--;
                  }
	          utype = GetELFU32(hfile); //poiter to utype
		  /*pOffset2IndexTemp = pOffset2IndexHead;
	          while (pOffset2IndexTemp != NULL) {
	             if (utype == pOffset2IndexTemp->offset){
		        utype = pOffset2IndexTemp->tindex;
			pOffset2IndexTemp = NULL;
                        //typeHdrInfo.dirty = 0;
	             }
		     else{
			pOffset2IndexTemp = pOffset2IndexTemp->next;
			//typeHdrInfo.dirty = 1;
                     }
		  }*/
		  SearchForType(utype, &utype, &found);
                  if(!found) typeHdrInfo.dirty = 1;
	          while(modifier == MOD_pointer_to && pointerTimes)
	          {
	             typeHdrInfo.typeChoice = COMPLEX_TYPE_CLASS;
                     typeHdrInfo.typeName = "\0";
                  
                     if ((err = SymGetTypeIndexMax(&tmax)) != GOOD)
         	         return(err);

	             tindex = tmax+1;
	             typeHdrInfo.t.complexType = Pointer;
                     typeHdrInfo.sizeInMAUs = 4;
                     typeHdrInfo.sizeCalculated = TRUE;
	             if (SymAddTypeHeader(tindex, &typeHdrInfo) != GOOD) 
                         return(ER_SYM_TYPE);

		     err = GetTypePtr(tindex, utype);
		     arrayHdrStruct.typeIndex = tindex;
		     utype = tindex;
                     pointerTimes--;
		  }
		  //Hera 2/9/98
	          if (modifier == MOD_reference_to) {
	             typeHdrInfo.typeChoice = COMPLEX_TYPE_CLASS;
	             typeHdrInfo.typeName = "\0";
	             if ((err = SymGetTypeIndexMax(&tmax)) != GOOD) return(err);
	             tindex = tmax + 1;
	             typeHdrInfo.t.complexType = Reference;
	             typeHdrInfo.sizeInMAUs = 4;
	             typeHdrInfo.sizeCalculated = TRUE;
	             if (SymAddTypeHeader(tindex, &typeHdrInfo) != GOOD)
		        return(ER_SYM_TYPE);
	             err = GetTypeRef(tindex,utype);
	             utype = tindex;
	          }
		  if(modifier == MOD_const)
		      arrayHdrStruct.typeIndex = utype;		  
		   break;
                 }
             }
	     Tag_Size -= (num+2);   
	 break;
              
	 default:
	      if(Tag_Size > 0)
		 SeekELFFile(hfile,Tag_Size,SEEK_CUR);
	      Tag_Size = 0;
              quit = 1;
              break;
      }
   }
   SeekELFFile(hfile,(DebugOffset+NextTag),SEEK_SET);
   elementTypeHdr.typeName = (LPSTR)typeName;
   if (SymGetTypeHeader(arrayHdrStruct.typeIndex, &elementTypeHdr) == GOOD) {
      parentTypeHdr->sizeInMAUs = elementTypeHdr.sizeInMAUs *
				     (arrayHdrStruct.highBound+1);
      parentTypeHdr->sizeCalculated = TRUE;
   }
   if((err = SymGetTypeIndexMax(&tmax)) != GOOD)
      return(err);
   tindex = tmax+1;
   pOffset2IndexTemp =(Offset2Index*)TMalloc(sizeof(Offset2Index));
   pOffset2IndexTemp->next = NULL;
   pOffset2IndexTemp->tindex = tindex;
   pOffset2IndexTemp->offset = Offset;
   if (pOffset2IndexHead == NULL){
      pOffset2IndexHead = pOffset2IndexTemp;	 
      pOffset2IndexTail = pOffset2IndexHead;
   }
   else {
      pOffset2IndexTail->next = pOffset2IndexTemp;
      pOffset2IndexTail = pOffset2IndexTemp;
   }
   //FOffset2TIndex[CTIndex].tindex = tindex;
   //FOffset2TIndex[CTIndex++].offset = Offset;

   if ((SymAddTypeHeader(tindex, parentTypeHdr) != GOOD) ||
      (SymAddTypeCArray(tindex, &arrayHdrStruct) != GOOD)) 
      return(ER_SYM_TYPE);

   return(err);
}  /* GetTypeArr */

/****************************************************************************
**
** ProcessTypeinSU
**
*****************************************************************************/
RETCODE PRIVATE ProcessTypeinSU(HANDLE hfile, StructInfo* Sptr)
{
   StructInfo *tptr;
   TYPE_HEADER_TYPE typeHdrInfo;
   RETCODE err = GOOD;
   U32 tindex,tmax,utype;
   BYTE modifier;
   BOOLEAN found;

   typeHdrInfo.dirty = 0;
   tptr = Sptr;
   while(tptr != NULL){
      if(tptr->tag == TAG_member){
      switch(tptr->attribution){
	 case AT_user_def_type:
            err = ER_SYM_TYPE;
	    /*pOffset2IndexTemp = pOffset2IndexHead;
	    while (pOffset2IndexTemp != NULL) {
	       if (tptr->typeIndex == pOffset2IndexTemp->offset){
		      tptr->typeIndex = pOffset2IndexTemp->tindex;
                      err = GOOD;
		      pOffset2IndexTemp = NULL;
	       }
               else
	          pOffset2IndexTemp = pOffset2IndexTemp->next;
	    }*/
	    SearchForType(tptr->typeIndex,&(tptr->typeIndex),&found);
	    if(!found) typeHdrInfo.dirty = 1;
            break;
         case AT_mod_u_d_type:
         case AT_mod_fund_type:		
	    modifier = tptr->modifier; //modifier
	    utype = tptr->utype;
            err = ER_SYM_TYPE;
	    if(tptr->attribution == AT_mod_u_d_type){
	       /*pOffset2IndexTemp = pOffset2IndexHead;
	       while (pOffset2IndexTemp != NULL) {
	          if (utype == pOffset2IndexTemp->offset){
		      utype = pOffset2IndexTemp->tindex;
                      err = GOOD;
		      pOffset2IndexTemp = NULL;
                      //typeHdrInfo.dirty = 0;
	           }
		   else{
		      pOffset2IndexTemp = pOffset2IndexTemp->next;
		      //typeHdrInfo.dirty = 1;
                   }
		}*/
		SearchForType(utype,&utype,&found);
		if(!found) typeHdrInfo.dirty = 1;
	    }
	    while(modifier == MOD_pointer_to && tptr->pointerTimes){
	       typeHdrInfo.typeChoice = COMPLEX_TYPE_CLASS;  
	       typeHdrInfo.typeName = "\0";
               if((err = SymGetTypeIndexMax(&tmax)) != GOOD)
	          return(err);
	       tindex = tmax+1;
	       typeHdrInfo.t.complexType = Pointer;
               typeHdrInfo.sizeInMAUs = 4;
               typeHdrInfo.sizeCalculated = TRUE;
	       if(SymAddTypeHeader(tindex, &typeHdrInfo) != GOOD) 
	          return(ER_SYM_TYPE);  
               err = GetTypePtr(tindex, utype);
	       utype = tindex;
	       tptr->typeIndex = tindex;
               tptr->pointerTimes--;
	    }
	    //Hera 2/9/98
	    if (modifier == MOD_reference_to) {
	       typeHdrInfo.typeChoice = COMPLEX_TYPE_CLASS;
	       typeHdrInfo.typeName = "\0";
	       if ((err = SymGetTypeIndexMax(&tmax)) != GOOD) return(err);
	       tindex = tmax + 1;
	       typeHdrInfo.t.complexType = Reference;
	       typeHdrInfo.sizeInMAUs = 4;
	       typeHdrInfo.sizeCalculated = TRUE;
	       if (SymAddTypeHeader(tindex, &typeHdrInfo) != GOOD)
	          return(ER_SYM_TYPE);
	       err = GetTypeRef(tindex,utype);
	       utype = tindex;
	    }
	    if(modifier == MOD_const)
	       tptr->typeIndex = utype;
            break;
      }
      }//if TAG_member
      else if(tptr->tag == TAG_subroutine_type) {
	 CHAR typeName[ELF_IDNLEN] = "";
	 long offsettmp = tell(hfile);
	 SeekELFFile(hfile,tptr->offset,SEEK_SET);
	 Tag_Size = GetELFU32(hfile); //SIZE
	 GetELFU16(hfile); //TAG
	 Tag_Size -= 6;
	 ProcessDbgTypes(hfile, typeName, tptr->tag);
	 SeekELFFile(hfile,offsettmp,SEEK_SET);
	 Tag_Size = 0;
      }
      tptr = tptr->next;
   }//while(tptr != NULL)
   return(err);
}
/****************************************************************************
**
** ProcessTypeinClass
**
*****************************************************************************/
RETCODE PRIVATE ProcessTypeinClass(HANDLE hfile, classInfo* Sptr)
{
   classInfo *tptr;
   TYPE_HEADER_TYPE typeHdrInfo;
   RETCODE err = GOOD;
   U32 tindex,tmax,utype;
   BYTE modifier;
   BOOLEAN found;

   typeHdrInfo.dirty = 0;
   tptr = Sptr;
   while(tptr != NULL){
      if(tptr->tag == TAG_member) {
         switch(tptr->attribution){
	    case AT_user_def_type:
               err = ER_SYM_TYPE;
	       /*pOffset2IndexTemp = pOffset2IndexHead;
	       while (pOffset2IndexTemp != NULL) {
	          if (tptr->typeIndex == pOffset2IndexTemp->offset){
		     tptr->typeIndex = pOffset2IndexTemp->tindex;
                     err = GOOD;
		     pOffset2IndexTemp = NULL;
	          }
                  else
	             pOffset2IndexTemp = pOffset2IndexTemp->next;
	       }*/
	       SearchForType(tptr->typeIndex,&(tptr->typeIndex),&found);
               if(!found)typeHdrInfo.dirty = 1;
               break;
            case AT_mod_u_d_type:
            case AT_mod_fund_type:		
	       modifier = tptr->modifier; //modifier
	       utype = tptr->utype;
               err = ER_SYM_TYPE;
	       if(tptr->attribution == AT_mod_u_d_type){
	          /*pOffset2IndexTemp = pOffset2IndexHead;
	          while (pOffset2IndexTemp != NULL) {
	             if (utype == pOffset2IndexTemp->offset){
		        utype = pOffset2IndexTemp->tindex;
                        err = GOOD;
			pOffset2IndexTemp = NULL;
                        //typeHdrInfo.dirty = 0;
	             }
		     else{
			pOffset2IndexTemp = pOffset2IndexTemp->next;
			//typeHdrInfo.dirty = 1;
                     }
		  }*/
		  SearchForType(utype,&utype,&found);
		  if(!found) typeHdrInfo.dirty = 1;
	       }
	       while(modifier == MOD_pointer_to && tptr->pointerTimes){
	          typeHdrInfo.typeChoice = COMPLEX_TYPE_CLASS;  
	          typeHdrInfo.typeName = "\0";
                  if((err = SymGetTypeIndexMax(&tmax)) != GOOD)
	             return(err);
	          tindex = tmax+1;
	          typeHdrInfo.t.complexType = Pointer;
                  typeHdrInfo.sizeInMAUs = 4;
                  typeHdrInfo.sizeCalculated = TRUE;
	          if(SymAddTypeHeader(tindex, &typeHdrInfo) != GOOD) 
	             return(ER_SYM_TYPE);  
                  err = GetTypePtr(tindex, utype);
	          utype = tindex;
	          tptr->typeIndex = tindex;
                  tptr->pointerTimes--;
	       }
	       //Hera 2/9/98
	       if (modifier == MOD_reference_to) {
	          typeHdrInfo.typeChoice = COMPLEX_TYPE_CLASS;
	          typeHdrInfo.typeName = "\0";
	          if ((err = SymGetTypeIndexMax(&tmax)) != GOOD) return(err);
	          tindex = tmax + 1;
	          typeHdrInfo.t.complexType = Reference;
	          typeHdrInfo.sizeInMAUs = 4;
	          typeHdrInfo.sizeCalculated = TRUE;
	          if (SymAddTypeHeader(tindex, &typeHdrInfo) != GOOD)
		     return(ER_SYM_TYPE);
	          err = GetTypeRef(tindex,utype);
	          utype = tindex;
	       }
	       //if(modifier == MOD_const)
               else
		  tptr->typeIndex = utype;
               break;
	 }
      } //if(TAG_member)
      else if(tptr->tag == TAG_subroutine_type) {
	 CHAR typeName[ELF_IDNLEN] = "";
	 long offsettmp = tell(hfile);
	 SeekELFFile(hfile,tptr->offset,SEEK_SET);
	 Tag_Size = GetELFU32(hfile); //SIZE
	 GetELFU16(hfile); //TAG
	 Tag_Size -= 6;
	 ProcessDbgTypes(hfile, typeName, tptr->tag);
	 SeekELFFile(hfile,offsettmp,SEEK_SET);
	 Tag_Size = 0;
      }
      tptr = tptr->next;
   }//while(tptr != NULL)
   return(err);
}



/*************************************************************************
*    GetTypeProc
*
***************************************************************************/
RETCODE GetTypeProc(HANDLE hfile,U32 Offset,TYPE_HEADER_TYPE *parentTypeHdr) {
   U16 attribution,numParam;
   U32 nextTag,tindex,tmax,rtn_type;
   TYPE_HEADER_TYPE typeHdrInfo;
   RETCODE err,symerr;
   int i,pointerTimes;
   U32 typeParam[ELF_IDNLEN],backOffset;
   U16 Tag;
   BOOLEAN found;

   typeHdrInfo.dirty = 0;
   pointerTimes = 0;
   while(Tag_Size > 0){
      attribution = GetELFU16(hfile);
      Tag_Size -= 2;
      switch(attribution){
         case AT_sibling:
	    nextTag = GetELFU32(hfile);
	    /*for (i = 0; i < CTIndex; i++)
                if (Offset == FOffset2TIndex[i].offset){
		   SeekELFFile(hfile,(DebugOffset+nextTag),SEEK_SET);
		   Tag_Size = 0;
                   return(GOOD);
		}*/
	    pOffset2IndexTemp = pOffset2IndexHead;
	    while (pOffset2IndexTemp != NULL) {
	       if (Offset == pOffset2IndexTemp->offset){
		  SeekELFFile(hfile,(DebugOffset+nextTag),SEEK_SET);
		  Tag_Size = 0;
		  return(GOOD);
	       }
               else
	          pOffset2IndexTemp = pOffset2IndexTemp->next;
	    }
            Tag_Size -= 4;
	    break;

	 case AT_user_def_type:
            rtn_type = GetELFU32(hfile);
            Tag_Size -= 4;
            /*for(i = 0; i < CTIndex; i++)
               if(rtn_type == FOffset2TIndex[i].offset){
                 rtn_type = FOffset2TIndex[i].tindex;
                 i = CTIndex;
	       }*/
	    /*pOffset2IndexTemp = pOffset2IndexHead;
	    while (pOffset2IndexTemp != NULL) {
	       if (rtn_type == pOffset2IndexTemp->offset){
	          rtn_type = pOffset2IndexTemp->tindex;
	          pOffset2IndexTemp = NULL;
	       }
               else
	          pOffset2IndexTemp = pOffset2IndexTemp->next;
	    }*/
	    SearchForType(rtn_type,&rtn_type,&found);
            if(!found) typeHdrInfo.dirty = 1;
	    break;

         case AT_mod_u_d_type:{
	    int num, num_mod, modifier, MD;
	    U32 utype;

            num = GetELFU16(hfile); // number
            num_mod = num - 4; //modifiers + file offset(4 bytes)
            while(num_mod > 0){
               MD = GetELFByte(hfile); //modifier
	       if(MD == MOD_pointer_to){
	          modifier = MD;
		  pointerTimes++;
	       }
	       else if(MD == MOD_reference_to)
                  modifier = MD;
	       num_mod--;
            }
	    utype = GetELFU32(hfile); //poiter to utype
	    /*pOffset2IndexTemp = pOffset2IndexHead;
	    while (pOffset2IndexTemp != NULL) {
	       if (utype == pOffset2IndexTemp->offset){
	          utype = pOffset2IndexTemp->tindex;
		  pOffset2IndexTemp = NULL;
                  //typeHdrInfo.dirty = 0;
	       }
               else{
		  pOffset2IndexTemp = pOffset2IndexTemp->next;
		  //typeHdrInfo.dirty = 1;
               }
	    }*/
	    SearchForType(utype,&utype,&found);
	    if(!found) typeHdrInfo.dirty = 1;
	    while(modifier == MOD_pointer_to && pointerTimes){
	       typeHdrInfo.typeChoice = COMPLEX_TYPE_CLASS;
               typeHdrInfo.typeName = "\0";

               if ((err = SymGetTypeIndexMax(&tmax)) != GOOD)
                  return(err);
	       rtn_type = tmax+1;
	       typeHdrInfo.t.complexType = Pointer;
               typeHdrInfo.sizeInMAUs = 4;
               typeHdrInfo.sizeCalculated = TRUE;
	       if (SymAddTypeHeader(rtn_type, &typeHdrInfo) != GOOD) 
                  return(ER_SYM_TYPE);
	       err = GetTypePtr(rtn_type, utype);
	       utype = rtn_type;
               pointerTimes--;
	     }
	     //Hera 2/9/98
	     if (modifier == MOD_reference_to) {
	        typeHdrInfo.typeChoice = COMPLEX_TYPE_CLASS;
	        typeHdrInfo.typeName = "\0";
	        if ((err = SymGetTypeIndexMax(&tmax)) != GOOD) return(err);
	        tindex = tmax + 1;
	        typeHdrInfo.t.complexType = Reference;
	        typeHdrInfo.sizeInMAUs = 4;
	        typeHdrInfo.sizeCalculated = TRUE;
	        if (SymAddTypeHeader(tindex, &typeHdrInfo) != GOOD)
	    	   return(ER_SYM_TYPE);
	        err = GetTypeRef(tindex,utype);
	        utype = tindex;
	     }
	     Tag_Size -= (num+2);
	     break;
         }

         case AT_mod_fund_type:{
	    int num_mod,MFlag,num;
            U8 modifier,MD;
	    U32 utype;

            num = GetELFU16(hfile);//number;
            num_mod = num - 2; //modifiers + type(2bytes)
            modifier = 0;
            MFlag = 0;
            while(num_mod > 0){
               MD = GetELFByte(hfile);             
               if(MD == MOD_pointer_to){
	          modifier = MD;
		  pointerTimes++;
	       }
	       else if(MD == MOD_reference_to)
                  modifier = MD;
	       num_mod--;
	    }
	    utype = (U32)GetELFU16(hfile);
	    //MOD_reference_to is not implemented
	    while(modifier == MOD_pointer_to && pointerTimes){
	       typeHdrInfo.typeChoice = COMPLEX_TYPE_CLASS;
               typeHdrInfo.typeName = "\0";
               if ((err = SymGetTypeIndexMax(&tmax)) != GOOD)
                  return(err);

	       rtn_type = tmax+1;
	       typeHdrInfo.t.complexType = Pointer;
               typeHdrInfo.sizeInMAUs = 4;
	       typeHdrInfo.sizeCalculated = TRUE;
	       if (SymAddTypeHeader(rtn_type, &typeHdrInfo) != GOOD) 
                   return(ER_SYM_TYPE);

	       err = GetTypePtr(rtn_type, utype);
	       utype = rtn_type;
               pointerTimes--;
	    }
	    //Hera 2/9/98
	    if (modifier == MOD_reference_to) {
	       typeHdrInfo.typeChoice = COMPLEX_TYPE_CLASS;
	       typeHdrInfo.typeName = "\0";
	       if ((err = SymGetTypeIndexMax(&tmax)) != GOOD) return(err);
	       tindex = tmax + 1;
	       typeHdrInfo.t.complexType = Reference;
	       typeHdrInfo.sizeInMAUs = 4;
	       typeHdrInfo.sizeCalculated = TRUE;
	       if (SymAddTypeHeader(tindex, &typeHdrInfo) != GOOD)
	          return(ER_SYM_TYPE);
	       err = GetTypeRef(tindex,utype);
	       utype = tindex;
	    }
	    Tag_Size -= (num+2);           
	    break;
         }

         case AT_fund_type:
	    rtn_type = (U32)GetELFU16(hfile);
            Tag_Size -= 2;
	    break;

      }
   }//while(Tag_Size > 0)
//   SeekELFFile(hfile,(DebugOffset+nextTag),SEEK_SET); <Judy 8/27/97>
   backOffset = tell(hfile);
   Tag_Size = GetELFU32(hfile);
   numParam = 0;
   if ((DebugOffset+nextTag) >= backOffset/*Hera 3/16/98*/) {
      if (Tag_Size == 4)
         SeekELFFile(hfile,backOffset,SEEK_SET);
      else {
         Tag = GetELFU16(hfile);
         SeekELFFile(hfile,backOffset,SEEK_SET);
         if(Tag_Size != 4 && Tag == TAG_formal_parameter)
            ProcessDbgParameter(hfile,&numParam,typeParam);
      }
   }
   //else if(Tag_Size !=4 && Tag != TAG_formal_parameter)
   //   SeekELFFile(hfile,backOffset,SEEK_SET);
   //}
   //else if((DebugOffset+nextTag) == backOffset)
   //   SeekELFFile(hfile, backOffset, SEEK_SET);
   if ((err = SymGetTypeIndexMax(&tmax)) != GOOD)
      return(err);
   tindex = tmax+1;
   pOffset2IndexTemp =(Offset2Index*)TMalloc(sizeof(Offset2Index));
   pOffset2IndexTemp->next = NULL;
   pOffset2IndexTemp->tindex = tindex;
   pOffset2IndexTemp->offset = Offset;
   if (pOffset2IndexHead == NULL){
      pOffset2IndexHead = pOffset2IndexTemp;	 
      pOffset2IndexTail = pOffset2IndexHead;
   }
   else {
      pOffset2IndexTail->next = pOffset2IndexTemp;
      pOffset2IndexTail = pOffset2IndexTemp;
   }
//   FOffset2TIndex[CTIndex].tindex = tindex;
//   FOffset2TIndex[CTIndex++].offset = Offset;

   if ((symerr = SymAddTypeHeader(tindex, parentTypeHdr)) != GOOD)
      err = ER_SYM_TYPE;
   if (SymAddTypeFunc(tindex, /*attr*/0, /*frame*/0,/*pushmask*/0, rtn_type,
                      numParam, /*level*/0, (LPSTR)/*parentName*/"\0") != GOOD)
      return(ER_SYM_TYPE);
   for (i = 0; i < numParam; i++)
     if (SymAddTypeFuncParam(tindex, typeParam[i])  != GOOD){
         err = ER_SYM_TYPE;
         break;
     }
   return(GOOD);
}

/********************************************************************
 *                                                                  *
 *  Get Inheritance Class -- Hera 2/26/98                           *
 *                                                                  *
 *******************************************************************/ 
RETCODE GetInheritance(HANDLE hfile,U32 *parentOffset, U32 *baseOffset,
			  U32 *NextMember){

   S16 q,index;
   CHAR byte;
   U16 Attribution,num;
   CHAR name[ELF_IDNLEN] = "";

   q = 0;
   while(!q && Tag_Size > 0)
   {
     Attribution = GetELFU16(hfile);
     Tag_Size -= 2;
     switch(Attribution)
     {
       case AT_sibling:
            *NextMember = GetELFU32(hfile);
            Tag_Size -= 4;
            break;

       case AT_name:
            index = 0;
            while((byte = GetELFByte(hfile)) != 0)
              name[index++] = byte;
            name[index]='\0';
            //SetTypeClassInher(parentTypeHdr->typeName,name);
            Tag_Size -= (index+1);
            break;
       case AT_user_def_type:
            //tptr1->typeIndex = GetELFU32(hfile);
	    //tptr1->attribution = AT_user_def_type;
            *parentOffset = GetELFU32(hfile);
            Tag_Size -= 4;
            break;

       case AT_location:
            num = GetELFU16(hfile);   //number
            GetELFByte(hfile); //OP_const
            //tptr1->offset = GetELFU32(hfile);
	    *baseOffset = GetELFU32(hfile);
            GetELFByte(hfile); //OP_add
            Tag_Size -= (num+2);
            break;
       default:
            q = 1;
            break;
       }
   }//While(!q)
   return (GOOD);
}
/* <Judy 7/9/97> */
/*RETCODE GetInheritance(HANDLE hfile,U32 Offset,TYPE_HEADER_TYPE *parentTypeHdr,
                       U32 *NextMember) {
   CHAR name[ELF_IDNLEN] = "",typeName[ELF_IDNLEN] = "";
   CHAR tmpName[ELF_IDNLEN] = "";
   U32 tindex,tmax;
   U32 NUM_M_U_D_TYPE;
   TYPE_S_U_STRUCT su;
   S16 q,index;
   CHAR byte;
   U16 Attribution,num;
   StructInfo *SPtr = NULL,*tptr1,*tptr2;
   RETCODE err;

   NUM_M_U_D_TYPE = 0;
   tptr1 = (StructInfo*)TMalloc(sizeof(StructInfo));
   memset(tptr1,0,sizeof(StructInfo));
   tptr1->next = NULL;

   if(SPtr == NULL)
   {
     tptr2 = tptr1;
     SPtr = tptr1;
    }
   else
   {
     tptr2->next = tptr1;
     tptr2 = tptr1;
    }
   q=0;
   while(!q && Tag_Size > 0)
   {
     Attribution = GetELFU16(hfile);
     Tag_Size -= 2;
     switch(Attribution)
     {
       case AT_sibling:
            *NextMember = GetELFU32(hfile);
            Tag_Size -= 4;
            break;

       case AT_name:
            index = 0;
            while((byte = GetELFByte(hfile)) != 0)
              name[index++] = byte;
            name[index]='\0';
            SetTypeClassInher(parentTypeHdr->typeName, name);
            Tag_Size -= (index+1);
            break;
       case AT_user_def_type:
            tptr1->typeIndex = GetELFU32(hfile);
            tptr1->attribution = AT_user_def_type;
            Tag_Size -= 4;
            break;

       case AT_mod_u_d_type:
       case AT_mod_fund_type:
            {
            int num_mod;
            BYTE MD;

            num = GetELFU16(hfile);
            tptr1->attribution = Attribution;
            if(Attribution == AT_mod_u_d_type)
               num_mod = num - 4; //modifiers + file offset(4bytes)
            else //AT_mod_fund_type
               num_mod = num - 2;   //modifiers + type(2bytes)
            while(num_mod > 0) {
              MD = GetELFByte(hfile);
              if(MD == MOD_pointer_to) {
                 NUM_M_U_D_TYPE++;   //number of AT_mod_u_d_type + AT_mod_fund_type
                 (tptr1->pointerTimes)++;
                 tptr1->modifier = MD;
	       }
	       else if(MD == MOD_reference_to) {
                  NUM_M_U_D_TYPE++;
		  tptr1->modifier = MD;
               }
               num_mod--;
            }
            if(Attribution == AT_mod_u_d_type)
              tptr1->utype = GetELFU32(hfile);
            else if(Attribution == AT_mod_fund_type)
              tptr1->utype = (U32)GetELFU16(hfile);
            Tag_Size -= (num+2);
            break;
            }
       case AT_fund_type:
            tptr1->attribution = Attribution;
            tptr1->typeIndex = GetELFU16(hfile);
            Tag_Size -= 2;
            break;
       case AT_location:
            num = GetELFU16(hfile);   //number
            GetELFByte(hfile); //OP_const
            tptr1->offset = GetELFU32(hfile);

            GetELFByte(hfile); //OP_add
            Tag_Size -= (num+2);
            break;
       default:
            q = 1;
            break;
       }//While(!q)
   }
   return (GOOD);
}*/
/* eof <Judy 7/9/97> */
/* <Judy 7/9/97> */
RETCODE SetTypeClass(LPSTR name) {
   return(GOOD);
}
RETCODE SetTypeClassInher(LPSTR name, LPSTR parentName) {
   return(GOOD);
}
/* eof <Judy 7/9/97> */
/********************************** E O F ***********************************/
