/****************************************************************************
**
**  Name:  SDEBUG.C
**
**  Description:
**      Routines for logging output of SDS calls (during development).
**      Should *not* be linked for final version.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arcppc/lelf/sdebug.c_v  $
** 
**    Rev 1.1   31 Mar 1998 11:58:08   Winky
** No change.
** 
**    Rev 1.0   03 Mar 1997 14:26:28   hera
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 10:32:30   gene
** Initial revision.
** 
**    Rev 1.1   08 Mar 1993 11:09:14   nghia
** Cleanup and revised to use the new information.
** 
**    Rev 1.0   12 Dec 1991 13:43:36   courtney
** Initial revision.
**
**  $Header:   S:/tbird/arcppc/lelf/sdebug.c_v   1.1   31 Mar 1998 11:58:08   Winky  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#if SDS_DEBUG
static hSdsfile;
static char sdbuffer[1024];

/******************************************************************************
**
**  SdsSetup
**
******************************************************************************/
VOID SdsSetup(VOID)
{
	OFSTRUCT of;

	hSdsfile = OpenFile("sds.dbg", &of, OF_CREATE);
	_lwrite(hSdsfile, "************** SDS output follows *****************\n\n", 53);
}  /* SdsSetup */

/******************************************************************************
**
**  SdsLog
**
******************************************************************************/
/* Notes: _lwrite will not handle more than U16 bytes (65535) */
VOID SdsLog(U16 sindex, U32 baseaddr, LPSTR buffer, U32 nbytes)
/* sindex - section index
   baseaddr - current base address to write data
		(implied offset from original base for section)
   buffer - bytes to write
   nbytes - number of bytes
*/
{
	LOOP_VAR i;
	char cbyte[10];

	wsprintf(sdbuffer, "Section Index:  %d,  Current Base Address:  0x%lx\n", 
		sindex, baseaddr);
	_lwrite(hSdsfile, sdbuffer, lstrlen((LPSTR)sdbuffer));
	wsprintf(sdbuffer, "Constant bytes follow:\n");
	_lwrite(hSdsfile, sdbuffer, lstrlen((LPSTR)sdbuffer));

	if (nbytes > UINT_MAX)
		wsprintf(sdbuffer, "Warning!! Attempt to write %ld bytes, can only write %d at most\n",
			nbytes, UINT_MAX);
	for (i=0; i<nbytes; i++) {
		sprintf(cbyte, "%02x ", buffer[i]);
		_lwrite(hSdsfile, cbyte, strlen(cbyte));
	}

	wsprintf(sdbuffer, "\nNbytes:  %d\n\n", nbytes);
	_lwrite(hSdsfile, sdbuffer, lstrlen((LPSTR)sdbuffer));
}  /* SdsLog */

/******************************************************************************
**
**  SdsTerminate
**
******************************************************************************/
VOID SdsTerminate(VOID)
{
	_lclose(hSdsfile);
}  /* SdsTerminate */

#endif
