/****************************************************************************
**
**  Name:  ERR.C
**
**  Description:
**      Error message strings for SRECORD loader.  Entries correspond
**      to error #defines in err.h.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arcppc/loader/srec/err.c_v  $
** 
**    Rev 1.0   13 Jan 1998 14:00:30   hera
** Initial revision.
** 
**    Rev 1.0   13 Jan 1998 13:30:50   hera
** Initial revision.
** 
**    Rev 1.0   30 Sep 1997 16:03:26   gene
** Initial revision.
** 
**    Rev 1.8   30 Aug 1993 14:20:36   ron
** removed unused code.
** 
**    Rev 1.7   30 Aug 1993 11:13:08   ron
** Changes for Load Progress dialog
** 
**    Rev 1.6   28 Jun 1993 10:54:36   ron
** changing MessageBox to ErrMessageBox and adding a Help Button/Help Entry
** 
**    Rev 1.5   04 Jun 1993 09:56:14   nghia
** Revised to use the new error code.
** Reported error using only the Warning() and WarningEx() routines.
** PIP for Source.
** 
**    Rev 1.4   12 Feb 1993 17:57:06   nghia
** Updated for release.
** 
**    Rev 1.3   04 Nov 1992 17:39:40   courtney
** Use global RunMode, not runMode.
** 
**    Rev 1.2   22 Oct 1992 16:07:40   courtney
** Revised error reporting functions to go thru Error Text server,
** and handle retcodes instead of PRIVATE strings.
** 
**    Rev 1.1   25 Sep 1992 05:40:16   courtney
** Update routines, add Query and InfoMsg routines.
** 
**    Rev 1.0   31 Dec 1991 09:36:40   courtney
** Initial revision.
** 
**  $Header:   S:/tbird/arcppc/loader/srec/err.c_v   1.0   13 Jan 1998 14:00:30   hera  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _CLISRV_
#include "clisrv.h"
#endif

#ifndef _SYMBLSVR_
#include "symblsvr.h"
#endif

#ifndef __SLDR__
#include "sldr.h"
#endif

#ifndef __VERSION__
#include "version.h"
#endif

#ifndef __ERR__
#include "err.h"
#endif

#ifndef _HLPENTRY_
#include "hlpentry.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
/* Note that indiscriminate use of 'char *' type parameters will have
   different effects depending on the memory model used to build this.
   I am assuming Compact model (char * becomes LPSTR).
*/

extern HANDLE cliServerHandle;
extern HANDLE dllServerHandle;
extern BOOL runMode;  /* batch vs. interactive */
extern U16 reportOn;
extern U16 reportWarning;

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/
STATIC CHAR infoString[255] = "";  /* status information */

enum INFOMSG infotype;

CHAR *infomsg[] = {
   "Load complete.",
   "bytes code loaded.",
   "module(s) loaded."
};

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/
/******************************************************************************
**
**  Warning
**
******************************************************************************/
VOID Warning(RETCODE ret) {

   /* Report ret if ret is a warning and reportWarning flag is TRUE */
   if (!reportWarning && ((ret & E_SEVERITY_MASK) == E_WARNING))
      return;
   /* lets let errtext server determine run mode and report appropriately */
   ErrDisplayError(ret, CHECK_MODE);
}  /* Warning */

/******************************************************************************
**
**  Query
**
******************************************************************************/
U16 Query(RETCODE ret) {
   S16 status;

   ErrDisplayErrorEx(ret, CHECK_MODE, MB_OKCANCEL | MB_ICONQUESTION,
       (S16 FAR *)&status);

   if (status == IDOK)
      return (QOK);
   else if (status == IDCANCEL)
      return (QCANCEL);

   /* default action is to abort the load process */
   return (QCANCEL);
}  /* Query */

/******************************************************************************
**
** InfoMsg
**
******************************************************************************/
VOID InfoMsg(CHAR *s, U16 mode) {
   /* where mode is IM_COLLECT, IM_DISPLAY */
   /* first, check if status option is on */
   if (!reportOn)
      return;
   if (runMode == BATCH)
      SendMessageToCLI(s);
}  /* InfoMsg */

/******************************************************************************
**
**  SendMessageToCLI
**
******************************************************************************/
S16 SendMessageToCLI(CHAR *s) {
   GLOBALHANDLE hmsgBuf;
   CSERVER_RESULTS FAR *lpmsgBuf;
   U16 msgLength;
   U32 err;
   LOOP_VAR i;

   /*
   ** Send (not Post, we don't want them to get queued) text message to CLI.
   ** Used when running in BATCH mode.
   */
   msgLength = lstrlen(s);
   /* note that global allocation is required */
   /* also, we need to allocate for string buffer here */
   if ((hmsgBuf = GlobalAlloc(GHND, sizeof(CSERVER_RESULTS)+msgLength+1))
         == NULL) {
      /* return proper err code */
      return (-1);
   }
   lpmsgBuf = (CSERVER_RESULTS FAR *)GlobalLock(hmsgBuf);
   lpmsgBuf->target = 0;  /* !!! CLI: not yet def'ed */
   lpmsgBuf->variantCode = CLI_SERVER_RESULTS;  /* !!! CLI: not yet def'ed */
   lpmsgBuf->resultTextLength = msgLength;
   /* we've already allocated for buffer */
   for (i=0; i<msgLength; i++)
      lpmsgBuf->messageText[i] = *s++;
   lpmsgBuf->messageText[i] = '\0'; /* NULL terminate string */
   /* Send resultant message to CLI */
   err = SendMessage(cliServerHandle, CLI_SERVER_RESULTS, hmsgBuf,
	   (DWORD)CLI_SERVER_RESULTS);
   return (err);
}  /* SendMessageToCLI */

/******************************************************************************
**
**  InitInfostring
**
******************************************************************************/
VOID InitInfostring(VOID) {
   /* In case the previous load exited with a partially constructed info
   ** buffer (as with user-abort), we need to clear for each load
   */
   infoString[0] = '\0';
}  /* InitInfostring */

/******************************************************************************
**
**  WarningEx
**
******************************************************************************/
VOID WarningEx(RETCODE ret, LPSTR infoStr) {
   /* Report ret if ret is a warning and reportWarning flag is TRUE */
   if (!reportWarning && ((ret & E_SEVERITY_MASK) == E_WARNING))
      return;
   ErrDisplayString(ret,(LPSTR) infoStr, CHECK_MODE);
}  /* WarningEx */

/*********************************** E O F ***********************************/
