/****************************************************************************
**
**  Name:  SLRECORD.C
**
**  Description:
**      Routines to process records from Srecord input file.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arcppc/loader/srec/slrecord.c_v  $
** 
**    Rev 1.0   13 Jan 1998 14:00:38   hera
** Initial revision.
** 
**    Rev 1.0   13 Jan 1998 13:30:58   hera
** Initial revision.
** 
**    Rev 1.0   30 Sep 1997 16:03:28   gene
** Initial revision.
** 
**    Rev 1.5   13 Jul 1993 09:41:44   ernie
** 1. Changed hex conversion arrays to be statically initialized.
** 2. Removed unused and obsolete functions.
** 
**    Rev 1.4   04 Jun 1993 10:26:58   nghia
** Revised to meet coding standard.
** Report error uisng only the Warning() and WarningEx() routines.
** PIP for Source.
** 
**    Rev 1.3   12 Feb 1993 18:21:16   nghia
** Implement table to translate Ascii Hex to Bin.
** Cleanup and Updated for release.
** 
**    Rev 1.2   25 Sep 1992 21:06:56   courtney
** Added symbol support and module parse routine.
** 
**    Rev 1.1   25 Sep 1992 05:43:42   courtney
** Revise NextPair, NextAddr to update buffer pointer as
** return value.
** 
**    Rev 1.0   31 Dec 1991 09:33:38   courtney
** Initial revision.
** 
**  $Header:   S:/tbird/arcppc/loader/srec/slrecord.c_v   1.0   13 Jan 1998 14:00:38   hera  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef __SLDR__
#include "sldr.h"
#endif

#include <ctype.h>
#include <io.h>

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
/* Since Srecord is an ASCII format, we can pull in line at a time
   and identify.
*/

/* PRIVATE data */
PRIVATE U8 pushrec[MAX_BUF] = "";


// File Buffers
U8 fileBuff[MAX_FILEBUFF];
U8 *nextByteInBuff;
S16 numBytesInBuff;

U8 mChar[256] = {
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,0x10,0x20,0x30,0x40,0x50,0x60,0x70,0x80,0x90,   0,   0,   0,   0,   0,   0,
 0,0xA0,0xB0,0xC0,0xD0,0xE0,0xF0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0};

U8 lChar[256] = {
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,   0,   0,   0,   0,   0,   0,
 0,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0};

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/* Get a line from the input file, return identification.
   Return type of record for success, -1 for error.
*/
/******************************************************************************
**
**  GetCodeSrec
**
******************************************************************************/
S16 GetCodeSrec(S16 fHandle, U8 *sRecordBuf) {
   U16 sRecBufSize;
   U8 *sRecBufPtr = sRecordBuf;

   // If there's a pushback record, we return it, else read new record from file
   if (IS_PUSHBACK(pushrec)) {
      lstrcpy((LPSTR)sRecordBuf, (LPSTR)pushrec);
      CLR_PUSHBACK(pushrec);
      goto getRecord;
   }
   /* Get 4K of data into fileBuff */
   while (1) {
      if (!numBytesInBuff) {
         if ((numBytesInBuff = _read(fHandle, fileBuff, MAX_FILEBUFF)) > 0)
            nextByteInBuff = fileBuff; // Reset pointer to top of buffer
         else
            return(S_UNKNOWN);
      }
      // Parse the fileBuff into srec
      sRecBufSize = 0;

      while ((numBytesInBuff-- > 0) && (sRecBufSize < MAX_BUF)) {
         ++sRecBufSize;
         // Get the Record until it end
         switch(*nextByteInBuff) {
            case '\r' :
               nextByteInBuff++;  // Skip carriage return
               break;
            case '\n' :
               *sRecBufPtr++ = *nextByteInBuff++;
               *sRecBufPtr = '\0'; // Insert NULL to terminate string.
               goto getRecord;
            default:
               *sRecBufPtr++ = *nextByteInBuff++;
               break;
         }
      }
      if (sRecBufSize >= MAX_BUF)
         return(S_UNKNOWN);  // Error in processing buffer
   }

getRecord:

   // Get Type of record
   switch (sRecordBuf[0]) {
      case RP_STYPE:   return (S_RECORD); // 'S'
      case RP_MODULE:  return (S_MODULE); // '$'
      case RP_SYMBOL:  return (S_SYMBOL); // ' '
   }
   return (S_UNKNOWN);
}  /* GetCodeSrec */

/******************************************************************************
**
**  GetSrec
**
******************************************************************************/
S16 GetSrec(FILE *sfp, U8 *srecord) {
   /* if there's a pushback record, we return it,
      else read new record from file */
   if (IS_PUSHBACK(pushrec)) {
      lstrcpy((LPSTR)srecord, (LPSTR)pushrec);
      CLR_PUSHBACK(pushrec);
   }
   else {
      if (fgets((S8 *)srecord, MAX_BUF, sfp) == NULL)
        return (S_UNKNOWN);
   }
   // Get Type of record
   switch (srecord[0]) {
      case RP_STYPE:   return (S_RECORD); // 'S'
      case RP_MODULE:  return (S_MODULE); // '$'
      case RP_SYMBOL:  return (S_SYMBOL); // ' '
   }
   return (S_UNKNOWN);
}  /* GetSrec */

/******************************************************************************
**
**  PushSrec
**
******************************************************************************/
VOID PushSrec(U8 *srecord) {
    lstrcpy((LPSTR)pushrec, (LPSTR)srecord);
}  /* PushSrec */

/******************************************************************************
**
**  NextAddr
**
******************************************************************************/
U8* NextAddr(U8 *sp, U16 nbytes, U32 *plvalue) {
   /* sp - pointer to current location in srecord buffer
      nbytes - number of bytes to fetch (2, 3, or 4)
   */
   U8 sbuf[5];
   U8 FAR *pvalue;
   U16 length = nbytes;
   LOOP_VAR i;
   U32 lvalue = 0L;

   /*
   ** get next nbyte ascii load address from srecord buffer
   */
   /* need check for end-buffer, return error */
   /* Optimized: _CopyHex(sbuf, sp, nbytes); */
   pvalue = sbuf;
   while(length--) {
      *pvalue++ = (mChar[*sp] | lChar[*(sp + 1)]);
      sp += 2;
   }
   /*
   ** Convert from buffer of hex bytes to 68K format int/long
   ** We are assuming the bytes are in the correct order.
   */
   pvalue = &sbuf[0];
   for (i=0; i < nbytes; i++) {
      lvalue = lvalue << 8;
      lvalue |= *pvalue++;
   }
   *plvalue = lvalue;
   // sp += nbytes*2; // don't increment

   return (sp);
}  /* NextAddr */

/******************************************************************************
**
**  GetModule
**
******************************************************************************/
S8* GetModule(S8 *sptr, S8 *modname) {
   /* look for first alpha - this begins module name */
   while (!isalpha(*sptr))
      ++sptr;
   strcpy(modname, sptr);

   return (sptr);
}  /* GetModule */

/********************************** E O F ***********************************/
