/****************************************************************************
**
**  Name:  SLRECORD.H
**
**  Description:
**      Srecord specific values
**
**	these indicate acutal byte values:
**		prefix values RP_*		indicate type of entity that follows in file
**		record types RT_*		record type values
**		section id SECID_*		section modifiers
**
**	these indicate #define lists:
**		ST_*					section type records
**		SR_*					section records
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arcppc/loader/srec/slrecord.h_v  $
** 
**    Rev 1.0   13 Jan 1998 14:00:34   hera
** Initial revision.
** 
**    Rev 1.0   13 Jan 1998 13:30:54   hera
** Initial revision.
** 
**    Rev 1.0   30 Sep 1997 16:03:32   gene
** Initial revision.
** 
**    Rev 1.2   04 Jun 1993 10:28:34   nghia
** Revised to meet coding standard.
** PIP for Source.
** 
**    Rev 1.1   12 Feb 1993 18:22:46   nghia
** Added S_UNKNOWN for readability.
** Updated for release.
** 
**    Rev 1.0   31 Dec 1991 09:36:24   courtney
** Initial revision.
** 
**  $Header:   S:/tbird/arcppc/loader/srec/slrecord.h_v   1.0   13 Jan 1998 14:00:34   hera  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/


/* general limits */
#define IEEE_IDNLEN  127	// name length for normal string */
#define MAX_BUF      1024  // stream buffer from srecord */
#define MAX_FILEBUFF 4096  // Buffer for File I/O

/* record prefix values */
#define RP_STYPE    'S'     /* Srecord */
#define RP_MODULE   '$'     /* module */
#define RP_SYMBOL   ' '     /* symbol */

/* record types */
#define S_RECORD  1    /* all other srecords (till we figure them out) */
#define S_MODULE  2    /* module record */
#define S_SYMBOL  3    /* symbol record */
#define S_UNKNOWN 4

/* Srecord types */
#define ST_HDR      '0' /* header */
#define ST_DATA1    '1' /* 2-byte address data/code */
#define ST_DATA2    '2' /* 3-byte address code and data records */
#define ST_DATA3    '3' /* 4-byte address data/code */
#define ST_BLOCK    '5' /* block */
#define ST_TERM3    '7' /* termination for S3 type records */
#define ST_TERM2    '8' /* termination for S2 type records (also EOF) */
#define ST_TERM1    '9' /* termination for S1 type records */

/* macros to support srecords */
#define IS_PUSHBACK(srec)   (srec[0] != '\0')
#define CLR_PUSHBACK(srec)  (srec[0] = '\0')

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
/******************************** E O F *************************************/
