/****************************************************************************
**
**  Name:  types.h
**
**  Description:
**     Definitions of BASIC TYPES.  This is used by the symbol manager to 
**     initialize the basic types for a processor.
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _TYPES_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define BASIC_TYPE_COUNT 70
/* This initializes the names for the basic variable types.  */

PRIVATE S8 *basicTypeName[] = {
   "Unknown Type", //1 
   "char", "signed char", "unsigned char", "short", "signed short",
   "unsigned short", "int","signed int","unsigned int","long",
   "signed long", "unsigned long","void*","float","double",
   "long double","complex", "double complex","\0","void",
   "boolean", "long complex","label", //23

   "char*","signed char*","unsigned char*","short*", "signed short*",
   "unsigned short*","int*","signed int*","unsigned int*", "long*",
   "signed long*", "unsigned long*","**","float*","double*",
   "long double*","complex*","double complex*","\0","void*",
   "boolean*","long complex*","lable*", //23 pointer to(1)

   "char&","signed char&","unsigned char&","short&","signed short&",
   "unsigned short&","int&","signed int&","unsigned int&","long&",
   "signed long&","unsigned long&","*&","float&","double&",
   "long double&","complex&","double complex&","\0","void&",
   "boolean&","long complex&","lable&", //23 reference to(2)
};

/* this initializes the size in bytes of the basic variable types. */

static U8 basicTypeSize[BASIC_TYPE_COUNT] = {
   0,
   1, 1, 1, 2, 2,
   2, 4, 4, 4, 4,
   4, 4, 4, 4, 8,
   8, 0, 0, 0, 0,
   1, 0, 0,

   4, 4, 4, 4, 4,
   4, 4, 4, 4, 4,
   4, 4, 4, 4, 4,
   4, 4, 4, 0, 4,
   4, 4, 4,

   4, 4, 4, 4, 4,
   4, 4, 4, 4, 4,
   4, 4, 4, 4, 4,
   4, 4, 4, 0, 4,
   4, 4, 4
};

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/******************************** E O F ***********************************/
