/****************************************************************************
**
**  Name:  VARIEEE.H
**
**  Description:  Bitmasks, definitions, to support formatting of IEEE
**    floating point types.
**
**
**  Status:  PRELIMINARY 
**
**  $Log:   S:/tbird/arcppc/varsrv/varieee.h_v  $
** 
**    Rev 1.1   31 Mar 1998 12:02:12   Winky
** No change.
** 
**    Rev 1.0   17 Jan 1997 09:29:40   kevin
** Initial revision.
** 
**    Rev 1.0   03 Jun 1996 11:44:14   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 11:24:58   gene
** Initial revision.
** 
**    Rev 1.4   23 Mar 1993 13:44:52   courtney
** Corrected prototype of LongDouble68To86 (U8 *).
** 
**    Rev 1.3   23 Mar 1993 13:16:52   doug
** enable prototype for long double
** 
**    Rev 1.2   16 Mar 1993 14:55:24   courtney
** Added masks for long double display.
** 
**    Rev 1.1   08 Mar 1993 16:43:22   courtney
** Modified max number of characters allowed for entry of floating
** point values, from a ridiculously large number based on number of
** bits, to a more reasonable sized based on 'nibbles' entered.
** 
**    Rev 1.0   26 Feb 1993 16:24:34   courtney
** Initial revision.
** 
**  $Header:   S:/tbird/arcppc/varsrv/varieee.h_v   1.1   31 Mar 1998 12:02:12   Winky  $
**
**  Copyright (C) 1993 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include <float.h>

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define _VARIEEE_

/* Bitmasks for extracting floating point number in IEEE format */
#define FP_SIGN_MASK        0x80000000UL
#define FP_EXPONENT_MASK    0x7F800000UL
#define FP_MANTISSA_MASK    0x007FFFFFUL
#define FP_EXP_BIAS         0x007F
#define FP_LOWBYTE          0x000000FFUL

/* Bitmasks for extracting double in IEEE format (64-bit) */
#define D_SIGN_MASK         0x80
#define D_EXP1_MASK         0x7F
#define D_EXP2_MASK         0xF0
#define D_MANT1_MASK        0x0F
#define D_EXP_BIAS          0x000003FFUL
#define D_NULL_MASK         0x00

/* Bitmasks for extracting long double in IEEE format (96-bit) */
#define LD_SIGN_MASK        0x80
#define LD_EXP1_MASK        0x7F
#define LD_EXP2_MASK        0xFE
#define LD_MANT1_MASK       0x01
#define LD_EXP_BIAS         0x00003FFFUL
#define LD_NULL_MASK        D_NULL_MASK

/* Bitmasks for extracting long long double in IEEE format (128-bit) */
/* !! not yet implemented */

/* Bitmasks for extracting fast float (Motorola) (32-bit) */
/* !! not yet implmented */

/* Definitions for display format width */
#define F_EXP_DIG          4  /* exponent digits with sign */
#define F_DISPLAY          4  /* display characters: '.', 'E', trail 'F', null */
/* note: for IEEE floats, format precision is:
   6       +   4       +  4  = 14
*/
#define F_DISPLAY_DIG \
   FLT_DIG + F_EXP_DIG + F_DISPLAY

#define D_EXP_DIG          5  /* exponent digits with sign */
#define D_DISPLAY          4  /* display characters: '.', 'E', trail 'D', null */
/* note: for IEEE doubles, format precision is:
   15      +   5       +  4  = 24
*/
#define D_DISPLAY_DIG \
   DBL_DIG + D_EXP_DIG + D_DISPLAY


                        /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/**************************************************************************
**
** Float68To86
**
** Description: Convert buffer containing 32-bit float (in 68xxx byte order)
**    into value for display (in 8086 byte order)
**
** Parameters:
**    input:
**       U32 x: buffer containing 68xxx float data
**    output:
**       float *fpValue: float value returned (in 8086 byte order)
**
** Returns:
**    GOOD
**
***************************************************************************/
RETCODE Float68To86(U32 x, float *fpValue);

/**************************************************************************
**
** Double68To86
**
** Description: Convert buffer containing 64-bit double (in 68xxx byte
**    order) into value for display (in 8086 byte order)
**
** Parameters:
**    input:
**       U8 *x: input buffer (68xxx byte order)
**    output:
**       double *dValue: double value in 8086 byte order
**
** Returns:
**    GOOD
**
***************************************************************************/
RETCODE Double68To86(U8 *x, double *dValue);
RETCODE LongDouble68To86(U8 *x, long double *ldValue);

/******************************** E O F ***********************************/
