/* DLGHISTO.CLS                                [Ron -- 6/17/93] 
 *
 * Dialog Box to set Shell History Size
 * 
 * REQUIRES: globals.h, dialogid.h
 */!!

inherit(Dialog, #DlgHistory, #(editText /* editText object */
), 2, nil)!!

now(class(DlgHistory))!!

/* PUBLIC
 * Create a new DlgHistory object
 */
Def open(self | theDlg)
{
   theDlg := new(self);
   ^theDlg;
}
!!

now(DlgHistory)!!
!!

/* PUBLIC
 * Return the text defined in self.
 */
Def getText(self)
{
   ^editText;
}
!!

Def setUp(self, eText)
{
   editText := eText;    /* initial text in edit control */
}
!!

/* 
 * Dialog box command processing.
 */
Def command(self, wp, lp)
{ 
   select
      case wp = IDCANCEL
         ^end(self, 0);
      endCase
     
      case wp = IDOK
         editText := getItemText(self, DLG_SHELL_HISTORY_SIZE); 
         ^end(self, IDOK);
      endCase

      /* Display Help for the DlgHistory */  
      case wp = IDHELP
         is contextNumber(TheHelpObject, hWnd, HE_DLGD_HISTORY_SIZE);
      endCase        
    
   endSelect;
   ^GOOD;
}
!!

/* PUBLIC
 * By returning a 1 from the INITDIALOG message, we
 * are telling MS-Windows to set the input focus to
 * first tabstop item. (Which is exactly what we want). 
 */
Def initDialog(self, wP, lP | tmp)
{
   registerF1Help(CLIULibraryClass$Inst, HI_MESSAGEBOXEX,
     getHWnd(self), HE_DLGD_HISTORY_SIZE);
   setItemText(self, DLG_SHELL_HISTORY_SIZE, editText);
   ^1; 
} 
!!
