/* CLASS: InputNumDialog
   Provide a generic input number dialog box.

   REQUIRE: DIALOGDE.CLS
 */!!

inherit(Dialog, #InputNumDialog, #(dlgTitle
dlgPrompt
inputVal  /* Input Value */
helpEntry  /* Help Entry point */
), 2, nil)!!

now(class(InputNumDialog))!!

/* 7/22/1992 21:34 - PUBLIC 
  Create an InputNumDialog object.
*/
Def new(self, title, prompt, txt, hlpEntry | theDlg)
{ 
  theDlg := new(self:Behavior);
  init(theDlg, title, prompt, txt, hlpEntry);
  ^theDlg;
}
!!

now(InputNumDialog)!!

/* 7/22/1992 22:01 - PUBLIC
  Return the text input in dialog edit field.  
*/
Def inputVal(self)
{ 
  ^leftJustify(inputVal);
}
!!

/* 7/22/1992 22:01 - Actor
  Handle dialog events. 
  Modified 6/22/93 to handle Help button -- Ron.
*/
Def command(self, wp, lp)
{ select
    case wp == IDOK
    is inputVal := getItemText(self, 502);
      end(self, IDOK);
    endCase
    case wp == IDHELP
    is contextNumber(TheHelpObject, hWnd, helpEntry);
    endCase
    case wp == IDCANCEL
    is end(self, IDCANCEL);
    endCase
  endSelect;
  ^0;
}!!

/* 7/22/1992 21:58 - Actor
  initialize dialog edit item.
*/
Def initDialog(self, wp, lp)
{ 
  registerF1Help(CLIULibraryClass$Inst, HI_INPUT_DLG_WITH_HELP,
     getHWnd(self), helpEntry);
  setText(self, dlgTitle);
  setItemText(self, 501, dlgPrompt);
  setItemText(self, 502, inputVal);
  ^1;
}
!!

/* 
 * Initialize and set dialog items value.
 *
 * Modified 6/22/93 to use a resource dialog, so we can have a Help
 * button.  If we use this with widely varying sizes of titles/prompts,
 * we should change this to use MessageBoxEx in the error text server
 * rather than use a resource Dialog.  As it is currently used, that is
 * probably not necessary. -- Ron
 *
 */!!

Def init(self, title, prompt, inVal, hlpEntry )
{ 
  init(self:ancestor);
  dlgTitle  := title;
  dlgPrompt := prompt;
  helpEntry := hlpEntry;
  if not(inVal) then
    inputVal := "0"; /* set to zero if not supplying the initial value */
  else  
    inputVal := inVal;
  endif;  
}
!!
