/* class comment Peripheral class library*/!! 

inherit(ProvidedLibs, #UpmLib, nil, 2, nil)!!

now(class(UpmLib))!!

/* 6/22/1993 10:07 */
Def provide(self, path)
{ 
  ^initialize(new(self:ancestor),path);
}
!!

now(UpmLib)!!

/* 7/5/1993 14:57 */
Def existsUpmWindow(self | hWndPtr)
{
    hWndPtr := new( Struct, 4 );
    if pcallLock(self)
    then
      lastError := pcall( procs[#UPMEXISTSWINDOW], hWndPtr);
      pcallUNLock(self);
    else 
      lastError := ERR_PCALL_RECURSION ;
    endif ;
    if  (lastError <> GOOD) then
      displayError(ErrorTextLibClass$Inst,lastError, CHECK_MODE);    
      ^nil;
    endif ;
    if (longAt(hWndPtr, 0) <> 0)
       ^longAt(hWndPtr, 0);
    endif;
    ^nil;

}
!!

/* 7/2/1993 15:05 */
Def closeUpmWindow(self)
{
    if pcallLock(self)
    then
      lastError := pcall( procs[#UPMCLOSEWINDOW]);
      pcallUNLock(self);
    else 
      lastError := ERR_PCALL_RECURSION ;
    endif ;
    if  (lastError <> GOOD) then
      displayError(ErrorTextLibClass$Inst,lastError, CHECK_MODE);    
      ^nil;
    endif ;
    TheUpmPresenter := nil;
    ^TheUpmPresenter;

}
!!

/* 7/2/1993 11:40 */
Def openUpmWindow(self, rect, style |hWndPtr)
{ 
    hWndPtr := new( Struct, 4 );
    if pcallLock(self)
    then
      if (rect <> nil)
         lastError := pcall( procs[#UPMOPENWINDOW], 0, left(rect),
              top(rect), width(rect), height(rect), style, 0, hWndPtr);
      else
         lastError := pcall( procs[#UPMOPENWINDOW], 0, 0,
              0, 0, 0, style, 0, hWndPtr);
      endif;
      pcallUNLock(self);
    else 
      lastError := ERR_PCALL_RECURSION ;
    endif ;
    if  (lastError <> GOOD) then
      displayError(ErrorTextLibClass$Inst,lastError, CHECK_MODE);    
    endif;
    /* 04/18/94 - Nghia - only return nil no handle or critical error */
    if ((lastError = ER_PP_WIN_CREATE_FAIL) cor
        (longAt(hWndPtr, 0) = 0)) then
      ^nil;
    endif;
    ^longAt(hWndPtr, 0);

}
!!

/* 6/22/1993 10:04 
   PRIVATE 
   Open and initialize peripheral library 
*/
Def initialize(self, path)
{ 
   setName( self, path ) ;
   addImportProcs( self ) ;
   load( self ) ;
   ^self ;
}
!!

/* 6/22/1993 9:47 
   PRIVATE
   Define all entry points for library as prototypes.
*/
Def addImportProcs(self)
{
  add(self, #INITCSERVER,               1, #(0, 0));
  add(self, #UPMOPENWINDOW,            1, #(0, 0, 0, 0, 0, 1, 1, 1));
  add(self, #UPMCLOSEWINDOW,           1, nil);
  add(self, #UPMEXISTSWINDOW,          1, #(1));
  /*
  add(self, #PCLIOPEN,                  1, #(1, 1, 1)); 
  add(self, #PCLIREGISTER,              1, #(1, 1, 1)); 
  add(self, #PCLIREGWATCH,              1, #(1, 1, 1));
  add(self, #PCLIREGDELETE,             1, #(1, 1, 1));
  */
}
!!
