/* CLI Call Node:  call a remote server.
   CLI:  call callee argList;
   Actor:  processCliCommand(CLIServer, CLIPresenter, callee+argList); */!!

inherit(Object, #CLICallNode, #(callee
argList), 2, nil)!!

now(class(CLICallNode))!!

now(CLICallNode)!!

/* Compile the node into Actor source. */
Def CLICodeCompile(self | tupleEntry)
{
  postfix := 0;
  CLICodeCompile("setCliStatusValue(self, ");
  CLICodeCompile("displayErrorText(self, serverCall(self, "+
    doubleQuoteString(CLIUtilities));
  CLICodeCompile(callee);
  CLICodeCompile(doubleQuoteString(CLIUtilities)+", ");
  /* this is risky code (class might change); is there a better way? @@@ */
  if name(class(argList)) = asSymbol("CLIEmptyList")
  then
    CLICodeCompile("nil");
  else
    tupleEntry := argTupleOpenTuple(getExecutionEngine(CLIExecEngine));
    if not(tupleEntry)
      displayFormattedError(ErrorTextLibClass$Inst, 
        ER_CLI_INTERNAL, FORCE_POPUP, "tuple entry nil", 
        "CLICallNode:CLICodeCompile", nil);
    endif;
    CLICodeCompile(asUnsignedStringRadix(asLong(tupleEntry), 10));
    /* the next line causes each argument to be added to the argTuple, not
       to the source stream as might be expected */
    CLICodeCompile(argList);
    argTupleCloseTuple(getExecutionEngine(CLIExecEngine));  /* done adding args */
  endif;
  CLICodeCompile("))) ");
}!!

Def init(self, c, a)
{
  callee := c;
  argList := a;
}!!
