/* Multi-Bit  Register Field */!!

inherit(RegBit, #RegMultiBit, #(shiftAmount /* # bits to shift after masking */), 2, nil)!!

now(class(RegMultiBit))!!

/* PUBLIC */
Def new(self, name, parent, mask, shift, sortIndex | instance)
{
   instance := new( self:ancestor, name, mask, parent, sortIndex ) ;

   setShift( instance, shift ) ;
   
   ^instance
}
!!

/* PUBLIC */
Def newWithLocation(self, name, parent, mask, shift, sortIndex, location | instance)
{
   instance := new( self:ancestor, name, mask, parent, sortIndex ) ;

   setShift(    instance, shift    ) ;
   setLocation( instance, location ) ;
   
   ^instance
}

!!

now(RegMultiBit)!!

/* PUBLIC -- return as text for display */
Def name(self)
{
  if currVal(self)
  then
    ^(name + asStringRadix(currVal, 16))
  else
    ^(name + "?")
  endif ;
}
!!

/* PRIVATE */
Def setShift(self, aShift)
{
  shiftAmount := asLong(2 ** aShift) ; /* no shift operator => do by div */
}
!!

/* PUBLIC */
Def setValue(self, newValue)
{
  prevVal := currVal ;
  /* find bits in register value */
  if newValue
  then
    currVal := ((newValue bitAnd maskVal) / shiftAmount) ;
  else
    currVal := nil ;
  endif ;
  hilighted? := not( prevVal = currVal ) ;
}
!!