/* Dialog used by trace presenter to determine the current crystal
    used in the system. */!!

inherit(Dialog, #SystemCrystalDlg, #(frequency
units /* MHz, kHz, or Hz */), 2, nil)!!

now(class(SystemCrystalDlg))!!

Def new(self| dlg)
{
  dlg := new(self:ancestor);
  ^dlg;
}!!

now(SystemCrystalDlg)!!

/* Return string equivalent of selected units. */
Def unitsString(self)
{ 
  select
    case units = DLG_TRACESYS_MHZ  ^"MHz";    endCase
    case units = DLG_TRACESYS_KHZ  ^"kHz";    endCase
  endSelect;
  ^"Hz";  /* default */
}!!

/* Dialog box command processing. */
Def command(self, wp, lp)
{ 
  select
    case wp = DLG_TRACESYS_MHZ cor
         wp = DLG_TRACESYS_KHZ cor
         wp = DLG_TRACESYS_HZ
      units := wp;
      Call CheckRadioButton(getHWnd(self),
        DLG_TRACESYS_MHZ, DLG_TRACESYS_HZ, wp);
    endCase
    
    case wp = IDCANCEL
       ^end(self, IDCANCEL);
    endCase
     
    case wp = IDOK
      frequency := getItemText(self, START_FRAME_ID);
      ^end(self, IDOK);
    endCase

    case wp = IDHELP
      contextNumber(TheHelpObject, hWnd, HELP_ENTRY_SYSTEM_CRYSTAL);
    endCase        
    
  endSelect;
  ^GOOD;
}!!

/* Initialize the dialog text */
Def initDialog(self, wp, lp | frequencyString length unitString)
{
  /* connect help button */
  registerF1Help(CLIULibraryClass$Inst, HI_MESSAGEBOXEX,
     getHWnd(self), HELP_ENTRY_SYSTEM_CRYSTAL);
     
  /* get frequency string.  NOTE:  This code is fragile, and highly
     dependent upon the current implementation of TrcSystemCrystalGet(),
     which guarantees the last 3 digits will be the units, either
     "MHz", "kHz", or " Hz". */
  frequencyString := trcSystemCrystalGet(TraceLibClass$Inst);
  length := size(trimTrailing(frequencyString, " "));
  
  /* set the frequency string */
  setItemText(self, START_FRAME_ID, copyFrom(frequencyString, 0, length-3));
  
  /* set units button */
  unitString := copyFrom(frequencyString, length-3, length);
  select
    case unitString = "MHz" is units := DLG_TRACESYS_MHZ endCase
    case unitString = "kHz" is units := DLG_TRACESYS_KHZ endCase
    default                    units := DLG_TRACESYS_HZ
  endSelect;
 
  Call CheckDlgButton(getHWnd(self), units, 1); 
}!!

/* PUBLIC */
Def setFrequency(self, freqText)
{ 
  frequency := freqText;
}!!

/* PUBLIC */
Def getFrequency(self | val) { 
  if not(frequency) cor (size(frequency) = 0)
    frequency := trcSystemCrystalGet(TraceLibClass$Inst);
  endif;
  ^frequency+unitsString(self);
}!!

