/* interface to error text dll. */!!

inherit(ProvidedLibs, #ErrorTextLib, nil, 2, nil)!!

now(class(ErrorTextLib))!!

/* semiPRIVATE - only called via require(). */
Def provide(self,path)
{ 
  ^initialize(new(self:ancestor),path);
}
!!

now(ErrorTextLib)!!

/* define entry points */
Def addImportProcs(self)
{
  add(self, #INITCSERVER,     1, #(0, 0));
  add(self, #ERRGETERRORTEXT, 1, #(1, 1));
  add(self, #ERRDISPLAYERROR, 1, #(1, 0));
  add(self, #ERRDISPLAYFORMATTEDERROR, 1, #(1, 0, 1, 1, 1, 0, 1));
  add(self, #ERRGETFORMATTEDERRORTEXT, 1, #(1, 1, 1, 1, 1));
  add(self, #ERRMESSAGEBOX,   1, #(1, 1, 0, 1, 1));
}
!!

/* display the error text according to the display type */
/* OBSOLETE: just call displayFormattedError            */
Def displayError(self, errorNumber, displayType)
{
  ^displayFormattedError(self, errorNumber, displayType, nil, nil, nil);
}
!!

/* format and display the error text according to the display type */
Def displayFormattedError(self, errorNumber, displayType, 
                          arg1, arg2, arg3 | buttonID)
{
  buttonID := new( Struct, 2 ) ;
  /* return if there is no error */
  if errorNumber = GOOD
    ^GOOD;
  endif;
  if not(arg1) then arg1 := ""; endif;
  if not(arg2) then arg2 := ""; endif;
  if not(arg3) then arg3 := ""; endif;
  if pcallLock(self)
    lastError := pcall(procs[#ERRDISPLAYFORMATTEDERROR], errorNumber, 
       displayType, asciiz(arg1), asciiz(arg2), asciiz(arg3), 0, buttonID);
    pcallUNLock(self);
  else
    lastError := ERR_PCALL_RECURSION;
  endif;
  if (lastError <> GOOD) then
    pcall(procs[#ERRDISPLAYERROR], lastError, CHECK_MODE);
  endif;
 
  ^GOOD;
}
!!

/* retrieve the error text from the DLL */
Def getErrorText(self, errorNumber | stringRef verString memServerInstance)
{
  stringRef := new(Struct, 256);
  if pcallLock(self)
    lastError := pcall(procs[#ERRGETERRORTEXT], errorNumber, stringRef);
    pcallUNLock(self);
  else
    lastError := ERR_PCALL_RECURSION;
  endif;
  
  if (lastError = GOOD)
    ^removeNulls(physicalString(stringRef));
  else
    ^asUnsignedStringRadix(asLong(lastError), 16) +
    ": Error text retrieval for 0x" +
    asUnsignedStringRadix(asLong(errorNumber), 16) +
    " failed";
  endif;
  
}
!!

/* retrieve the formatted error text from the DLL */
Def getFormattedError(self, errorNumber, arg1, arg2, arg3 | stringRef 
   verString memServerInstance)
{
  stringRef := new(Struct, 256);
  if not(arg1) then arg1 := ""; endif;
  if not(arg2) then arg2 := ""; endif;
  if not(arg3) then arg3 := ""; endif;
  if pcallLock(self)
    lastError := pcall(procs[#ERRGETFORMATTEDERRORTEXT], errorNumber, 
       stringRef, asciiz(arg1), asciiz(arg2), asciiz(arg3));
    pcallUNLock(self);
  else
    lastError := ERR_PCALL_RECURSION;
  endif;
  
  if (lastError = GOOD)
    ^removeNulls(physicalString(stringRef));
  else
    ^asUnsignedStringRadix(asLong(lastError), 16) +
    ": Error text retrieval for 0x" +
    asUnsignedStringRadix(asLong(errorNumber), 16) +
    " failed";
  endif;
  
}
!!

/* display the error text in the CLI transcript */
Def privateDisplayErrorCLI(self, text)
{
  outputExplicit(
    presenter(getCliServerObject(CliServer)),
    text);
}
!!

/* display the error text in a popup */
Def privateDisplayErrorPopup(self, text)
{
  errorBox("MICEpack/SLD", text);
}
!!

/* 
 * Display the caption and text and use the style to set the number
 * and type of buttons.  Pass the appropriate help entry point and
 * return the id of the button that was pressed.
 */
Def errMessageBox(self, caption, text, style, helpEntry | buttonID)
{
  buttonID := new( Struct, 2 ) ;
  if not(caption) then caption := "MICEpack/SLD"; endif;
  if not(text) then text := "Unknown message!  Continue?"; endif;
  if not(helpEntry) then helpEntry := HELP_CONTENTS; endif;
  if not(style) then style := (MB_YESNO bitOr MB_ICONQUESTION); endif;
  if pcallLock(self)
    lastError := pcall(procs[#ERRMESSAGEBOX], asciiz(caption), 
       asciiz(text), style, helpEntry, buttonID);
    pcallUNLock(self);
  else
    lastError := ERR_PCALL_RECURSION;
  endif;
  if (lastError <> GOOD) then
    pcall(procs[#ERRDISPLAYERROR], lastError, CHECK_MODE);
  endif;
 
  ^wordAt(buttonID, 0);
}
!!
