/* class comment */!!

inherit(ProvidedLibs, #WatchLib, nil, 2, nil)!!

now(class(WatchLib))!!

/* 7/30/1997 16:15 */ 
Def provide(self, path)
{ 
  ^initialize(new(self:ancestor),path);
}
!!

now(WatchLib)!!

/* 7/30/1997 16:19 */ 
Def openWatchpointWindow(self, rect, style |hWndPtr)
{ 
    hWndPtr := new( Struct, 4 );
    if pcallLock(self)
    then
      if (rect <> nil)
         lastError := pcall( procs[#WHPTOPENWINDOW], 0, left(rect),
              top(rect), width(rect), height(rect), style, 0, hWndPtr);
      else
         lastError := pcall( procs[#WHPTOPENWINDOW], 0, 0,
              0, 0, 0, style, 0, hWndPtr);
      endif;
      pcallUNLock(self);
    else 
      lastError := ERR_PCALL_RECURSION ;
    endif ;
    if  (lastError <> GOOD) then
      displayError(ErrorTextLibClass$Inst,lastError, CHECK_MODE);    
    endif;
    /* 04/18/94 - Nghia - only return nil no handle or critical error */
    if ((lastError = ER_PP_WIN_CREATE_FAIL) cor
        (longAt(hWndPtr, 0) = 0)) then
      ^nil;
    endif;
    ^longAt(hWndPtr, 0);

}
    !!

/* 7/30/1997 16:19 */ 
Def initialize(self, path)
{ 
   setName( self, path ) ;
   addImportProcs( self ) ;
   load( self ) ;
   ^self ;
}
!!

/* 7/30/1997 16:18 */ 
Def existsWatchpointWindow(self | hWndPtr)
{
    hWndPtr := new( Struct, 4 );
    if pcallLock(self)
    then
      lastError := pcall( procs[#WHPTEXISTSWINDOW], hWndPtr);
      pcallUNLock(self);
    else 
      lastError := ERR_PCALL_RECURSION ;
    endif ;
    if  (lastError <> GOOD) then
      displayError(ErrorTextLibClass$Inst,lastError, CHECK_MODE);    
      ^nil;
    endif ;
    if (longAt(hWndPtr, 0) <> 0)
       ^longAt(hWndPtr, 0);
    endif;
    ^nil;

}       !!

/* 7/30/1997 16:16 */ 
Def closeWatchpointWindow(self)
{
    if pcallLock(self)
    then
      lastError := pcall( procs[#WHPTCLOSEWINDOW]);
      pcallUNLock(self);
    else 
      lastError := ERR_PCALL_RECURSION ;
    endif ;
    if  (lastError <> GOOD) then
      displayError(ErrorTextLibClass$Inst,lastError, CHECK_MODE);    
      ^nil;
    endif ;
    TheWatchpointPresenter := nil;
    ^TheWatchpointPresenter;

}    !!

/* 7/30/1997 16:16 */ 
Def addImportProcs(self)
{
  add(self, #INITCSERVER,               1, #(0, 0));
  add(self, #WHPTOPENWINDOW,            1, #(0, 0, 0, 0, 0, 1, 1, 1));
  add(self, #WHPTCLOSEWINDOW,           1, nil);
  add(self, #WHPTEXISTSWINDOW,          1, #(1));
  /*
  add(self, #PCLIOPEN,                  1, #(1, 1, 1)); 
  add(self, #PCLIREGISTER,              1, #(1, 1, 1)); 
  add(self, #PCLIREGWATCH,              1, #(1, 1, 1));
  add(self, #PCLIREGDELETE,             1, #(1, 1, 1));
  */
}!!