/* initance of Trace library */!!

inherit(TraceLib, #Trace, #(descriptor  /* my descriptor from Open... */
traceFileName), 2, nil)!!

now(class(Trace))!!

now(Trace)!!

/* PUBLIC -- gingerbread for pcall */
Def prim_trcReadFrameSet(self, frame | rc)
{ 
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCREADFRAMESET],descriptor,frame);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  ^rc;
}
!!

/* PUBLIC -- gingerbread for pcall */
Def prim_trcReadBufferSet(self, buf | rc)
{
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCREADBUFFERSET],descriptor,buf);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  ^rc;
}
!!

/* PUBLIC -- gingerbread for pcall */
Def prim_trcSearchBufferSet(self, buffer | rc)
{ 
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCSEARCHBUFFERSET],descriptor,buffer);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  ^rc;
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcTraceCycleGet(self | rc value)
{ 
  value := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCTRACECYCLEGET], descriptor, value);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^0 ;
  else
    ^wordAt(value,0);
  endif ;  
}
!!

/* PUBLIC -- gingerbread for pcall */
Def backwardRead(self, numFrames, startRef, endRef, addrRef, lenRef | rc)
{ 
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCBACKWARDREAD],descriptor, numFrames, startRef,
               endRef, addrRef, lenRef);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  ^rc;
}
!!

/* PUBLIC */
Def descriptor(self)
{ 
  ^descriptor
}
!!

/* PUBLIC -- gingerbread for pcall */
Def forwardRead(self, numFrames, startRef, endRef, addrRef, lenRef | rc)
{
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCFORWARDREAD],descriptor, numFrames, startRef,
               endRef, addrRef, lenRef);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  ^rc;
}
!!

/* PRIVATE */
Def setDescriptor(self, d)
{
  descriptor := d ;
}
!!

/* PRIVATE */
Def setFileName(self, name)
{
  traceFileName := name ;
}
!!

/* PRIVATE */
Def setProcs(self, p)
{
  procs := p ;
}
!!

/* PUBLIC
   returns the ending frame number of the currently active
   trace buffer
 */
Def traceBufferEnd(self) { 
  ^traceBufferInfo(self)[2];
}
!!

/* PUBLIC
   returns the starting frame number of the currently active
   trace buffer
 */
Def traceBufferInfo(self | start end trigger rc) { 
  start := new(Struct, 4);
  end := new(Struct, 4);
  trigger := new(Struct, 4);
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCTRACEBUFFERINFOGET],descriptor,start,end,trigger);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  /*
  printNewLine("Trace Buffer Info:  start: "+asString(longAt(start,0))+
  "; end: "+asString(longAt(end,0))+"; trigger: "+
   asString(longAt(trigger,0)));
  */
  if (rc <> 0)
    ^tuple(0,0,0);
  else
    ^tuple(longAt(start,0),longAt(trigger,0),longAt(end,0));
  endif;
}
!!

/* PUBLIC
   returns the starting frame number of the currently active
   trace buffer
 */
Def traceBufferStart(self){
  ^traceBufferInfo(self)[0];
}
!!

/* PUBLIC
   returns the trigger frame number of the currently active
   trace buffer
 */
Def traceBufferTrigger(self){ 
  ^traceBufferInfo(self)[1];
}
!!

/* PUBLIC
   returns the ending buffer number - just
   created to handle buffer dialog box in trace presenter
 */
Def trcEndTraceBuffer(self) {
  ^(prim_trcMaxValidTraceBuffer(TraceLibClass$Inst)[1]);
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcGetFrameInstAddress(self, frame, addrRef, frameInstRef | rc) {
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCGETFRAMEINSTADDRESS], descriptor, frame, addrRef,
              frameInstRef);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcGetHeader(self | rc header)
{
  header := new(String, 385);  /* header is 3 lines of 128 chars plus NULL */
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCGETHEADER], descriptor, header, 385);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^"" ;
  else
    ^ removeNulls(header);
  endif ;  
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcNumFramesGet(self | rc value)
{ 
  value := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCNUMFRAMESGET], descriptor, value);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^0 ;
  else
    ^longAt(value,0);
  endif ;  
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcReadBufferGet(self | rc value)
{
  value := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCREADBUFFERGET], descriptor, value);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^0 ;
  else
    ^wordAt(value,0);
  endif ;  
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcReadBufferSet(self, buf | rc)
{
  rc:=prim_trcReadBufferSet(self,buf);
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcReadFrameGet(self | rc value)
{
  value := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCREADFRAMEGET], descriptor, value);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^0 ;
  else
    ^longAt(value,0);
  endif ;  
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcReadFrameSet(self, frame | rc)
{ 
  if pcallLock(self)
  then
    /*
    printNewLine("TRCREADFRAMESET frame = "+asString(frame));
    */
    rc := pcall(procs[#TRCREADFRAMESET],descriptor,frame);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcSearchBufferSet(self, buffer | rc)
{ 
  rc:= prim_trcSearchBufferSet(self,buffer);
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcSearchEventSet(self, stringName | rc) 
{ 
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCSEARCHEVENTSET], descriptor, asciiz(stringName));
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;  
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcSearchFrameGet(self | rc value)
{ 
  value := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCSEARCHFRAMEGET], descriptor, value);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^0 ;
  else
    ^longAt(value,0);
  endif ;  
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcSearchFrameSet(self, frame | rc)
{
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCSEARCHFRAMESET],descriptor,frame);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}
!!

/* PUBLIC
   returns the starting buffer number which is ALWAYS zero - just
   created to handle buffer dialog box in trace presenter
 */
Def trcStartTraceBuffer(self) {
  ^0;
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcTraceClose(self | rc)
{ 
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCTRACECLOSE], descriptor);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcTraceCycleSet(self, mode | rc)
{ 
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCTRACECYCLESET],descriptor,mode);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcTraceSearch(self | rc found)
{ 
  found := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCTRACESEARCH], descriptor, found);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^0 ;
  else
    ^wordAt(found,0);
  endif ;  
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcUpdateTrace(self | rc)
{ 
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCUPDATETRACE],descriptor);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcTimestampGet(self | rc value)
{
  value := new( Struct, 2 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCTIMESTAMPGET], descriptor, value);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^0 ;
  else
    ^wordAt(value,0);
  endif ;  
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcTimestampSet(self, enable | rc)
{ 
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCTIMESTAMPSET],descriptor,enable);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcTimestampModeGet(self | rc value)
{
  value := new( Struct, 2 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCTIMESTAMPMODEGET], descriptor, value);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^0 ;
  else
    ^wordAt(value,0);
  endif ;  
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcTimestampModeSet(self, mode | rc)
{ 
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCTIMESTAMPMODESET],descriptor,mode);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcTimestampZeroFrameGet(self | rc value)
{
  value := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCTIMESTAMPZEROFRAMEGET], descriptor, value);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^0 ;
  else
    ^longAt(value,0);
  endif ;  
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcTimestampZeroFrameSet(self, frame | rc)
{ 
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCTIMESTAMPZEROFRAMESET],descriptor,frame);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}
!!
