/* class comment */
/* save the operator index; use to create operator inside a quoted string to be passed directly to the server */!!

inherit(Object, #CLICallOperatorNode, #(op  /* operator index */), 2, nil)!!

now(class(CLICallOperatorNode))!!

now(CLICallOperatorNode)!!

/* output quoted strings for each element. */
Def CLICodeCompile(self | value)
{
  value := getValue(self, op);  /* does not return unless value found */
  argTupleAddArg(getExecutionEngine(CLIExecEngine), nil, value);
}!!

/* get the string equivalent of the token. */
Def getValue(self, value | errorMessage)
{
  select
    case op = TAMPER       is value := "&";  endCase;
    case op = TBAR         is value := "|";  endCase;
    case op = TEQUALS      is value := "=";  endCase;
    case op = TEQUAL_TO    is value := "=="; endCase;
    case op = TEXCLAM      is value := "!";  endCase;
    case op = TGREATER_EQ  is value := ">="; endCase;
    case op = TLEFT_CURLY  is value := "{";  endCase;
    case op = TLEFT_PAREN  is value := "(";  endCase;
    case op = TLESS_EQ     is value := "<="; endCase;
    case op = TLOG_AND     is value := "&&"; endCase;
    case op = TLOG_OR      is value := "||"; endCase;
    case op = TLSHIFT      is value := "<<"; endCase;
    case op = TL_ANGLE     is value := "<";  endCase;
    case op = TMINUS       is value := "-";  endCase;
    case op = TNOT_EQUAL   is value := "!="; endCase;
    case op = TPERCENT     is value := "%";  endCase;
    case op = TPLUS        is value := "+";  endCase;
    case op = TRIGHT_CURLY is value := "}";  endCase;
    case op = TRIGHT_PAREN is value := ")";  endCase;
    case op = TRSHIFT      is value := ">>"; endCase;
    case op = TR_ANGLE     is value := ">";  endCase;
    case op = TSLASH       is value := "/";  endCase;
    case op = TSTAR        is value := "*";  endCase;
    case op = TTILDE       is value := "~";  endCase;
    case op = TUPARROW     is value := "^";  endCase;
    default 
      errorMessage := getFormattedError(ErrorTextLibClass$Inst, 
         ER_CLI_INTERNAL_ERROR, "CLICallOperatorNode:getValue", nil, nil);
      syntaxError(self, nil, errorMessage);
      /* syntaxError unravels call stack, and does not return */
  endSelect;
  ^value;
}!!

Def init(self, o)
{
  op := o;
}!!
