/* hold dialog item information */!!

inherit(Object, #DlgItem,
#(type,   /* type of control */
style,  /* dlgItem style */
x,      /* x-coordinate */
y,      /* y-coordinate */
id,     /* item id */
width,  /* width of item */
height, /* height of item */
text    /* item text */), 2, nil)!!

now(class(DlgItem))!!

/* Create a new autoradio button. */
Def newAutoRadio(self, txt, ret, offset, extent, sty)
{ ^newItem(self, "BUTTON", txt, ret, offset, extent,
    sty bitOr 9L /* BS_AUTORADIOBUTTON */ bitOr WS_TABSTOP);
}!!

/* Create a new button control. */
Def newButton(self, txt, ret, offset, extent, sty)
{ ^newItem(self, "BUTTON", txt, ret, offset, extent, sty bitOr WS_TABSTOP);
}!!

/* Create a new check box control. */
Def newCheckBox(self, txt, ret, offset, extent, sty)
{ ^newItem(self, "BUTTON", txt, ret, offset, extent,
    sty bitOr 2L /* BS_CHECKBOX */ bitOr WS_TABSTOP);
}!!

/* Create a new listbox control. */
Def newComboBox(self, txt, ret, offset, extent, sty)
{ ^newItem(self, "COMBOBOX", txt, ret, offset, extent,
   sty bitOr CBS_SORT);
}!!

/* Create a new default push button control. */
Def newDefButton(self, txt, ret, offset, extent, sty)
{ ^newItem(self, "BUTTON", txt, ret, offset, extent,
    sty bitOr 1L /* BS_DEFPUSHBUTTON */ bitOr WS_TABSTOP);
}!!

/* Create a new edit control. */
Def newEdit(self, txt, ret, offset, extent, sty)
{ ^newItem(self, "EDIT", txt, ret, offset, extent,
    sty bitOr WS_TABSTOP bitOr WS_BORDER);
}!!

/* Create a new group box. */
Def newGroupBox(self, txt, ret, offset, extent, sty)
{ ^newItem(self, "BUTTON", txt, ret, offset, extent,
    sty bitOr 7L /* BS_GROUPBOX */ bitOr WS_TABSTOP);
}!!

/* Create a new horizontal scrollbar control. */
Def newHorzScroll(self, txt, ret, offset, extent, sty)
{ ^newItem(self, "SCROLLBAR", txt, ret, offset, extent, sty);
}!!

/* Create a generic control. The control type, typ, is a String representing
   the window control name. */
Def newItem(self, typ, txt, ret, offset, extent, sty)
{ ^newItem(new(self:Behavior), typ, txt, ret,
    offset, extent, sty bitOr WS_VISIBLE bitOr WS_CHILD);
}!!

/* Create a new listbox control. */
Def newListBox(self, txt, ret, offset, extent, sty)
{ ^newItem(self, "LISTBOX", txt, ret, offset, extent, sty);
}!!

/* Create a new radio button. */
Def newRadioButton(self, txt, ret, offset, extent, sty)
{ ^newItem(self, "BUTTON", txt, ret, offset, extent,
    sty bitOr 4L /* BS_RADIOBUTTON */ bitOr WS_TABSTOP);
}!!

/* Create a new scrollbar (horizontal by default). */
Def newScroll(self, txt, ret, offset, extent, sty)
{ ^newItem(self, "SCROLLBAR", txt, ret, offset, extent, sty);
}!!

/* Create a new static text control. */
Def newStatic(self, txt, ret, offset, extent, sty)
{ ^newItem(self, "STATIC", txt, ret, offset, extent, sty);
}!!

/* Create a new vertical scrollbar control. */
Def newVertScroll(self, txt, ret, offset, extent, sty)
{ ^newItem(self, "SCROLLBAR", txt, ret, offset, extent,
    sty bitOr 1L /* SBS_VERT */);
}!!

now(DlgItem)!!

/* Convert the item into a dialog item string to build the resource. */
Def asItemString(self | str)
{ str := new(Struct, 14);
  str[0] := x;
  str[2] := y;
  str[4] := width;
  str[6] := height;
  str[8] := id;
  putLong(str, style, 10);
  ^str := physicalString(str) +
    asciiz(type) + asciiz(text) + asciiz("");
}!!

/* Return the y position of the bottom of the item. */
Def bottom(self)
{ ^y + height;
}!!

/* Get the value of the control based on its type.  Only
   controls that have values will be returned in the
   dictionary. */
Def getValue(self, dlg | ret)
{ if type = "EDIT"
  then ^tuple(id, getItemText(dlg, id));
  endif;
  if type = "LISTBOX" cand (ret := getLBText(dlg, id))
  then ^tuple(id, ret);
  endif;
  if type = "COMBOBOX" cand (ret := getCBText(dlg, id))
  then ^tuple(id, ret);
  endif;
  if (type = "BUTTON") cand
    ((ret := Call IsDlgButtonChecked(handle(dlg), id)) <> 0)
  then ^tuple(id, ret);
  endif;
  ^nil;
}!!

/* Return the x position of the left edge of the item. */
Def left(self)
{ ^x;
}!!

/* Create a new dialog control item with the passed parameters. */
Def newItem(self, typ, txt, ret, offset, extent, sty)
{ setType(self, typ);
  setText(self, txt);
  setID(self, ret);
  setX(self, x(offset));
  setY(self, y(offset));
  setWidth(self, x(extent));
  setHeight(self, y(extent));
  setStyle(self, sty);
}!!

/* Return the x position of the right edge of the item. */
Def right(self)
{ ^x + width;
}!!

/* Set the height instance variable. */
Def setHeight(self, aHeight)
{ ^height := aHeight;
}!!

/* Set the id instance variable. */
Def setID(self, aID)
{ ^id := aID;
}!!

/* Set the style instance variable. */
Def setStyle(self, sty)
{ ^style := sty;
}!!

/* Set the text instance variable. */
Def setText(self, txt)
{ ^text := txt;
}!!

/* Set the type instance variable. */
Def setType(self, aType)
{ ^type := aType;
}!!

/* Set the width instance variable. */
Def setWidth(self, aWidth)
{ ^width := aWidth;
}!!

/* Set the setX instance variable. */
Def setX(self, xcoord)
{ ^x := xcoord;
}!!

/* Set the setY instance variable. */
Def setY(self, ycoord)
{ ^y := ycoord;
}!!

/* Return the y position of the top of the item. */
Def top(self)
{ ^y;
}!!
