/* Stack Server Library - STKSERVR.DLL */!!

inherit(ProvidedLibs, #StackLib, nil, 2, nil)!!

now(class(StackLib))!!

/* 3/2/1992 16:26 - semiPRIVATE
  Should only called view require(StackLib) - Define entry points and load
  library. Also define structs required.
  */
Def provide(self, path)
{ 
  ^initialise( new(self:ancestor), path);
}

!!

now(StackLib)!!

/* 7/14/1993 08:30 - PUBLIC
  Terminate server.  
*/
Def terminateServer(self)
{
  if pcallLock(self) then
    lastError := pcall(procs[#TERMINATESERVER]) ;
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION ;
  endif;

  if (lastError <> GOOD) then
    ^displayError(ErrorTextLibClass$Inst,lastError,FORCE_POPUP);
  endif;
  ^GOOD;
}
 
!!

/* 3/3/1992 16:13 - PUBLIC
  Initialize the Specified stack base and size with pattern. 
*/
Def fillStackWithPattern(self, stkBaseDesc, stkSize)
{ 
  if pcallLock(self)
  then
    lastError := pcall(procs[#STKSETSTACKTOPATTERN], stkBaseDesc, stkSize);
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION ;
  endif ;

  if (lastError <> GOOD)
  then
    displayError(ErrorTextLibClass$Inst,lastError,FORCE_POPUP); 
    ^nil; 
  endif;
  ^GOOD;    
}



!!

/* 6/16/1992 14:05 - PUBLIC
  Return a function symbol descriptor in the current context, or nil. 
*/
Def getCurrentFuncFromContext(self | symRef)
{ 
  if pcallLock(self) then
    symRef := new(Struct, 4);
    lastError := pcall( procs[#STKGETCURRENTFUNCTION], symRef);
    pcallUNLock(self);
  else
    lastError := ERR_PCALL_RECURSION;
  endif;
  
  if lastError <> GOOD then
    displayError(ErrorTextLibClass$Inst, lastError, FORCE_POPUP);
    ^nil;
  endif;
  if longAt(symRef, 0) = 0 then /* NULL_SYMBOL */
    ^nil;
  endif;
  ^longAt(symRef, 0);          
}
!!

/* PUBLIC                [Ron, 5/6/93, for Variable Window Enhancements]
 *
 * Return a function symbol descriptor in the current context, or nil. 
 */
Def getCurrentLineNumFromContext(self | symRef symRef2 symRef3)
{ 
   if pcallLock(self) then
      symRef := new(Struct, 4);
      symRef2 := new(Struct, 4); /* unused column number */
      symRef3 := new(Struct, 4); /* unused line number index */
      lastError := pcall( procs[#STKGETCURRENTLINENUM], symRef, symRef2, 
         symRef3);
      pcallUNLock(self);
   else
      lastError := ERR_PCALL_RECURSION;
   endif;
  
   if lastError <> GOOD then
      displayError(ErrorTextLibClass$Inst, lastError, CHECK_MODE);
      ^nil;
   endif;
   if longAt(symRef, 0) = 0 then /* NULL_SYMBOL */
      ^nil;
   endif;
   ^longAt(symRef, 0);          
}
!!


/* 6/16/1992 14:05 - PUBLIC
  Return a module descriptor in the current execution context, or nil. 
*/
Def getCurrentModuleFromContext(self | symRef)
{ 
  if pcallLock(self) then
    symRef := new(Struct, 4);
    lastError := pcall( procs[#STKGETCURRENTMODULE], symRef);
    pcallUNLock(self);
  else
    lastError := ERR_PCALL_RECURSION;
  endif;
  
  if lastError <> GOOD then
    displayError(ErrorTextLibClass$Inst, lastError, FORCE_POPUP);
    ^nil;
  endif;
  if longAt(symRef, 0) = 0 then /* NULL_SYMBOL */
    ^nil;
  endif;
  ^longAt(symRef, 0);          
}
!!

/* 3/3/1992 8:38 - PRIVATE 
  Define C-Struct interface to the Stack Server.
*/
Def defineStructs(self)
{
  def( UserType, #STRING_TYPE,  #(char  string_value 132 ) ) ;
  def( UserType, #LONG_TYPE,    #(long  long_value 1 ) ) ;
  def( UserType, #WORD_TYPE,    #(short word_value 1 ) ) ; /* unsigned */

  /*  Definition from tbird\core\inc\stkservr.h  
  typedef struct  { 
    WORD allocIndicator; -- STK_TMALLOC or GlobalAlloc handle
    U16  numOfFames; 
    U32  textLength;
    U8   text[VARIABLE_SIZE]; - max 132 characters  
  } STK_DISPLAY_TYPE; 

  typedef STK_DISPLAY_TYPE  *STK_DISPLAY_PTR; 
  */
  
  def( UserType, #STK_DISPLAY_TYPE,
       #( short allocIndicator 1
          short numOfFrames 1
          long  textLength 1
          char  text 132   /* a line */
        )
     );
}
 
!!

/* 3/2/1992 17:10  - PUBLIC 
   Open a session with the Stack Server. 
   Return a session instance (VarLibInst) or nil.
*/
Def openSession(self, hWnd | sessionInstance)
{
  /* create a new StackLib instance */
  if not(sessionInstance := new(StkLibInst, hWnd)) 
    ^nil;
  endif;
  /* pass on library name to offspring */
  setIVars( sessionInstance, hLib, name, ordinals, procs, globalNameSymbol ) ;
  ^sessionInstance
}
!!

/* 3/2/1992 16:30  - PUBLIC */
Def addImportProcs(self)
{ 
  /* Format: DLL's export routines, retcode, (paramters) U16: 0 - U32: 1*/
  add(self, #INITCSERVER,             1, #(0, 0) );
  add(self, #TERMINATESERVER,         nil, nil );
  add(self, #STKSTARTSESSION,         1, #(0, 1) );
  add(self, #STKENDSESSION,           1, #(1) );
  add(self, #STKDISABLEALARMLIMIT,    1, #(1) );
  add(self, #STKDISABLEHIGHWATERMARK, 1, #(1) );
  add(self, #STKENABLEALARMLIMIT,     1, #(1) );
  add(self, #STKENABLEHIGHWATERMARK,  1, #(1) );
  add(self, #STKGETALARMLIMIT,        1, #(1, 1, 1, 1, 1) );
  add(self, #STKGETALARMSTATE,        1, #(1, 1) );
  add(self, #STKGETCURRENTMODULE,     1, #(1) );
  add(self, #STKGETHIGHWATERMARK,     1, #(1, 1, 1) );
  add(self, #STKANYFRAMES,            1, #(1, 1) );
  add(self, #STKGETFRAMESYMBOL,       1, #(1, 0, 1, 1, 1) );
  add(self, #STKGETSTACKBASE,         1, #(1, 1, 1) );
  add(self, #STKGETSTACKSIZE,         1, #(1, 1) );
  add(self, #STKGETSTACKDIRECTION,    1, #(1, 1) );
  add(self, #STKOPENSTACK,            1, #(1, 1) );
  add(self, #STKREADFRAMELOCALS,      1, #(1, 0, 1, 1) );
  add(self, #STKREADFRAMEN,           1, #(1, 0, 0, 0, 1) );
  add(self, #STKSETALARMLIMIT,        1, #(1, 1) );
  add(self, #STKSETALARMLIMITPERCENT, 1, #(1, 1) );
  add(self, #STKSETSTACKBASE,         1, #(1, 1) );
  add(self, #STKSETSTACKSIZE,         1, #(1, 1) );
  add(self, #STKSETSTACKTOPATTERN,    1, #(1, 1) );
  add(self, #STKGETCURRENTMODULE,     1, #(1) );
  add(self, #STKGETCURRENTFUNCTION,   1, #(1) );
  add(self, #STKGETCURRENTLINENUM,    1, #(1, 1, 1) );
  add(self, #STKGETSTACKINFO,         1, #(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1) );
  add(self, #STKSETSTACKBASEANDSIZE,  1, #(1, 1, 1) );
}
!!