/* class comment */!!

inherit(Window, #UpmPresenter, nil, 2, nil)!!

now(class(UpmPresenter))!!

/* 8/14/1997 17:47 */ 
Def openWithPosAndState(self, sizeRect, showVal | newHWnd )
{ 
   /* the Peripheral presenter in order to comply with Actor limitations
      must fake a windows object in Actor.  This object would be used to
      open, close, show a window.  The new(PeriphPresenter) call actually
      causes a CreateWindow call.  I do not want this window but I do 
      need this object to launch a peripheral window of my own.  Therefore,
      I destroy the created window using the handle myself and take over
      the object by brute force using a new WindowObject method SetHWnd().
      Not very nice but I have ulterior motives.
    */
  if not(exists(self))
      if not(TheUpmPresenter := new(UpmPresenter, nil, nil,
            "Upm",nil)) then
         ^nil;
      endif;
      Call DestroyWindow(handle(TheUpmPresenter));
      if ((newHWnd := openUpmWindow(MemServLibClass$Inst,
            sizeRect, WS_OVERLAPPEDWINDOW)) <> nil) then
         setHWnd(TheUpmPresenter,newHWnd);
         show(TheUpmPresenter,showVal);
      else
         ^nil;
      endif;
   endif;
   ^TheUpmPresenter; 
   
}      !!

/* 8/14/1997 17:46 */ 
Def open(self)
{
   /* the Peripheral presenter in order to comply with Actor limitations
      must fake a windows object in Actor.  This object would be used to
      open, close, show a window.  The new(PeriphPresenter) call actually
      causes a CreateWindow call.  I do not want this window but I do 
      need this object to launch a peripheral window of my own.  Therefore,
      I destroy the created window using the handle myself and take over
      the object by brute force using a new WindowObject method SetHWnd().
      Not very nice but I have ulterior motives.
    */
   if not(exists(self))
      if not(TheUpmPresenter:=new(UpmPresenter,nil,nil,
            "Upm",nil)) then
         ^nil;
      endif;
      Call DestroyWindow(handle(TheUpmPresenter));
      setHWnd(TheUpmPresenter,openUpmWindow(MemServLibClass$Inst,
            nil, nil));
      show(TheUpmPresenter,SW_SHOW);
   endif;
   ^TheUpmPresenter;

}       !!

/* 8/14/1997 17:45 */ 
Def exists(self | handle)
{
   if TheUpmPresenter
      handle := existsUpmWindow(MemServLibClass$Inst);
      if handle 
         setHWnd(TheUpmPresenter,handle)
      else
         TheUpmPresenter := nil;
      endif;
   endif;
   ^TheUpmPresenter;
}
!!

now(UpmPresenter)!!

/* 8/14/1997 17:44 */ 
Def saveWindowPos(self keyName| isIconic layout windRect)
{
  if (hWnd = 0)
    ^clearLayoutEntry(Window, asString(keyName));
  endif;    
  /* Save Layout for Peripheral window:
  ** if the window is an icon - use the previous saved layout
  **    if there is no previous saved lay out set to 0 for default size
  ** else
  **    Get the current window  position to save.
  */

  /* IsIconic returns nonzero if self is minimized */
  if (Call IsIconic(hWnd) = 0) then
    isIconic := 0;
    /* get the location of the current window position */
    Call GetWindowRect(hWnd, windRect := new(Rect));
    if (width(windRect)=0 cand height(windRect)=0)
       isIconic := 2;
    endif;
  else
    /* force the nonzero return to be 1 */
    isIconic := 1;
    if not(windRect := getPos(PreLauncher, asString(keyName))) then
      windRect := init(new(Rect),0,0,0,0);
    endif;      
  endif;

  if (windRect) then   
    layout := new(String, 18);  
    if (isIconic = 2)
       layout := " ";
    else
       layout := asString(left(windRect)) + "," + asString(top(windRect)) +
            "," + asString(right(windRect)) + "," +
            asString(bottom(windRect)) + "," + asString(isIconic);
    endif;
    saveProfileEntry(TheProfileInfoObj, "DefaultLayout", keyName, layout);
  endif;  
  ^GOOD;
}    !!

/* 8/14/1997 17:43 */ 
Def close(self)
{ 
   if (exists(class(self)))
      closeUpmWindow(MemServLibClass$Inst);
      TheUpmPresenter := nil;
   endif;
   ^GOOD;
}
!!