/* CLASS: ALIASPAT.CLS
   Requires PATHTOSRC.CLS - To be use with DLG_PATH_ALIAS resource.
   Provide directories browsing for source path aliasing.

   Call aliasPath(AliasPathToSrcDialogObject) to get the result.
   result = #("mydir\nextdir", 1|0) or nil
 */!!

inherit(FileDialog, #AliasPathToSrcDialog, #(fileName /* File to look for */
addToList /* Flag to add the new path to list */), 2, nil)!!

now(class(AliasPathToSrcDialog))!!

now(AliasPathToSrcDialog)!!

/* 06/17/93 - PRIVATE
  Get the selected file from the listbox, if any, and set
  loadFile. Assumes that a selection has been made
  in the list box. Make sure that the selection is the same as the
  input filename
*/
Def getLoadFile(self | sel)
{ 
  /* Get the selected string */
  Call DlgDirSelectComboBox(getHWnd(self), sel := new(String, 20), FILE_LB);
  sel := removeNulls(sel);
  /* Only when found the fileName then exit */
  if (sel = fileName) then
    ^loadFile := pathString(self, sel);
  else
    if exists(File, pathString(self, fileName), 0) then
      ^loadFile := pathString(self, fileName);
    endif;
  endif;
  ^nil;   
}!!

/* 06/17/93 - PRIVATE
  Respond to Open button being pushed or CR being pushed. If a
  valid file is selected, exit dialog. Otherwise, switch to new
  directory, filter, etc.  */
Def open(self | fs)
{ 
  fs := fileSpec;
  fileSpec := getItemText(self, FILE_LB);
  if (size(fileSpec) = 0) then
    fileSpec := "*."+pathParts(fileName)[2];
  endif;
  /* Check to make sure that we have the file before exit */
  if exists(File, pathString(self, fileName), 0) then
    loadFile := pathString(self, fileName);
    fileSpec := fs;
    resetDir(self);
    end(self, IDOK);
  else
    beep();
    if not(indexOf(fileSpec, '*', 0) cor indexOf(fileSpec, '?', 0)) then
      beep();
      setItemFocus(self, FILE_LB);
    endif;
    if not(loadList(self)) then
      fileSpec := fs;
    endif;
  endif;
}!!

/* 6/10/1993 10:39 - PUBLIC
  Return a tuple contains the selected filePath and its addToList option. 
  #("\xmydir\y.zdir",1)
*/
Def aliasPathToSource(self)
{ 
  ^tuple(loadFile, addToList);
}
!!

/* 6/10/1993 9:33 - PRIVATE
  Commands processing for AliasPathToSrcDialog
  Handle file dialog events (OK, Cancel, etc.). Selecting OK
  will always do something, if only to reload the lists according
  to the current filter. 
*/
Def command(self, wP, lP | action)
{ 
  action := high(lP);
  select
    case wP == IDCANCEL
    is resetDir(self);
      end(self, 0);
    endCase
    case wP == FILE_LB and action = LBN_SELCHANGE
    is sendDlgItemMessage(self, FILE_DIRLB, LB_SETCURSEL, -1, 0);
    endCase
    case wP == FILE_DIRLB and action = LBN_SELCHANGE
    is sendDlgItemMessage(self, FILE_LB, CB_SETCURSEL, -1, 0);
      setItemText(self, FILE_LB, getLoadDir(self) + fileSpec);
    endCase
    case (wP == FILE_DIRLB and action = LBN_DBLCLK)
      cor (wP == IDOK and getLBSel(self, FILE_DIRLB))
    is newDir(self);
    endCase
    case wP == FILE_LB and action = LBN_DBLCLK
    is if getLoadFile(self) then
        resetDir(self);
        end(self, IDOK);
      endif;
    endCase
    case wP == IDOK
      is open(self)
    endCase
    case (wP == CHECKBX_ADDTO_LIST) 
      addToList := toggle(self, wP);
    endCase  
  endSelect;
  ^1;
}  
!!

/* 6/7/1993 11:44 - PRIVATE
  Initalize AliasPathToSrcDialog object.
*/
Def initDialog(self, wp, lp)
{ 
  setText(self, "Path to Source");
  /* By default the Checkbox ADDTO_LIST is always checked */
  addToList := toggle(self, CHECKBX_ADDTO_LIST); 
  ^initDialog(self:ancestor, wp, lp);
}
!!

/* 6/10/1993 10:28 - PRIVATE
  Set FileSpec and InputPath for directories browsing.
*/
Def setFileSpec(self, fs | tmpStr)
{ 
  /* Check to make sure that the same input path is not return */
  tmpStr := pathParts(fs);
  fileName := tmpStr[1] + "." + tmpStr[2];
  ^fileSpec := "*." + tmpStr[2];
}
!!

/* set the help entry to use */
Def setHelpEntry(self, hEntry)
{
  setHelpEntry(self:ancestor, hEntry);
}!!
