/* Create event window putting save, restore, delete, clear and new in the menu bar.  */!!

inherit(AutomaticMenu, #EventWindow, #(eventListBox  /* handle for combo box of event names. */
statusList  /* collection of status buttons */
addrNotButton
dataNotButton
editFieldList /* collection of edit fields used */
asGroupBox
asButtonList  /* collection of address space buttons */
endAddrButton
endLenButton
asButtonsActive
charHeight
charWidth
theEvent  /* event window's event server */
numEvents  /* to know if we need to refresh */
activeEdit /* id number of active edit window */
doneInitializing?
activeEventName
numStatCol  /* number of column of status fields */
errorSemaFlag /* flag used to prevent getting into an endless loop when reporting an error and event presenter re-getting focus */
maxRight /* holds the max right hand border */
maxBottom
widestSignal /* holds the size of the widest signal in the column */ ), 2, nil)!!

setClassVars(EventWindow, #())!!

now(class(EventWindow))!!

/* PUBLIC
   Return the default window style. 
 */
Def style(self)
{ 
  ^(WS_OVERLAPPED bitOr WS_CAPTION bitOr WS_SYSMENU bitOr WS_MINIMIZEBOX);
}!!

/* PUBLIC */
Def open(self | newInstance num)
{
  ^openWithPosAndState(self, nil, SW_SHOWNORMAL);
}
!!

Def openWithPosAndState(self sizeRect showVal | newInstance)
{  
  newInstance := newStyle(EventWindow, nil, nil, "Events",
                   sizeRect, nil, style(self));
  if newInstance
    show(newInstance, showVal)
  endif;

  /* if no events exist, brings up the dialog to make new event */
  if(evtNumDefinedEvents(event(newInstance)) <= 1)
    eventNew(newInstance);
  endif;
  ^newInstance;
}
!!


Def wndClass(self)
{ ^"EventPresenter"
}!!

/* return name of trigger icon */
Def wndIcon(self)
{ ^"event" }
!!

now(EventWindow)!!

Def WM_LBUTTONDOWN(self, wp, lp)
{ ^sendMessage(eventListBox, CB_SHOWDROPDOWN, 0, 0L);
}!!

Def command(self, wP, lP | field){
/*
printNewLine("command: wp: "+asString(wP));
printNewLine("   lo lP: "+asString(low(lP))+";  hi lp: "+asString(high(lP)));
*/
  if activeEdit cand (wP <> activeEdit)
    handleActiveEdit(self);
  endif; 
  if low(lP) = 0
    ^command(self:ancestor,wP,lP);
  endif;
  /* if no active event - any actions done in presenter should be
     ignored.
   */
  if( not(activeEventName) cor size(activeEventName) = 0 )
    /* NOT buttons are automatic buttons need to undo click */
/*    if not(micepack?(ProcLibClass$Inst))*/
      if( (high(lP) = 0) and ((wP = ADDR_NOT_BOX) cor (wP = DATA_NOT_BOX)) )
        if( wP = ADDR_NOT_BOX )
          field := addrNotButton;
        else
          field := dataNotButton;
        endif;
        Call SendMessage(getHWnd(field), BM_SETCHECK, 0, 0);
      endif;
/*    endif;*/
    ^self;
  endif; /* no active event just get out */

  select
    case high(lP) = 512  /* EN_KILLFOCUS */
      handleActiveEdit(self);
    endCase 
    case high(lP) = EN_SETFOCUS
      activeEdit := wP;
    endCase
    case wP = 300 and ((high(lP) = LBN_SELCHANGE) cor (high(lP) = 8))
      evtSetActiveEvent(theEvent,getSelString(eventListBox));
      setupSelect(self);
      Call SetFocus(getHWnd(TheEventPresenter));
   endCase 
                                /* address or data's not button BN_CLICKED */
   case high(lP) = 0 and ((wP = ADDR_NOT_BOX) cor (wP = DATA_NOT_BOX))
/*     if not(micepack?(ProcLibClass$Inst))*/
       if( wP = ADDR_NOT_BOX )
         evtSetActiveField(theEvent, "address");
         field := addrNotButton;
       else
         evtSetActiveField(theEvent, "data");
         field := dataNotButton;
       endif;
       evtSetNotCondition(theEvent,
          Call SendMessage(getHWnd(field), BM_GETCHECK, 0, 0));
/*     endif;*/
     Call SetFocus(getHWnd(TheEventPresenter));
   endCase

   case high(lP)=0 cand wP=ADDR_END_ADDR_BOX
     Call SendMessage(getHWnd(endAddrButton), BM_SETCHECK, 1, 0);
     Call SendMessage(getHWnd(endLenButton), BM_SETCHECK, 0, 0);
     evtSetEndFunction(theEvent,END_ADDR_FUNC);
     handleEndFuncChange(self);
     Call SetFocus(getHWnd(TheEventPresenter));
   endCase
   case high(lP)=0 cand wP=ADDR_END_LEN_BOX
     Call SendMessage(getHWnd(endAddrButton), BM_SETCHECK, 0, 0);
     Call SendMessage(getHWnd(endLenButton), BM_SETCHECK, 1, 0);
     evtSetEndFunction(theEvent,END_LEN_FUNC);
     handleEndFuncChange(self);
     Call SetFocus(getHWnd(TheEventPresenter));
  endCase
                                  /* BN_CLICKED is one of the 0 1 X buttons */
                          /* BN_CLICKED is one of the address space buttons */
   case high(lP)=0 cand (wP>=UD_BOX_ID cand wP<=CPU_BOX_ID)
      handleAddrSpaceButtons(self,wP);
     Call SetFocus(getHWnd(TheEventPresenter));
   endCase
                                  /* BN_CLICKED is one of the 0 1 X buttons */
   case high(lP) = 0 and wP >= FIRST_STATUS_ID
     handleStatusButtons(self,wP);
     Call SetFocus(getHWnd(TheEventPresenter));
   endCase
  endSelect;
}
!!

/* PRIVATE 
   Edit field losing focus - just in here because edit field
   class calls this - not sure why! 
*/
Def childIsLosingFocus(self, child)
{

}!!

Def clearASButtons(self){
  do(asButtonList,                 /* clear out all radio buttons options */
  {using(button)
    Call SendMessage(getHWnd(button), BM_SETCHECK, 0, 0);
  });
}!!

Def clearEvent(self){ 
  if not(micepack?(ProcLibClass$Inst))
    Call SendMessage(getHWnd(addrNotButton), BM_SETCHECK, 0, 0);
    Call SendMessage(getHWnd(dataNotButton), BM_SETCHECK, 0, 0);
  endif;
  Call SendMessage(getHWnd(endAddrButton), BM_SETCHECK, 0, 0);
  Call SendMessage(getHWnd(endLenButton),  BM_SETCHECK, 0, 0);
  do(over(0, size(editFieldList)),
  {using(ef)
    setText(editFieldList[ef], " ");
  });

  if (TheProcFamily = PROC_FAMILY_680X0)
     do(over(0,size(asButtonList)),   /* clear out all address space buttons */
     {using(idx)
       Call SendMessage(getHWnd(asButtonList[idx]),BM_SETCHECK,0,0);
     });
  endif;

  do(over(0,size(statusList)),   /* clear out all status buttons */
  {using(idx)
    Call SendMessage(getHWnd(statusList[idx]),BM_SETCHECK,0,0);
  });
}
!!

/* PRIVATE */
Def close(self)
{
  if parent 
    childIsClosing( parent, self ) ; /* notify parent */
  endif;
  show(self, SW_HIDE);
  close( self:ancestor ) ;
}
!!

/* Set up event template fields.  I.E.: get the edit fields, group
   boxes, radio buttons etc. for the template fields.  This routine
   is currently hardcoded.
 */
Def createEventDisplay(self | anId left top num addrDigits dataDigits 
                       tempMaxRight fieldNum theTemplate numOfEvents title){
  editFieldList := new(OrderedCollection, 1);
  asButtonList := new(OrderedCollection, 1);
  top := charHeight+charHeight;
  left := charWidth * 42;
  endAddrButton := newRadioButton(self,"End Addr",ADDR_END_ADDR_BOX,left,top);
  left := left + (charWidth*14);
  endLenButton := newRadioButton(self,"Length",ADDR_END_LEN_BOX,left,top);
  top := charHeight*3;
  left := charWidth * 10;
/*  if not(micepack?(ProcLibClass$Inst))*/
    addrNotButton := newAutoCheckBox(self, left,top, ADDR_NOT_BOX);
    left := left + (3*charWidth);
/*  endif;*/
  top := top;
  num := 27;
  add(editFieldList, newHexEditField(self, left,top, ADDR_START_FIELD,num));
  left := left + ((num+2)*charWidth);
  add(editFieldList, newHexEditField(self, left,top, ADDR_END_FIELD,num));
  left := left + ((num+2)*charWidth);

  /* Added this code so that the address mask field and data mask field */
  /* can be varied based on the address and data display field lengths  */
  /* specified in the ev"proc".cfg file.                                */
  fieldNum := 1;
  addrDigits := nil;
  dataDigits := nil;
  theTemplate:=eventTemplateOpen(require(EvttmpltLib));
  tmpltSetTemplateName(theTemplate,"default");
  numOfEvents := tmpltGetNumOfEntries(theTemplate);

  addrDigits := 6;
  dataDigits := 6;

/* remove for coldfire  
  add(editFieldList, newHexEditField(self, left,top, ADDR_MASK_FIELD,
      addrDigits + 7));
*/
 
/*  tempMaxRight := addrDigits + 8;
  if (tempMaxRight < (dataDigits + 8))
     tempMaxRight := dataDigits + 8;
  endif;
  maxRight := left + (tempMaxRight*charWidth);
*/
  maxRight := left + 4*charWidth;

  /* Data not box, start field and end field */
  top := (charHeight*6);
  left := charWidth * 10;
/*  if not(micepack?(ProcLibClass$Inst))*/
    dataNotButton := newAutoCheckBox(self, left,top, DATA_NOT_BOX);
    left := left + 3*charWidth;
/*  endif;*/
  top := top;
  add(editFieldList, newHexEditField(self, left,top,DATA_START_FIELD,num));
  if not(micepack?(ProcLibClass$Inst))
    left := left + ((num+2)*charWidth);
  /* don't add to list if micepack */
    add(editFieldList, newHexEditField(self, left,top,DATA_END_FIELD,num));
  endif;
  left := left + ((num+2)*charWidth);
  add(editFieldList, newHexEditField(self, left,top,DATA_MASK_FIELD,
      dataDigits + 7));

  top := charHeight*7 + charHeight/2;
  left := charWidth * 3;

  /* Only make the space box if this is a motorola family processor */
  /*
  if (TheProcFamily = PROC_FAMILY_680X0)
     newSpaceBox(self, top, left);
  endif;
  *//*   above marked by Jimmy 11/22/94  */

  createStatusList(self);
  maxBottom := maxBottom + charHeight/2;
}
!!

Def createStatusList(self | anId left top statusStart theTemplate num cs
                              fcX fc0 fc1 fc2 lastLeft nextLeft numToShow
                              numRows){
  statusList := new(OrderedCollection, 1);
  widestSignal := new(Array,5);
  fill(widestSignal,0);

  statusStart := top := (charHeight*11)+charHeight/2 ;
  left := charWidth*5;
  lastLeft := left;
  anId := FIRST_STATUS_ID;
  numStatCol := 1;
  numToShow := 0;
 
  theTemplate:=eventTemplateOpen(require(EvttmpltLib));
  tmpltSetTemplateName(theTemplate,"default");
  num := tmpltGetNumOfEntries(theTemplate);
  do(over(1,num+1),
  {using(fieldNum | title, visible)
    title := tmpltGetNameGivenFieldNumber(theTemplate,fieldNum);
    visible := tmpltGetVisible(theTemplate);
    if( (tmpltGetFieldType(theTemplate) = 0) cand (visible <> 0)) /* VALUE_FIELD */
      numToShow := numToShow + 1;
    endif; 
  });
  numRows := numToShow/5;
  if ((numToShow mod 5) <> 0)
     numRows := numRows + 1;
  endif;
  maxBottom := (numRows * charHeight) + statusStart;
  do(over(1,num+1),
  {using(fieldNum | title)
    title := tmpltGetNameGivenFieldNumber(theTemplate,fieldNum);
    if( (tmpltGetFieldType(theTemplate) = 0) /* VALUE_FIELD */
      cand (tmpltGetVisible(theTemplate) = 1) ) 

     if( top+charHeight > maxBottom)
        numStatCol := numStatCol + 1;
        top := statusStart;
        left := lastLeft + charWidth*3; 
      endif;
 
      nextLeft:=newEventGroup(self,title,top,left,anId);
      if (nextLeft > lastLeft)
        lastLeft := nextLeft;
      endif;
 
      top := top + charHeight;
      anId := anId + 4;
    endif;
  });

  if (maxRight < (lastLeft + charWidth))
     maxRight := lastLeft + charWidth;
  endif;
  
  /* A23-A19 can't not be traced or triggered on when used as i/o functions
     because these bits in the xilinx are used as the logical address bits.
   */
  if((TheProcFamily = PROC_FAMILY_680X0) cand 
     (asButtonsActive:=tmpltDisplayAddressSpace(theTemplate)) = 0)
     if (tmpltWhatsPinsFunction(theTemplate,3, fc0) <> 0) then
       fc0 = SELF_FUNC;
     endif;
     if (tmpltWhatsPinsFunction(theTemplate,4, fc1) <> 0) then
       fc1 = SELF_FUNC;
     endif;
     if (tmpltWhatsPinsFunction(theTemplate,5, fc2) <> 0) then
       fc2 = SELF_FUNC;
     endif;

     fcX := tuple(fc0,fc1,fc2);
     cs:=0; 
     do( #("fc0" "fc1" "fc2"),
     {using(title)
       if( fcX[cs] = SELF_FUNC ) 
         newEventGroup(self,title,top,left,anId);  
         top := top + charHeight+1;
         anId := anId + 4; 
       endif;
       cs := cs + 1;
     });    
   endif; 
}!!

/* comment */
Def event(self) { 
  ^theEvent;

}
!!

/* comment */
Def eventClear(self)
{ 
  evtClearEvent(theEvent) ;
  setupEvent(self);
}
!!

Def eventRemoveAll(self | idx str num)
{ if( (getCount(eventListBox)) = 0 )
    ^self;         /* there's are no events to delete - just exit */
  endif;
  if (errMessageBox(ErrorTextLibClass$Inst, "Warning", 
       "Delete ALL Events?", 
       MB_YESNO bitOr MB_ICONQUESTION, HE_DLGM_EVENT_3) = IDYES) then
     evtDeleteAllEvents(theEvent);
     num := evtNumDefinedEvents(theEvent); 
     if( num = 0 or num = 1)
       clearList(eventListBox);
       setText(self,"Events: No Event Selected");
       clearEvent(self);
     endif;
  endif;
}
!!

/* comment */
Def eventDelete(self | idx str)
{ if( (getCount(eventListBox)) = 0 )
    ^self;         /* there's no event to delete - just exit */
  endif;
  idx := selIdx(eventListBox);
  deleteString(eventListBox,idx);
  evtDeleteEvent(theEvent) ;
  if( (getCount(eventListBox)) <> 0 )  
    if( idx <> 0 )
      idx := idx - 1;
    endif;
    if( getString(eventListBox,idx) )
      evtSetActiveEvent(theEvent,getString(eventListBox,idx));
    endif;
  else 
    invalidate(eventListBox);
  endif;
  setupSelect(self);
}
!!

/* MENU */
Def eventExit(self)
{ 
  if (shouldClose(self))
  then
    destroy(self) ;
  else
    displayFormattedError(ErrorTextLibClass$Inst, ER_INTERNAL, 
       FORCE_POPUP, "File Exit Bug",
       "shouldClose(self) said no", nil);
  endif ;
}
!!

/* 
 *
 * Notes (Ron, 6/8/93): Changed to use InputDlgWithHelp instead of
 *                      InputDialog as part of PowerViews Improvement
 *                      Project.
 */
Def eventNew(self | box name rc)
{ 
  box := open(InputDlgWithHelp);

  setUp(box, "Add Event","&Name:","", HE_DLGI_EVENTWIN_1);

  if (runModal(box, DLG_INPUT_WITH_HELP, ThePort) = IDOK) then 
    name := getText(box);
    if( size(name) <> 0 )
      rc := evtSetActiveEvent(theEvent, name);
      if( rc = 0 )
        if( not(selectString(eventListBox,name)) )  /* can't select a string that's */
         addString(eventListBox, name);            /* not there - so add it */
        endif;
        setupSelect(self);
      endif;
    endif;
  endif;
}
!!

/* PRIVATE
   Prompts user for restore file and then calls event server
   restore routine and updates event presenter.
 */
Def eventRestore(self | box path)
{ 
  path := "*.evt";
  /* @@@ try reading information from project.ini */
  box := new(FileDialog, path);
  setHelpEntry(box, HE_DLGF_RESTORE_EVENTS);
  if (runModal(box, FILE_BOX, self) = IDOK) 
    if( evtRestoreEvents(theEvent, loadFile(box)) = 0 )
      setupListBox(self);
      evtSetActiveEvent(theEvent,getString(eventListBox,0));
      setupSelect(self);
      setupEvent(self);
    endif;
  endif;
}
!!

/* comment */
Def eventSave(self | path box){ 
  path := "*.evt";
  /* @@@ try reading information from project.ini */
  box := new(SaveFileDialog, path);
  setHelpEntry(box, HE_DLGF_SAVE_EVENTS);
  if (runModal(box, FILE_BOX, self) = IDOK) 
    evtSaveAsEvents( theEvent, loadFile(box) ) ;
  endif;
}
!!

/* PRIVATE */
Def findASButton(self,wP){ 
  do(over(0, size(asButtonList)),
    {using(field)
      if id(asButtonList[field]) = wP
        ^field;
      endif;
    });
  ^nil;
}
!!

/* PRIVATE */
Def findEditField(self,wP){ 
  do(over(0, size(editFieldList)),
    {using(field)
      if id(editFieldList[field]) = wP
        ^field;
      endif;
    });
  ^nil;
}
!!

/* 6/8/1992 8:55 */
Def findStatus(self, id) { 
  do(over(0, size(statusList)),
    {using(field)
      if id(statusList[field]) = id
        ^field;
      endif;
    });
  ^nil;
}
!!

/* 6/8/1992 7:40 */
Def getAddrSpace(self | fc2 fc1 fc0  f1 f2 f0)
{  
  fc2 := fc1 := fc0 := 0;
  evtSetActiveField(theEvent, "fc2");
  f2:=evtGetStartAndMask(theEvent);
  evtSetActiveField(theEvent, "fc1");
  f1:=evtGetStartAndMask(theEvent);
  evtSetActiveField(theEvent, "fc0");
  f0:=evtGetStartAndMask(theEvent);
  if f0 = "X" cor f1 = "X" cor f2 = "X"
    ^0;   /* not a legal address space */
  endif;
  if f2 = "1" 
    fc2 := 1;
  endif;
  if f1 = "1" 
    fc1 := 1;
  endif;
  if f0 = "1" 
    fc0 := 1;
  endif;
  ^((fc2*4) + (fc1*2) + fc0);
}
!!

/*  See if event number has changed since we lost focus?
*/
Def gotFocus(self, hWndPrev | tmp)
{
  if not(doneInitializing?) cor errorSemaFlag
    ^self;
  endif;
  errorSemaFlag := 1;
  if( numEvents <> (tmp:=evtNumDefinedEvents(theEvent)) )
    setupListBox(self);
    setupSelect(self);
  endif;
  if( numEvents <> 0 )
    setupSelect(self);
  endif; 
  errorSemaFlag := nil;
}!!

Def handleActiveEdit(self | grpId field status){
  if not(activeEdit) ^self; endif;
  if( not(activeEventName) cor size(activeEventName) = 0 ) ^self; endif; /* no active event just get out */
    /* Need to nil out activeEdit first because if any of the server
       calls produce an error - the error message is pop'd up causing
       kill focus type commands which results in this code being called
       twice.
     */
  field := activeEdit;
  preActiveEdit := activeEdit ;
  activeEdit := nil;
  if( field >= ADDR_START_FIELD cand field <= ADDR_MASK_FIELD )
    evtSetActiveField(theEvent, "address");
    grpId := ADDR_START_FIELD;
  else
    evtSetActiveField(theEvent, "data");
    grpId := DATA_START_FIELD;
  endif;
  status := getText(editFieldList[findEditField(self,field)]);
  status := leftJustify(status);
  if( field = ADDR_START_FIELD cor field = DATA_START_FIELD)
    evtSetStart(theEvent,status);
  endif;
  if( field = ADDR_END_FIELD cor field = DATA_END_FIELD )
    /* avoid call if micepack and end field */
    if (not(micepack?(ProcLibClass$Inst)) cor field = ADDR_END_FIELD)
      evtSetEnd(theEvent,status);
    endif;
  endif;

/*  if( field = ADDR_MASK_FIELD cor field = DATA_MASK_FIELD ) //gene */
  if (field = DATA_MASK_FIELD )
    evtSetMask(theEvent,status);
  endif;
  status:=evtGetStart(theEvent);
  setText(editFieldList[findEditField(self,grpId)], status);
  /* Avoid data end field processing if micepack and data start */
  if (not(micepack?(ProcLibClass$Inst)) cor (grpId = ADDR_START_FIELD))
    status:=evtGetEnd(theEvent);
    setText(editFieldList[findEditField(self,grpId + 1)], status); 
  endif;
  if (grpId = DATA_START_FIELD )
    status:=evtGetMask(theEvent);
    setText(editFieldList[findEditField(self,grpId + 2)], status);
  endif;
}!!

Def handleAddrSpaceButtons(self, wP | addrSpace) {
  if( asButtonsActive = 0 )
    ^self;
  endif;
  clearASButtons(self);
  Call SendMessage(getHWnd(asButtonList[findASButton(self,wP)]), BM_SETCHECK,
                   1, 0);
  addrSpace := 0;
  if( wP = UD_BOX_ID )
    addrSpace := ADDR_SPACE_UD;                   /* user data */
  endif;
  if( wP = UP_BOX_ID )
    addrSpace := ADDR_SPACE_UP;                   /* user program */
  endif;
  if( wP = SD_BOX_ID )
    addrSpace := ADDR_SPACE_SD;                   /* supervisor data */
  endif;
  if( wP = SP_BOX_ID )
    addrSpace := ADDR_SPACE_SP;                   /* supervisor program */
  endif;
  if( wP = CPU_BOX_ID )
    addrSpace := ADDR_SPACE_CPU;                   /* cpu */
  endif;
  setAddrSpace(self, addrSpace);
}
!!

Def handleEndFuncChange(self | grpId field status)
{ 
  evtSetActiveField(theEvent, "address");
  status := getText(editFieldList[1]);
  evtSetEnd(theEvent,status);
  status:=evtGetEnd(theEvent);
  setText(editFieldList[1], status); 
}!!

Def handleStatusButtons(self, wP | tmp field start status) {
  tmp := (((wP - FIRST_STATUS_ID) / 4)*4) + FIRST_STATUS_ID;
  field := findStatus(self,tmp);

  /* Disable all the radio buttons for the status button */
  setCheck(statusList[field],nil);
  setCheck(statusList[field+1],nil);
  setCheck(statusList[field+2],nil);
  tmp := findStatus(self,wP);
  if tmp = field
    start := "0";
  else
    if tmp = (field+1)
      start := "1";
    else
      start := "X";
    endif;
  endif;
  status := getText(statusList[field+3]);
  evtSetActiveField(theEvent, status);
  if( evtSetStartAndMask(theEvent, start) = 0 ) 
    setCheck(statusList[tmp],1); 
  endif;
}

!!

Def init(self | buttonX heightDiff maxX maxY overrun)
{
  init(self:ancestor);
  if not($commonEventLib)
    $commonEventLib := eventOpen( require(EventLib), "default" ) ; 
  endif;
  theEvent := $commonEventLib;
  initCharDimensions(self);
  createEventDisplay(self);
  eventListBox := newDropDownList(ComboBox, 300, self, 
                  rect(charWidth*20,3,charWidth*50,(charHeight*7)+3));
  setupListBox(self);
  setupSelect(self);
  initMenus(self);

  /* The locRect height should be the height of the menu */
  /* bar plus the height of the client rectangle. This   */
  /* fix was put in by Dennis Lamb, March 31, 1994.      */
  heightDiff := height(locRect) - height(clientRect(self));
  setBottom(locRect,maxBottom + heightDiff);
  setRight(locRect,maxRight);
  /* setSize(self,locRect); */
 
  setBottom(locRect, top(locRect)+bottom(locRect));
  setRight(locRect, left(locRect)+right(locRect));

  /* get size of screen */
  maxX := x(screenSize());
  maxY := y(screenSize());

  /* adjust width to be visible horizontally */
  overrun := right(locRect) - maxX;
  if overrun > 0
     /* if it can't fit on screen, give priority to left */
  if overrun > left(locRect)
     overrun := left(locRect);
  endif;
  setLeft(locRect, left(locRect) - overrun);
  setRight(locRect, right(locRect) - overrun);
  endif;

  /* adjust height to be visible vertically */
  overrun := bottom(locRect) - maxY;
  if overrun > 0
     /* if it can't fit on screen, give priority to top */
  if overrun > top(locRect)
     overrun := top(locRect);
  endif;
  setTop(locRect, top(locRect) - overrun);
  setBottom(locRect, bottom(locRect) - overrun);
  endif;

  setCRect(self,locRect);
  moveWindow(self);
  doneInitializing?:=#true;
}
!!

/* initialize char width and height */
Def initCharDimensions(self | hdc, tm, oldFont)
{
  tm  := new( Struct, 32 ) ;
  Call GetTextMetrics(hdc := getContext(self), tm);
  charWidth  := asInt( wordAt(tm, 10) ) ;
  charHeight := asInt( wordAt(tm, 8) ) + asInt( wordAt(tm, 0) ) ;
  releaseContext( self, hdc ) ;
}
!!

/* PRIVATE
   Initialize the menus.
 */
Def initMenus(self | aMenu)
{ 
  aMenu := new(OrderedCollection, 8);
  initMenu(self);
  
  add(aMenu, tuple("&File",tuple(
                      tuple("&Save Events As...",   #eventSave),
                      tuple("&Restore Events...",#eventRestore),
                      tuple("E&xit",   #eventExit))));
                      
  add(aMenu, tuple("&Edit",tuple(
                      tuple("&Add Event...", #eventNew),
                      tuple("&Delete Event",  #eventDelete),
                      tuple("&Clear Event",  #eventClear),
                      tuple("D&elete All Events", #eventRemoveAll))));

  attachMenuChoices(self,aMenu);
  addWindowAndHelp(self, "&Event", HELP_ENTRY_EVENT);
  registerF1Help(CLIULibraryClass$Inst, HI_ENTRY_EVENT,
     getHWnd(self), HELP_ENTRY_EVENT);
  drawMenu(self);
}!!

/* PRIVATE */
Def newAutoCheckBox(self, left, top, id | aCheckBox)
{ 
  aCheckBox := new( Button, id, self, nil, BS_AUTOCHECKBOX bitOr WS_TABSTOP) ;
  setCRect( aCheckBox, 
            init( new(Rect), 
                  left,                  /* left   */
                  top,                   /* top    */
                  (left+2*charWidth),    /* right  */
                  (top+charHeight+2)     /* bottom */
               ) 
          ) ;
  moveWindow( aCheckBox ) ;
  
  ^aCheckBox
}!!

/* PRIVATE */
Def newCheckBox(self, title, left, top, group, id | aCheckBox) { 
  aCheckBox:=new(Button,id,group,title,BS_RADIOBUTTON bitOr WS_TABSTOP);
  setCRect( aCheckBox, 
            init( new(Rect), 
                  left,                  /* left   */
                  top,                   /* top    */
                  (left+(size(title)+4)*charWidth),    /* right  */
                  (top+charHeight+1)     /* bottom */
               ) 
          ) ;
  moveWindow( aCheckBox ) ;
  ^aCheckBox
}!!

/* comment */
Def newEventGroup(self,title,top,left,id | hDC, cSize, cWidth) { 
  /* Added the following code to calculate the exact size needed to */
  /* hold the status name. Make the rectangle the exact size needed */
  /* to hold the text.                                              */
  hDC := getContext(self);
  cSize := Call GetTextExtent(hDC, title, size(title));
  releaseContext(self, hDC);
  cWidth := asInt(low(cSize));

  if (cWidth > widestSignal[numStatCol-1])
     widestSignal[numStatCol-1] := cWidth;
  endif;

  add(statusList, newRadioButton(self, nil, id, left, top));
  left := left + (charWidth*3);
  add(statusList, newRadioButton(self, nil, id+1, left, top));
  left := left + (charWidth*3);
  add(statusList, newRadioButton(self, nil, id+2, left, top));
  left := left + (charWidth*3);
  add(statusList, newStatic(self, title, left, top, id+3, cWidth));
  left := left + cWidth;
  ^left;
}!!

/* PRIVATE */
Def newGroupBox(self, name, left, top, id | aGroupBox){
  aGroupBox := new(Button,id,self,name,
                   BS_GROUPBOX bitOr WS_TABSTOP bitOr WS_GROUP) ;
  setCRect( aGroupBox, 
            init( new(Rect), 
                  left,                  /* left   */
                  top,                   /* top    */
                  (maxRight-(charWidth*3)), /* right  */
                  top + (charHeight*2) + (charHeight/2)       /* bottom */
               ) 
          ) ;
  moveWindow( aGroupBox ) ;
  ^aGroupBox
}!!

/* PRIVATE */
Def newHexEditField(self, left, top, id, width | rect, field) { 
  rect := init( new(Rect), 
                  left,                  /* left   */
                  top,                   /* top    */
                  (left+(width*charWidth)),    /* right  */
                  (top+(charHeight/2)+charHeight)     /* bottom */
               ); 
  field := new(EventEdit, id, self, 
            WS_BORDER bitOr WS_VISIBLE bitOr WS_TABSTOP bitOr ES_AUTOHSCROLL);
  setCRect( field, rect);
  moveWindow( field ) ;
  ^field
}
!!

/* PRIVATE */
Def newRadioButton(self, title, id, left, top | aRadio len) { 
  aRadio := new( Button, id, self, title, BS_RADIOBUTTON bitOr WS_TABSTOP) ;
  len := charWidth+(charWidth/4);
  if( title )
    len := size(title)*charWidth + (charWidth/4);
  endif;
  setCRect( aRadio, 
            init( new(Rect), 
                  left,                  /* left   */
                  top,                   /* top    */
                  (left+len+((len/4)*3)),    /* right  */
                  (top+charHeight)       /* bottom */
               ) 
          ) ;
  moveWindow( aRadio ) ;
  ^aRadio
}!!

/* comment */
Def newSpaceBox(self, top, left | id inc) { 
  asGroupBox := newGroupBox(self, "Address Space",left,top,SPACE_GROUP_BOX_ID);
  left := left + charWidth * 4;
  top := top + charHeight; 
  inc := charWidth*13 + charWidth/4;
  id := UD_BOX_ID;
  add(asButtonList, newCheckBox(self, "UD", left, top, self, id));
  left := left + inc;
  add(asButtonList, newCheckBox(self, "UP", left, top, self, id+1));
  left := left + inc;
  add(asButtonList, newCheckBox(self, "SD", left, top, self, id+2));
  left := left + inc;
  add(asButtonList, newCheckBox(self, "SP", left, top, self, id+3));
  left := left + inc;
  add(asButtonList, newCheckBox(self, "CPU", left, top, self, id+4));
}!!

/* PRIVATE */
Def newStatic(self, text, left, top, id, textSize | aStatic) {

  aStatic := new( Static, id, self, text, 11 /*SS_SIMPLE*/) ;
  setCRect( aStatic, 
            init( new(Rect), 
                  left,                  /* left   */
                  top,                   /* top    */
                  (left+textSize),         /* right  */
                  (top+charHeight)      /* bottom */
               ) 
          ) ;
  moveWindow( aStatic ) ;
  ^aStatic
}!!

/* WINDOWS */
Def paint(self, hdc | aStr top left startPt endPt) { 
  initTextColors(self,hdc);
  top := (charHeight/8)*3;
  left := charWidth * 7;
  aStr := "Active Event:";
  Call TextOut(hdc, left, top, aStr, size(aStr));
  top := charHeight*2;
  left := (charWidth * 9) + charWidth/2;
/*  if not(micepack?(ProcLibClass$Inst))*/
    aStr := "Not";
/*  else
    aStr := "   ";
  endif;
*/  
  Call TextOut(hdc, left, top, aStr, size(aStr));
  left := charWidth * 20;
  aStr := "Start";
  Call TextOut(hdc, left, top, aStr, size(aStr));
/*  left := charWidth * 66;
  aStr := "Mask";
  Call TextOut(hdc, left, top, aStr, size(aStr));
*/  
  top := charHeight*3;
  left := 3*charWidth;
  aStr := "Addr:";
  Call TextOut(hdc, left, top, aStr, size(aStr));

  top := charHeight*5;
  left := charWidth * 20;
/*  if not(micepack?(ProcLibClass$Inst))*/
    aStr := "Value";
/*  else
    aStr := "     ";
  endif;
*/  
  Call TextOut(hdc, left, top, aStr, size(aStr));
/*  left := charWidth * 40;
  if not(micepack?(ProcLibClass$Inst))
    aStr := "End";
  else
    aStr := "   ";
  endif;
  Call TextOut(hdc, left, top, aStr, size(aStr));
*/
  left := (charWidth * 9) + charWidth/2;
  aStr := "Not";
  Call TextOut(hdc, left, top, aStr, size(aStr));
  left := charWidth * 44;
  aStr := "Mask";
  Call TextOut(hdc, left, top, aStr, size(aStr));

  top := charHeight*6;
  left := 3*charWidth;
  aStr := "Data:";
  Call TextOut(hdc, left, top, aStr, size(aStr));

  top := charHeight*10;
  left := charWidth*5+1;
  do(numStatCol,
  {using(col)
    aStr := "0";
    Call TextOut(hdc, left, top, aStr, size(aStr));
    left := left + (charWidth *3);
    aStr := "1";
    Call TextOut(hdc, left, top, aStr, size(aStr));
    left := left + (charWidth *3);
    aStr := "X";
    Call TextOut(hdc, left, top, aStr, size(aStr));
    left := left + (charWidth*6) + widestSignal[col];
  });
  top := top + charHeight;
  startPt := point(0, top);
  endPt := point(width(locRect),top);
  line(startPt,endPt,hdc);
}!!

/* 6/8/1992 7:40 */
Def setAddrSpace(self, addrSpace | fc2 fc1 fc0 ) { 
  if( addrSpace <> 0 )
    fc2 := asString((addrSpace bitAnd 0x4) / 4);
    fc1 := asString((addrSpace bitAnd 0x2) / 2);
    fc0 := asString((addrSpace bitAnd 0x1));
  else
    fc2 := fc1 := fc0 := "X";
  endif;
  evtSetActiveField(theEvent, "fc2");
  evtSetStartAndMask(theEvent,fc2);
  evtSetActiveField(theEvent, "fc1");
  evtSetStartAndMask(theEvent,fc1);
  evtSetActiveField(theEvent, "fc0");
  evtSetStartAndMask(theEvent,fc0);
}
!!

Def setupAddrSpaceButtons(self | func addrSpace id){
  if( asButtonsActive = 1 )
    clearASButtons(self);
    id := SPACE_GROUP_BOX_ID;
    addrSpace := getAddrSpace(self);
    if addrSpace = ADDR_SPACE_UD
      id := UD_BOX_ID;
    endif;
    if addrSpace = ADDR_SPACE_UP
      id := UP_BOX_ID;
    endif;  
    if addrSpace = ADDR_SPACE_SD
      id := SD_BOX_ID;
    endif;  
    if addrSpace = ADDR_SPACE_SP
      id := SP_BOX_ID;
    endif;  
    if addrSpace = ADDR_SPACE_CPU
      id := CPU_BOX_ID;
    endif; 
    if( addrSpace <> 0 cand findASButton(self,id) <> nil)
      Call SendMessage(getHWnd(asButtonList[findASButton(self,id)]), 
                     BM_SETCHECK, 1, 0);
    endif;
  else
    do(asButtonList,                 /* gray out all radio buttons options */
    {using(button)
      Call SendMessage(getHWnd(button), BM_SETCHECK, 0, 0);
    });
  endif;
}
!!

/*
*/
Def setupEvent(self | not start end status field index actEvent){ 
  actEvent := evtGetActiveEvent(theEvent);
  if( actEvent = "" cor actEvent = "PC_Breakpoint")  /* no selected active event */
    ^self;
  endif;
  evtSetActiveField(theEvent, "address");
/*  if not(micepack?(ProcLibClass$Inst))*/
    not := evtGetNotCondition(theEvent);
    Call SendMessage(getHWnd(addrNotButton), BM_SETCHECK, not, 0);
/*  endif;*/
  index := 0;
  start := evtGetStart(theEvent); 
  setText(editFieldList[index], start);
  if( evtGetEndFunction(theEvent) = END_ADDR_FUNC ) 
    Call SendMessage(getHWnd(endAddrButton), BM_SETCHECK, 1, 0);
    Call SendMessage(getHWnd(endLenButton), BM_SETCHECK, 0, 0);
  else
    Call SendMessage(getHWnd(endAddrButton), BM_SETCHECK, 0, 0);
    Call SendMessage(getHWnd(endLenButton), BM_SETCHECK, 1, 0);
  endif;
  end := evtGetEnd(theEvent); 
  index := index + 1;
  setText(editFieldList[index], end); 
/* remove for coldfire //
  end := evtGetMask(theEvent); 
  index := index + 1;
  setText(editFieldList[index], end); 
*/

  evtSetActiveField(theEvent, "data");
/*  if not(micepack?(ProcLibClass$Inst))*/
    not := evtGetNotCondition(theEvent);
    Call SendMessage(getHWnd(dataNotButton), BM_SETCHECK, not, 0);
/*  endif;*/
  start := evtGetStart(theEvent);
  index := index + 1; 
  setText(editFieldList[index], start); 
  /* data end not available on micepack */
  if not(micepack?(ProcLibClass$Inst))
    end := evtGetEnd(theEvent);
    index := index + 1; 
    setText(editFieldList[index], end); 
  endif;
  end := evtGetMask(theEvent);
  index := index + 1; 
  setText(editFieldList[index], end); 

  /* Only do this if we are dealing with a motorola processor */
  if (TheProcFamily = PROC_FAMILY_680X0)
     setupAddrSpaceButtons(self);
  endif;

  do(overBy(0, size(statusList), 4),
  {using(field)
    setupStatus(self, getText(statusList[field+3]), field);
  });
}
!!

/* PRIVATE */
Def setupListBox(self | num)
{ 
  clearList(eventListBox);
  /* Go to event server and get the list of defined
     events and send them to the combo box. */
  num := evtNumDefinedEvents(theEvent); 
  do(num,
  {using(elem | eName)
    eName := evtGetNextEvent(theEvent);
    if (eName cand eName <> "PC_Breakpoint")
      addString(eventListBox, eName);
    endif;
  });
  ^numEvents := num;
}!!

/* PRIVATE */
Def setupSelect(self | str) { 
 if( not(activeEventName) cor (size(activeEventName) = 0) cor 
     ((str := evtGetActiveEvent(theEvent)) <> activeEventName) )
   if( ((not(activeEventName)) cor (size(activeEventName)=0))
       cand (getCount(eventListBox) <> 0) )
     selectIndex(eventListBox,0);
     str := getSelString(eventListBox);
     evtSetActiveEvent(theEvent,str);
   endif;
   activeEventName := str;
   if( not(str) cor (str  = "") )  /* no selected active event */
     setText(self,"Events: No Event Selected");
     clearEvent(self);
   else
     setText(self,"Event: "+str);
     selectString(eventListBox,str); 
     setupEvent(self);
   endif;
 else
   selectString(eventListBox,activeEventName);
 endif;   
}!!

/* 6/8/1992 8:49 */
Def setupStatus(self, status, field | start end){
  evtSetActiveField(theEvent, status);
  start := evtGetStartAndMask(theEvent); 
  Call SendMessage(getHWnd(statusList[field]), BM_SETCHECK, 0, 0); 
  Call SendMessage(getHWnd(statusList[field+1]), BM_SETCHECK, 0, 0); 
  Call SendMessage(getHWnd(statusList[field+2]), BM_SETCHECK, 0, 0); 
  select
    case start = "0"
      end := field;
    endCase
    case start = "1"
      end := field+1;
    endCase
    case start = "X" cor start = "x"
      end := field+2;
    endCase
    default
      end := field + 3;
  endSelect;
  Call SendMessage(getHWnd(statusList[end]), BM_SETCHECK, 1, 0);
}!!

/* PUBLIC */
Def show(self, val)
{
  show(self:ancestor, val);
  show(eventListBox, SW_NORMAL);
/*  if not(micepack?(ProcLibClass$Inst))*/
    show(addrNotButton, SW_NORMAL);
    show(dataNotButton, SW_NORMAL);
/*  endif;*/
  show(endAddrButton, SW_NORMAL);
  show(endLenButton, SW_NORMAL);
  do(over(0, size(statusList)),
    {using(field)
       show( statusList[field], SW_NORMAL);
    });
  do(over(0, size(editFieldList)),
    {using(field)
       show( editFieldList[field], SW_NORMAL);
   });
  if((TheProcFamily = PROC_FAMILY_680X0) cand ( asButtonsActive = 1 ))
 /*   show(asGroupBox, val); *//* marked by Jimmy 11/22/94 */
    do(over(0, size(asButtonList)),
      {using(field)
         show( asButtonList[field], SW_NORMAL);
      });
  endif;
}
!!

Def sizeRect(self | ht)
{ if( not(charHeight) )
    ht := 16;   /* assume a value */
  else
    ht := charHeight;
  endif;
  if (not(maxBottom))
    ^nil;
  endif;
  if not(maxRight)  /* maxRight := (x(screenSize()) * 5)/8 */ ^nil; endif;
  ^rect(0,0, maxRight, (maxBottom));
}!!

/* 10/14/1992 16:42 */
Def updateSelf(self){
  if not(activeEdit) then
    activeEdit := preActiveEdit ;
  endif;
  handleActiveEdit(self);
}
!!

/* If user was last seen editting a edit window we need to
   update event server before event window is destroyed */
Def WM_DESTROY(self, wp, lp){
  updateSelf(self);
  TheEventPresenter := nil;
  removeWindowMenu(self);
  ^WM_DESTROY(self:ancestor, wp, lp);
}!!

/* EventWindow Class Initialization Code */
