/* File dialog class used by Save options that allow user to specify a non-existent file. */!!

inherit(FileDialog, #SaveFileDialog, nil, 2, nil)!!

now(class(SaveFileDialog))!!

now(SaveFileDialog)!!

/* Respond to Open button being pushed or CR being pushed. If a
  valid file is selected, exit dialog. Otherwise, switch to new
  directory, filter, etc.  */
Def open(self | fs)
{ fs := fileSpec;
  fileSpec := getItemText(self, FILE_LB);
  if size(fileSpec) = 0
  then fileSpec := "*.*";
  endif;
  if not(loadList(self))
    loadFile := pathString(self, fileSpec);
    fileSpec := fs;
    resetDir(self);
    end(self, IDOK);
  endif;
}!!

/* set the help entry to use */
Def setHelpEntry(self, hEntry)
{
  setHelpEntry(self:ancestor, hEntry);
}!!
