/*a SortedCollection of VPviewInfo (for VarPresenter) */!!

inherit(SortedCollection, #VPviewCollection, nil, 2, 0)!!

now(class(VPviewCollection))!!

now(VPviewCollection)!!

/* PRIVATE -- add offset to all elements of viewColl */
Def adjustViewCollOffset(self, offset)
{
  do(self,
  {using(viewInfo)
     offsetViewStartLine( viewInfo, offset )
  });
}
!!

/* PUBLIC -- return the view which contains viewStartLine 1. */
Def focusView(self)
{
  if (size(self) = 0) then ^nil endif ;

  do(self,
  {using(viewInfo)
      if (viewStartLine(viewInfo) <= 1) cand (1 <= viewEndLine(viewInfo))
      then
        ^viewInfo
      endif ;
  });

  ^first( self ) ;
}
!!

/* PRIVATE
   Return the number of lines of text above line 0.
   @@ do code speedup later @@
*/
Def linesShownIn(self)
{
  ^( numLinesIn(self) - prefixLinesHiddenIn(self) )
}
!!

/* PRIVATE
   Return the number of lines of text in the cache.
*/
Def numLinesIn(self | numLines)
{
  numLines := 0 ;
  do(self,
  {using(view)
    numLines := (numLines + size(bufText(view)));
  });

  ^numLines
}
!!
/* PRIVATE
   Return the number of lines of text in the cache which are numbered
   less than zero (based on viewStartLine).
*/
Def prefixLinesHiddenIn(self | num)
{
  if (size(self) = 0)
  then
    ^0
  else
    num := viewStartLine( first(self) ) ;
    if (num < 0)
    then
      ^num
    else
      ^0
    endif ;
  endif ;
}
!!

/* PUBLIC -- get new text snapshot for views */
Def refreshText(self, varSession | startLine aView)
{
  /* trim hidden views from top */
  loop while (size(self) > 0)
        cand (aView := first(self))
        cand (viewEndLine(aView) < 0)
  begin removeFirst(self) endLoop;

  /* Untypical, but may happen */
  if (size(self) = 0) then ^nil endif ;

  startLine := viewStartLine( first(self) ) ;
  /* flush stale information */
  do(self,
  {using(view)
    setLinesVeracity( var(view), #Unreliable ) ;
  });
  /* get new text */
  do(self,
  {using(view)
     if not(initBufText( view, varSession, startLine, bufNum(view) ))
     then
        /* 12/02/92 - Nghia revised to handle error gracefully.
           displayFormattedError(ErrorTextLibClass$Inst, 
              ER_INTERNAL, FORCE_POPUP, "Variable View: Internal Problem",
              "Can't find updated variable information", nil);
        */
        ^nil;         
     endif ;
     startLine := ( viewEndLine(view) + 1 ) ; /* size may have changed */
  });
  
}
!!

/* PRIVATE 
  View has been resized.  ViewStartLine numbering is correct.
  Trim unneeded viewInfo's from self.
*/
Def trimDisplayViews(self, numLinesInDisplay | displayMargin aView)
{
/* displayMargin is the number of lines to keep outside of the
   display range. {@@tuning parameter@@}
*/
  displayMargin := -10 ; /* N.B. must be negative! See usage, below */

  /* trim from top */
  loop while (size(self) > 0)
        cand (aView := first(self))
        cand (viewEndLine(aView) < displayMargin) /* margin is negative */
  begin removeFirst(self) endLoop;
  
  /* trim from bottom */
  displayMargin := ( numLinesInDisplay - displayMargin ) ;
  /* (i.e. the above adds displayMargin) */
  loop while (size(self) > 0) 
        cand (aView := last(self))
        cand (viewStartLine(aView) > displayMargin)
  begin removeLast(self) endLoop;
}
!!

/* PRIVATE -- is var in view? -- any buffer ok. */
Def varInView?(self, varInfo)
{
  do(self,
  {using(viewInfo)
    if (varInfo = var(viewInfo))
    then ^viewInfo
    endif ;
  });

  ^nil
}!!

/* PRIVATE -- is var with buf N in view? */
Def varInViewN?(self, varInfo, bufferNumber)
{
  do(self,
  {using(viewInfo)
    if (varInfo = var(viewInfo)) cand (bufNum(viewInfo) = bufferNumber)
    then ^viewInfo
    endif ;
  });

  ^nil
}

!!

/* PRIVATE
   Given display lineNum, return #(viewInfo, lineTextStr) or nil.
*/
Def viewFromLine(self, lineNum | viewInfo)
{
  do(self,
  {using(view)
    if (lineNum >= viewStartLine(view)) cand (lineNum <= viewEndLine(view))
    then viewInfo := view ;
    endif ;
  });
  if not(viewInfo)
  then
    ^nil
  else
    ^tuple( viewInfo, viewLineStr(viewInfo, lineNum) )
  endif ;
}

!!
