/* Class to handle restricting the user on resizing window larger than
   a set max height and width.  This also creates an overlapping window
   with only a min button. */!!

inherit(AutomaticMenu, #MaxSizeWindow, #(oldRectInfo), 2, nil)!!

now(class(MaxSizeWindow))!!

Def newStyle(self, par, menuName, wName, rect, id, style | theWnd)
{ theWnd := new(self:Behavior);
  if menuName
  then loadMenu(theWnd, menuName);
  else setHMenu(theWnd, setContID(theWnd, id));
  endif;
  setPaintStruct(theWnd, new(Struct, 32));
  create(theWnd, par, wName cor "", rect cor sizeRect(theWnd),
  style cor style(self));
  setLocRect(theWnd);
  ^init(theWnd);
}!!

/* PUBLIC
   Return the default window style. 
 */
Def style(self)
{ 
  ^(WS_OVERLAPPED bitOr WS_CAPTION bitOr WS_SYSMENU bitOr WS_THICKFRAME
    bitOr WS_MINIMIZEBOX);
}!!

now(MaxSizeWindow)!!

/* PUBLIC
   Respond to a windows message to resize the window.
   wp and lp are standard windows arguments.
 */
Def reSize(self, wp, lp | maxSize newSize oldSize
                          magicW magicH) {
  if not(oldRectInfo)
  then ^0;
  endif;
  if not(sizeRect(self)) ^0 endif;
  maxSize := sizeRect(self);
  oldSize := oldRectInfo;
  newSize := windowRect(self);
  oldRectInfo := newSize;
  magicH := min(height(maxSize),height(newSize));
  magicW := min(width(maxSize),width(newSize));
  if top(newSize) <> top(oldSize)
    setTop(oldRectInfo,bottom(newSize)-magicH);
  else
    setBottom(oldRectInfo,top(newSize)+magicH);
  endif;
  if left(newSize) <> left(oldSize)
    setLeft(oldRectInfo,right(newSize)-magicW);
  else
    setRight(oldRectInfo,left(newSize)+magicW);
  endif;
  setCRect(self,oldRectInfo);
  moveWindow(self);
  sizeKids(self);
  invalidate(self);
}!!

/* 6/3/1992 12:44 */
Def setSize(self, rect)
{ ^oldRectInfo := rect;
}
!!
/* PRIVATE
   Default - no kids to resize.
 */
Def sizeKids(self) {
}!!
