/* This collection defines a Set that sorts its elements.
  Sorted sets operate under the default assumption that
  each item added may be compared with other elements
  by using a less than comparison.  This behavior can be
  changed by using setCompareBlock to change the way
  elements are compared. */!!

inherit(SortedCollection, #SortedSet, nil, 2, 0)!!

now(class(SortedSet))!!

now(SortedSet)!!

/* Add an item to a sorted set. */
Def add(self, item )
{ addUsing(self, item,
  {using(x y z)
  });
}!!

/* Add an item to the sorted set. First
  determine where it should go and then put the item
  there. Evaluate aBlock if the new element is
  already present.  The block args are: using(oldItem,
  newItem, index). */
Def addUsing(self, item, aBlock | index, elem, idxTuple idx)
{ idxTuple := findItemIndex(self, item);
  idx := idxTuple[1];
  if idxTuple[0]
  then elem := self:Object[idx];
    ^eval(aBlock, elem, item, idx);
  endif;
  ^insert(self, item, idx);
}!!
