/* Class used to hold event names within the trigger spec window. */!!

inherit(ComboBox, #TriggerEventWindow, #(eventCond
), 2, nil)!!

now(class(TriggerEventWindow))!!

/* PUBLIC
 */
Def newEventWindow (self, id, par, eventMask | aObj)
{ 
  aObj := newDropDownList(self, id, par, nil);
  setEventCondition(aObj,eventMask);
  ^init(aObj);
}!!

now(TriggerEventWindow)!!

/* PUBLIC
   Initialize list box with event name(s) from event server.
   return number of events found.
 */
Def setupList2(self Sel | num)
{ 
  clearList(self);
  /* Go to event server and get the list of defined
     events and send them to the combo box. */
  if (Sel = 0) then   
    num := evtNumDefinedEvents($commonEventLib); 
    do(num,
    {using(elem | eName)
      eName := evtGetNextEvent($commonEventLib);
      if eName
        if eName <> "PC_Breakpoint"
          insertString(self, eName, -1);
        endif;  
      endif;
    });
  else
    insertString(self, "PC_Breakpoint", -1);
  endif;  
      
  ^num;   
}!!

Def WM_KEYDOWN(self, wp, lp)
{ if( wp = 13 cor between(wp, 0x70, 0x79) )
    updateSelf(parent);
  endif;
  ^WM_KEYDOWN(parent,wp,lp);
}!!

/* PUBLIC
   Return the trigger event condition mask.
 */
Def eventCondition(self)
{ 
  ^eventCond
}
!!

/* PUBLIC
   Initialize list box with event name from event server.
 */
Def init(self | num)
{ 
  sendMessage(self,0x0030/*WM_SETFONT*/,getFont(parent),0L);
  if not($commonEventLib)
    $commonEventLib := eventOpen( require(EventLib), "default" ) ; 
  endif;
  setupList(self);
}
!!

/* PUBLIC
   return number of events found.
 */
Def numEvents(self)
{ 
  ^evtNumDefinedEvents($commonEventLib); 
}
!!

/* PUBLIC 
   Need to reset height to give drop box
   room to drop down
 */
Def setCRect(self, rect)
{ 
  cRect := rect;
  setBottom(cRect,bottom(cRect) + (height(cRect)*2));
  ^cRect;
}
!!

/* PUBLIC
   Insert the incoming text string into the field name edit
   control window.
 */
Def setEventCondition(self, mask)
{ 
  eventCond := mask;
}
!!

/* PUBLIC
   Initialize list box with event name(s) from event server.
   return number of events found.
 */
Def setupList(self | num)
{ 
  clearList(self);
  /* Go to event server and get the list of defined
     events and send them to the combo box. */
  num := evtNumDefinedEvents($commonEventLib); 
  do(num,
  {using(elem | eName)
    eName := evtGetNextEvent($commonEventLib);
    if eName
      if eName <> "PC_Breakpoint"
        insertString(self, eName, -1);
      else  
        insertString(self, eName, 0);
      endif;  
    endif;
  });
  ^num;   
}
!!

/* PUBLIC
   When this window loses focus than we need to check the text entered
   in our window.
 */
Def verifyInput(self | text)
{
  /* This routine will verify that the text is a valid string */ 
  text := getSelString(self);
  do(text,
  {using(c)
    if not(isPrintable(c))    /* @@@ this needs beefing up */
      displayFormattedError(ErrorTextLibClass$Inst, 
         ER_FIELD_NAME, FORCE_POPUP, nil, nil, nil);
      setSelIdx(self,nil);
      ^nil;
    endif;
  });
  ^#true;
}
!!
