/* identifies type of user network, provides access and test methods. */!!

inherit(Object, #NetworkType, nil, 2, nil)!!

setClassVars(NetworkType, #($NetworkID  /* network identification string */))!!

now(class(NetworkType))!!

/* 4/6/1993 8:45
   PRIVATE
   Retrieves the network ID string from the profile. */
Def initNetworkIDString(self | stringValue)
{
  /* early exit if its already there */
  if $NetworkID
    ^0;
  endif;
  
  /* fail if its too early to access file */
  if not(TheProfileInfoObj)
    ^nil;
  endif;
  
  stringValue := getProfileEntry(TheProfileInfoObj,
    NETWORK_APPLICATION, NETWORK_KEY, "");
    
  /* set to unknown if not found */
  if stringValue
    $NetworkID := first(stringValue);
  else
    $NetworkID := NETWORK_UNKNOWN;
  endif;
  ^0;
}
!!

/* 4/6/1993 9:11
   Return true if this is a PC-NFS network. */
Def networkPCNFS?(self)
{
  /* init network ID if it hasn't been done already */
  initNetworkIDString(self);
  
  /* return true if this is PC-NFS */
  ^($NetworkID = NETWORK_PC_NFS);
}
!!

/* 4/6/1993 9:11
   Return network type. */
Def networkType(self)
{
  /* init network ID if it hasn't been done already */
  initNetworkIDString(self);
  
  ^$NetworkID;
}
!!

/* 4/6/1993 9:11
   Return true if this is an unknown network. */
Def networkUnknown?(self)
{
  /* init network ID if it hasn't been done already */
  initNetworkIDString(self);
  
  /* return true if this is unknown */
  ^($NetworkID = NETWORK_UNKNOWN);
}
!!

now(NetworkType)!!