/* CLI Unary Op Node:
   CLI:       - operand;                ! operand;            ~operand;
   Actor:   negate((operand));    (not(operand));     (xor(0xffff, operand));   */!!

inherit(Object, #CLIUnaryOpNode, #(operand
operator  /* negate, not, or bitwise negate */), 2, nil)!!

now(class(CLIUnaryOpNode))!!

now(CLIUnaryOpNode)!!

/* Compile the node into Actor source. */
Def CLICodeCompile(self)
{
  select
    case operator = TMINUS
    is
      CLICodeCompile(" negate(");
      CLICodeCompile(operand);
      CLICodeCompile(") ");
    endCase
    case operator = TTILDE
    is
      CLICodeCompile(" primBitwiseNegation(self, ");
      CLICodeCompile(operand);
      CLICodeCompile(") ");
    endCase
    case operator = TEXCLAM
    is
      CLICodeCompile(" logicalNot(self, ");
      CLICodeCompile(operand);
      CLICodeCompile(") ");
    endCase
  endSelect;
}!!

Def init(self, opand, optor)
{
  operand := opand;
  operator := optor;
}!!
