/* PowerViews Application Class (seal-off startup code) */!!

inherit(Application, #PowerApp, #(okToClose?  /* set by button window */), 2, nil)!!

now(class(PowerApp))!!

now(PowerApp)!!

/* 10/19/1992 15:09 */
Def okToClose?(self)
{ ^okToClose? }
!!

/* PUBLIC to mainWindow only -- always answer 1 to WM_QUERYENDSESSION */
Def setOkToClose(self)
{ okToClose? := #true ; }
!!

/* This method returns true (self) to indicate that the sender
   may continue the abort process. */
Def abort(self)
{ }
!!

/* close the App */
Def close(self)
{
  TheToolBarPresenter cand close(TheToolBarPresenter) ;
  mainWindow cand close( mainWindow ) ;
  close( self:ancestor ) ;
}!!

/* intiialize our application */
Def init(self, aString | dummyWindow)
{
  init( self:ancestor, aString ) ;

  if (hPrevInstance() <> 0)
  then
    Call MessageBox( 0,
                     asciiz("MICEpack/SLD is already running!"),
                     asciiz("MICEpack/SLD"),
                     MB_OK
                    ) ;
     ^nil
  endif ;
  
  /* install global error handler */
  onError(ErrorHandler, self, #all, #all, 
    {using(rcr, bp, errorBp)
     errorDumpWindow(ErrorDump);
     0});
  
  Call SetMessageQueue( 200 ) ;
  mainWindow := dummyWindow := newMain( Window, nil, "Dummy", nil ) ;

  if openButtonBarPresenter( PreLauncher, nil )
  then
    mainWindow := TheToolBarPresenter ;
    close( dummyWindow ) ;
    ^#good
  else
    close( dummyWindow ) ;
    ^nil
  endif ;
  
  /* this should be declared in same method to undo error handler,
     but can't be done here
  offError(ErrorHandler);
  */
}!!

/* Take care of business before terminating the application. */
Def shouldClose(self)
{
  if okToClose?
  then
    ^#true
  else
    /* find open windows */
    do(presenterNames(PreLauncher),
    {using(key | win)
      if (win := at(Actor, key))
      then
        bringToTop(win);
        if (win <> mainWindow) cand not(shouldClose(win))
        then ^nil ;
        endif ;
      endif ;
    });
    /* if ok to close all windows, then query user for the App */
    ^(new( ErrorBox,
           ThePort,
           "Exit MP/SLD?",
           "Exit Application",
           MB_YESNO bitOr MB_ICONQUESTION
          ) == IDYES)
  endif ;
}!!
