/* Procs are objects defining dynamically-linked
  library procedures.  They descend from Struct for
  space efficiency.

  Data format:   0 | nargs word   |
                 2 | argInfo word |
                 4 | proc offset  |
                 6 | proc seg     |
*/!!

inherit(Struct, #Proc, nil, 0, 1)!!

now(class(Proc))!!

/* Return a new Proc object. */
Def new(self)
{ ^variableNew(self:Behavior, 8);
}!!

now(Proc)!!

/* Set the address of the Proc with a
  long received from Call GetProcAddress(..). */
Def setAddr(self, addr)
{ putLong(self, addr, 4)
}!!

/* Set up the arguments byte. Input is a collection
  that indicates the byte/word status of each
  parameter. 0 = word, 1 = long.  For the return type
  0 = word, 1 = long, and nil = void.
  example:  setArgs(aProc, 0, #(0 1 1)); */
Def setArgs(self, rType, args | argwd, amask)
{ argwd := 0;
  amask := 1;
  do(args,
  {using(x) argwd := argwd + (x * amask);
    amask := amask * 2;
  });
  argwd := argwd + ((rType cor 0) * amask);
  putWord(self, size(args), 0);
  putWord(self, argwd, 2);
}!!
