/* CLASS: VARSERVL.CLS
   Variable Server Library Management -- see also VarLibInst
*/!!

inherit(ProvidedLibs, #VarServLib, nil, 2, nil)!!

now(class(VarServLib))!!

/* semiPRIVATE -- should only be called via require(VarServLib)
   Define entry points and load library.  Define any structs required.
*/
Def provide(self, path)
{
  ^initialize( new(self:ancestor), path )
}
!!

now(VarServLib)!!

/* PRIVATE
   Define all entry points for library as prototypes.
*/
Def addImportProcs(self)
{
  add( self, #INITCSERVER,          1, #(0, 0)                );
  add( self, #VSINIT,               1, nil                    );
  add( self, #VSSTARTSESSION,       1, #(0, 1, 1)             );
  add( self, #VSENDSESSION,         1, #(1)                   );
  add( self, #VSOPENVAR,            1, #(1, 1, 0, 1)          );
  add( self, #VSOPENCOMPOSITEVAR,   1, #(1, 1, 1, 0, 0, 1)    );
  add( self, #VSOPENCOMPONENTVAR,   1, #(1, 1, 0, 1, 1, 0, 1) );
  add( self, #VSINTERPRETVARASTYPE, 1, #(1, 1, 0, 0, 1)       );
  add( self, #VSINTERPRETMEMASTYPE, 1, #(1, 1, 0, 0, 1)       );
  add( self, #VSCLOSEVAR,           1, #(1, 1)                );
  add( self, #VSREADVAR,            1, #(1, 1, 1)             );
  add( self, #VSREADVARATNBUF,      1, #(1, 1, 1, 1)          );
  add( self, #VSREADSTACKVAR,       1, #(1, 1, 1, 0, 1)       );
  add( self, #VSGETLINESFORVAR,     1, #(1, 1, 1)             );
  add( self, #VSEDITVALUE,          1, #(1, 1, 1, 1, 1, 1, 0) );
  add( self, #VSNEWVALUE,           1, #(1, 1, 1, 1, 0, 1, 1) );
  add( self, #VSVARSYMBOL,          1, #(1, 1, 1)             );
}!!

/* PRIVATE */
Def defineStructs(self)
{
  def( UserType, #STRING_REF_TYPE, #( char  string_value 132 ) ) ;
  def( UserType, #LONG_REF_TYPE, #( long  long_value 1 ) ) ;
  def( UserType, #WORD_REF_TYPE, #( short word_value 1 ) ) ; /* unsigned */

/*
typedef struct  { 
WORD alloc_indicator; -- VS_TMALLOC or GlobalAlloc handle
BOOLEAN continued; 
U8 pad;
DESCRIPTOR bufnum; 
DESCRIPTOR textLength; 
U8 text[VARIABLE_SIZED]; 
}  VS_DISPLAY_BUFFER_TYPE; 
typedef VS_DISPLAY_BUFFER_TYPE   *VS_DISPLAY_PTR; 
*/
  def( UserType, #VS_DISPLAY_BUFFER_TYPE,
       #( short alloc_indicator 1
          byte  continued? 1
          byte  pad 1
          long  bufnum 1
          long  textLength 1
          char  text 132   /* a lie */
        )
     ) ;
}
!!

/* PUBLIC
   Open a session with the Variable Server.
   Return a session instance (VarLibInst) or nil.
*/
Def openSession(self, hWnd | sessionInstance)
{
  sessionInstance := new( VarLibInst, hWnd ) ;

  if sessionInstance then /* pass on library name to offspring */
    setIVars( sessionInstance,
              hLib, name, ordinals, procs, globalNameSymbol ) ;
  endif ;

  ^sessionInstance
}
!!
