/* CLASS: VPVARINFO
   Variable Info for Variable Browser and Presenter:
   represents a variable
*/!!

inherit(Object, #VPvarInfo, #(varName
varSymbolDescriptor
varVarID
addedTimestamp /* when was this entry created? */
numLines /* cached total # lines */
linesVeracity /* #Exact, #Incomplete, #Unreliable, Unknown */
frameNumber
expandedName /* varname + local prefix */), 2, nil)!!

now(class(VPvarInfo))!!

/* PUBLIC */
Def newFromCompositeVar(self, symbolDesc, varStr, startOffset, varSession
                       | newInstance)
{
  newInstance := new( self:ancestor ) ;
  
  ^initFromCompositeVar( newInstance, 
                   symbolDesc, varStr, startOffset, varSession ) ;
}
!!

/* PUBLIC */
Def newFromSymbol(self, varSymbol, varNameStr, varSession | newInstance)
{
  newInstance := new( self:ancestor ) ;
  
  ^initFromSymbol( newInstance, varSymbol, varNameStr, varSession ) ;
}
!!

/* PUBLIC */
Def newFromSymbolAndFrame(self, varSymbol, varNameStr, varSession, frameNum
                       | newInstance)
{
  newInstance := new( self:ancestor ) ;
  
  ^initFromSymbolAndFrame( newInstance, 
                           varSymbol, varNameStr, varSession, frameNum ) ;
}
!!

/* PUBLIC */
Def newFromVarId(self, sessionID, aVarID, aVarNameStr | newInstance)
{
  newInstance := new( self:ancestor ) ;
  
  ^initFromVarID( newInstance, sessionID, aVarID, aVarNameStr ) ;
}
!!

now(VPvarInfo)!!

/* PUBLIC */
Def setExpandedName(self, newVal)
{ ^expandedName := newVal }
!!

/* PUBLIC */
Def expandedName(self)
{ ^expandedName }
!!

/* PUBLIC */
Def frameNumber(self)
{ ^frameNumber }
!!

/* PRIVATE */
Def init(self)
{
   addedTimestamp := Call GetTickCount() ;
   linesVeracity  := #Unknown ;
   numLines       := 0 ;
   frameNumber    := 0 ;
}
!!

/* PRIVATE */
Def initFromCompositeVar(self, symbolDesc, varStr, startOffset, varSession )
{
  init( self ) ;
  varSymbolDescriptor := symbolDesc ;
  varName := varStr ;
  
  /* from Variable server */
  varVarID   := openCompositeVar( varSession, 
                                  symbolDesc, varStr, startOffset ) ; 
  if not(varVarID)
  then
    ^nil /* failed */
  else
    numLines := getLinesForVar( varSession, varVarID ) ;
    if numLines
    then linesVeracity := #Exact ;
    endif ;
  endif;

  ^self
}
!!

/* PRIVATE */
Def initFromSymbol(self, varSymbol, varNameStr, varSession)
{
  init( self ) ;
  varSymbolDescriptor := varSymbol ;
  if varNameStr
  then
    varName := varNameStr ;
  endif ;
  
  varVarID   := openVar( varSession, varSymbol ) ; /* from Variable server */
  if not(varVarID)
  then
    ^nil /* failed */
  else
    numLines := getLinesForVar( varSession, varVarID ) ;
    if numLines
    then linesVeracity := #Exact ;
    endif ;
  endif;

  ^self
}
!!

/* PRIVATE */
Def initFromSymbolAndFrame(self, varSymbol, varNameStr, varSession, frameNum)
{
  init( self ) ;
  varSymbolDescriptor := varSymbol ;
  frameNumber := frameNum ;
  if varNameStr
  then
    varName := varNameStr ;
  endif ;
  
  varVarID   := openVar( varSession, varSymbol ) ; /* from Variable server */
  if not(varVarID)
  then
    ^nil /* failed */
  else
    numLines := getLinesForVar( varSession, varVarID ) ;
    if numLines
    then linesVeracity := #Exact ;
    endif ;
  endif;

  ^self
}
!!

/* PRIVATE */
Def initFromVarID(self, sessionID, aVarID, varNameStr)
{
  init( self ) ;
  varVarID := aVarID ;
  varSymbolDescriptor := symbolIDfrom( sessionID, aVarID ) ;
  if varNameStr
  then
    varName := varNameStr ;
  endif ;
  if not(varSymbolDescriptor)
  then
    ^nil  /* failed */
  else
    numLines := getLinesForVar( sessionID, varVarID ) ;
    if numLines
    then linesVeracity := #Exact ;
    endif ;
  endif ;

  ^self
}
!!

/* PUBLIC */
Def linesVeracity(self)
{ if linesVeracity
  then ^linesVeracity
  else ^#Undefined
  endif ;
}
!!

/* PUBLIC */
Def name(self)
{ ^varName }
!!

/* PUBLIC */
Def numLines(self)
{ ^numLines }
!!

/* PUBLIC */
Def setLineNumInfo(self, numTextLines, veracity)
{
  numLines      := numTextLines ;
  linesVeracity := veracity ;
}
!!

/* PUBLIC */
Def setLinesVeracity(self, veracity) 
/* linesVeracity is #Exact, #Incomplete, #Unreliable, #Undefined */
{ ^(linesVeracity := veracity) }
!!

/* PUBLIC */
Def setName(self, newVal)
{ ^varName := newVal }
!!

/* PUBLIC */
Def setNumLines(self, numTextLines) 
{ ^(numLines := numTextLines) }
!!

/* PUBLIC */
Def setVarID(self, newVal)
{ ^varVarID := newVal }
!!

/* PUBLIC */
Def setVarSymbol(self, newVal)
{ ^varSymbolDescriptor := newVal }
!!

/* PUBLIC */
Def timeStamp(self)
{ ^addedTimestamp }
!!

/* PUBLIC */
Def varID(self)
{ ^varVarID }
!!

/* PUBLIC */
Def varSymbol(self)
{ ^varSymbolDescriptor }
!!
