/* General purpose ScrollBar class.  This class
  provides support for scroll bars which are used with
  regular windows, as opposed to dialog windows
  defined using resources. */!!

inherit(Control, #ScrollBar, nil, nil, nil)!!

now(class(ScrollBar))!!

/* Create and return a new ScrollBar object in Actor and
  Windows. Parent passes control id, itself, and a style.
  The style is an integer which determines what kind of
  ScrollBar will be created. */
Def new(self, id, par, style | theSB)
{ theSB := new(self:Behavior);
  setContID(theSB, id);
  setParent(theSB, par);
  create(theSB, nil, "scrollbar", style bitOr WS_CHILD) ;
  init(theSB);
  ^theSB;
}!!

/* Create and return a horizontal ScrollBar object in Actor and
  Windows. Parent passes control id and itself. */
Def newHorz(self, id, par)
{ ^new(self, id, par, SBS_HORZ);
}!!

/* Create and return a vertical ScrollBar object in Actor and
  Windows. Parent passes control id and itself. */
Def newVert(self, id, par)
{ ^new(self, id, par, SBS_VERT);
}!!

now(ScrollBar)!!

/* Get the current scroll bar position. */
Def getPos(self)
{ ^asInt(Call GetScrollPos(hWnd, SB_CTL));
}!!

/* Get the range of this scroll bar. */
Def getRange(self | min, max)
{ Call GetScrollRange(hWnd, SB_CTL,
    min := new(Struct, 2),
    max := new(Struct, 2));
  ^point(wordAt(min, 0), wordAt(max, 0));
}!!

/* Initialize a scroll bar to have a default range of 0-100. */
Def init(self)
{ setRange(self, 0, 100); /* default range */
  setPos(self, 0);
}!!

/* Move the scroll bar to the latest location and repaint. */
Def moveWindow(self)
{ moveWindow(self:ancestor);
  invalidate(self);
}!!

/* Set the scroll bar position, return old position. */
Def setPos(self, pos)
{ ^Call SetScrollPos(hWnd, SB_CTL, pos, 1);
}!!

/* Set the range of scroll bar. */
Def setRange(self, Min, Max)
{ Call SetScrollRange(hWnd, SB_CTL, Min, Max, 1)
}!!
