/* Library for Trigger Server dll; creates trigger instances */!!

inherit(ProvidedLibs, #TriggerLib, #(initialized /* prevent duplicate initialization */), 2, nil)!!

setClassVars(TriggerLib, #())!!

now(class(TriggerLib))!!

/* semiPRIVATE - only called via require(). */
Def provide(self, path)
{ 
  ^initialize(new(self:ancestor), path);
}
!!

now(TriggerLib)!!

/* 5/29/1996 9:27 */
Def trigDescGet(self | id)
{ 
  id := new(Struct,4);
  if pcallLock(self)
    lastError :=
      pcall(procs[#TRIGDESCGET], id );
    pcallUNLock(self);
  else
    lastError := ERR_PCALL_RECURSION;
  endif;

  if (lastError = 0)
    ^longAt(id,0);
  endif;
  displayError(ErrorTextLibClass$Inst, lastError, CHECK_MODE);
  ^nil;  /* error */
}
!!

/* 5/21/1996 10:37 */
Def trigDlgPcBkpt(self hWnd eventDesc)
{ 
  /* call dialog box that lives in MEM.DLL */
  if pcallLock(self)
    lastError :=
      pcall(procs[#TRIGDLGPCBKPT],  hWnd, eventDesc );
    pcallUNLock(self);
  else
    lastError := ERR_PCALL_RECURSION;
  endif;

  if (lastError = 0 cor lastError = 1)
    ^lastError;
  endif;
  displayError(ErrorTextLibClass$Inst, lastError, CHECK_MODE);
  ^nil;  /* error */
}
!!

/* 7/25/1994 13:34 */
Def trigInit(self)
{
  if pcallLock(self)
    lastError := pcall(procs[#TRIGINIT], hLib);
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;

  if (lastError <> GOOD)
    displayFormattedError(ErrorTextLibClass$Inst, 
       lastError, CHECK_MODE, nil, nil, nil);
    ^nil;
  endif;
  
  ^GOOD;
}
!!

/* PRIVATE */
Def addImportProcs(self)
{
  add( self, #INITCSERVER, 1, #(0, 0) ) ;
  add( self, #TRIGACTIONSET, 1, #(1, 0) ) ;
  add( self, #TRIGACTIONGET, 1, #(1, 1) ) ;
  add( self, #TRIGACTIONCLEAR, 1, #(1, 0) ) ;
  add( self, #TRIGCOUNTERFUNCTIONGET, 1, #(1, 1) ) ;
  add( self, #TRIGCOUNTERFUNCTIONSET, 1, #(1, 0) ) ;
  add( self, #TRIGCOUNTERVALUESET, 1, #(1, 0, 1) ) ;
  add( self, #TRIGCOUNTERVALUEGET, 1, #(1, 0, 1) ) ;
  add( self, #TRIGEVENTCLEAR, 1, #(1) ) ;
  add( self, #TRIGEVENTENABLESET, 1, #(1, 0) ) ;
  add( self, #TRIGEVENTENABLEGET, 1, #(1, 1) ) ;
  add( self, #TRIGEXTSET, 1, #(1, 0) ) ;
  add( self, #TRIGEXTGET, 1, #(1, 1) ) ;
  add( self, #TRIGEVENTNAMESET, 1, #(1, 1) ) ;
  add( self, #TRIGEVENTNAMEGET, 1, #(1, 1, 0) ) ;
  add( self, #TRIGEVENTSET, 1, #(1, 0) ) ;
  add( self, #TRIGEVENTSERVERGET, 1, #(1, 1) ) ;
  add( self, #TRIGFILLACTIONSET, 1, #(1, 0) ) ;
  add( self, #TRIGFILLACTIONGET, 1, #(1, 1) ) ;
  add( self, #TRIGSEQLEVELSET, 1, #(1, 0) ) ;
  add( self, #TRIGTRACECONFIGUREGET, 1, #(1, 1) ) ;
  add( self, #TRIGTRACECONFIGURESET, 1, #(1, 0) ) ;
  add( self, #TRIGTRACEMODEGET, 1, #(1, 1) ) ;
  add( self, #TRIGTRACEMODESET, 1, #(1, 0) ) ;
  add( self, #TRIGTRIGGERCLEAR, 1, #(1) ) ;
  add( self, #TRIGTRIGGERCLOSE, 1, #(1) ) ;
  add( self, #TRIGTRIGGEROPEN, 1, #(1, 1, 1) ) ;
  add( self, #TRIGTRIGGERSAVEAS, 1, #(1, 1) ) ;
  add( self, #TRIGQUALIFIERSET, 1, #(1, 0) ) ;
  add( self, #TRIGQUALIFIERGET, 1, #(1, 1) ) ;
  add( self, #TRIGINIT, 1, #(1));
  add( self, #TRIGEXTEVENTGET, 1, #(1, 1));
  add( self, #TRIGDLGPCBKPT, 1, #(0, 1));
  add( self, #TRIGDESCGET, 1, #(1));
}!!

/* PRIVATE 
   Open and initialize trigger server library & load trigger dll
*/
Def initialize(self, path)
{ 
   setName( self, path ) ;
   addImportProcs( self ) ;
   load( self ) ;
   ^self ;
}
!!

/* PUBLIC -- create a trigger instance */
Def triggerOpen(self, fileName, template | aTrigger, rc, descriptorPtr) 
{ 
  aTrigger := new( Trigger ) ;
  descriptorPtr := new( Struct, 4 ) ;
  
  rc := pcall(procs[#TRIGTRIGGEROPEN], descriptorPtr, asciiz(fileName),
              asciiz(template)) ;
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0) ^nil ; endif ;
  setDescriptor( aTrigger, longAt(descriptorPtr, 0) );
  setFileName(  aTrigger, fileName ) ;
  setProcs( aTrigger, procs(self) ) ;
  
  ^aTrigger
}!!

/* TriggerLib Class Initialization Code */
