/* instance of DqLib */!!

inherit(DqLib, #Dq, #(descriptor  /* my descriptor from Open... */
), 2, nil)!!

now(class(Dq))!!

now(Dq)!!

/* PUBLIC -- gingerbread for pcall */
Def dadBackwardDqInst(self, numInst, startRef, endRef, addrRef, lenRef | rc)
{
  if pcallLock(self)
  then
    rc := pcall(procs[#DADBACKWARDDQINST],descriptor, numInst, startRef,
               endRef, addrRef, lenRef);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  ^rc;
}
!!

/* 2/6/1992 9:08 */
Def dadDqFlush(self | rc)
{ 
  if pcallLock(self)
  then
    rc := pcall(procs[#DADDQFLUSH], descriptor);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}
!!

/* PUBLIC -- gingerbread for pcall */
Def dadForwardDqInst(self, numInst, startRef, endRef, addrRef, lenRef | rc)
{
  if pcallLock(self)
  then
    rc := pcall(procs[#DADFORWARDDQINST],descriptor, numInst, startRef,
               endRef, addrRef, lenRef);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  ^rc;
}
!!

/* PUBLIC -- gingerbread for pcall */
Def dadSetDqSymbol(self, val | rc)
{ 
  if pcallLock(self)
  then
    rc := pcall(procs[#DADSETDASMSYMBOL],val);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}
!!

/* PUBLIC */
Def descriptor(self)
{ 
  ^descriptor
}
!!

/* PRIVATE to TriggerLib */
Def setDescriptor(self, d)
{
  descriptor := d ;
}
!!

/* PRIVATE to TriggerLib */
Def setProcs(self, p)
{
  procs := p ;
}
!!
