/* Defines the handling of edit controls. */!!

inherit(Control, #Edit, nil, 2, nil)!!

now(class(Edit))!!

/* Create a new edit control object in Actor and Windows.
  Parent passes itself and the control ID.  Style is one of
  the MS-Windows ES_ style constants, or WS_BORDER,
  WS_VSCROLL, or WS_HSCROLL, or any combination of these. */
Def new (self, id, par, style | theEC)
{ theEC := new(self:Behavior);
  /* create object */
  setVars(theEC, id, par);
  create(theEC, nil, "Edit", style bitOr WS_CHILD);
  if handle(theEC) = 0
  then alert(System, self, #wCreateError)
  endif;
  ^theEC;
}!!

now(Edit)!!

/* Clear selected text. */
Def clear(self)
{ sendMessage(self, 0x303, 0, 0);
}!!

/* Copy selected text to clipboard. */
Def copy(self)
{ sendMessage(self, 0x301, 0, 0);
}!!

/* Cut selected text to clipboard. */
Def cut(self)
{ sendMessage(self, 0x300, 0, 0);
}!!

/* Paste the contents of the clipboard into self. */
Def paste(self)
{ sendMessage(self, 0x302, 0, 0);
}!!

/* Set the instance variables of the edit control. */
Def setVars(self, id, par)
{ contID := id;
  parent := par;
}!!
