/* multiple memory window dialog. */!!

inherit(Dialog, #MultMemDlg, #(listBoxIndexes /* maps index in list box to memory window index */
userSelection /* the user's selection */), 2, nil)!!

now(class(MultMemDlg))!!

now(MultMemDlg)!!

/* Return user selection:
   nil:    cancel
   -1:     new window
   other:  memory window object to open */
Def getSelection(self)
{
  ^userSelection;
}
!!

/* Set up the dialog: load the listbox contents, highlight first element. */
Def initDialog(self, wp, lp | index maxWindows memObject idString)
{ 
  registerF1Help(CLIULibraryClass$Inst, HI_DLGR_MULTMEM,
    getHWnd(self), HE_DLGR_MULTMEM);
  
  maxWindows := memoryWindowMax(MultMem);   
  listBoxIndexes := new(Array, maxWindows);
  
  /* gray out new button */
  if (memoryWindowCount(MultMem) >= maxWindows)
    disableItem(self, DLG_MULTMEM_NEW_BUTTON);
  endif;
  
  Call SendMessage(itemHandle(self, DLG_MULTMEM_LISTBOX),
    WM_SETREDRAW, 0, 0L);
  clearLBText(self, DLG_MULTMEM_LISTBOX);     /* load the list box */
  
  index := 0;
  loop
  while index < maxWindows
  begin
    if (memObject := memoryWindowObject(MultMem, index))
      idString := memoryWindowID(memObject);
      addLBText(self, DLG_MULTMEM_LISTBOX, idString);
      listBoxIndexes[index] := memObject;
    endif;
    index := index + 1;
  endLoop;
  
  /* set highlight to first element */
  sendDlgItemMessage(self, DLG_MULTMEM_LISTBOX, LB_SETCURSEL, 0, 0L);

  /* set redraw on prior to last update, which forces repaint. */
  Call SendMessage(itemHandle(self, DLG_MULTMEM_LISTBOX),
    WM_SETREDRAW, 1, 0L);

  /* restore top of list box */
  Call SendMessage(itemHandle(self, DLG_MULTMEM_LISTBOX),
    LB_SETTOPINDEX, 0, 0L);

  ^1; /* tell windows to set focus to first tabstop. */
}
!!

/* Dialog box command processing. */
Def command(self, wp, lp | temp)
{ 
  select
    /* listbox selection */
    case (high(lp) = LBN_SELCHANGE) 
      userSelection := listBoxIndexes[getLBSel(self, DLG_MULTMEM_LISTBOX)];
    endCase
    
    case (high(lp) = LBN_DBLCLK) 
      userSelection := listBoxIndexes[getLBSel(self, DLG_MULTMEM_LISTBOX)];
      end(self, IDOK);
    endCase
    
    case wp = DLG_MULTMEM_NEW_BUTTON
     userSelection := nil;
      end(self, IDOK);
    endCase
    
    case wp = IDCANCEL
      end(self, IDCANCEL);
    endCase
     
    case wp = IDOK
      /* get list box entry */
      userSelection := listBoxIndexes[getLBSel(self, DLG_MULTMEM_LISTBOX)];
      end(self, IDOK);
    endCase

    case wp = IDHELP
      contextNumber(TheHelpObject, hWnd, HE_DLGR_MULTMEM);
    endCase        
  endSelect;
  
  ^0;
}!!
