/* class for handling checkboxes within the trigger spec window */!!

inherit(Control, #TriggerCheck, #(eventCondition   /* which event of 0-7? */
isEvent    /* check box in event enable column? */
isExt  /* check Box in ext enable column */
action /* holds ACTION_MASK of check box if it is in the action section */
boxType /* should this check box be included when in counter mode or timer mode? */
), 2, nil)!!

now(class(TriggerCheck))!!

Def new(self, id, par, name, style, event | theBut)
{ theBut := new(self:Behavior);
  setContID(theBut, id);
  setParent(theBut, par);
  setIsEvent(theBut, nil);
  setIsExt(theBut, nil);
  setAction(theBut, nil );
  setEventCondition(theBut,event);
  setBoxType(theBut,nil);   /* nil implies check box appears in 
                               both timer and counter mode */
  create(theBut, name, "BUTTON", style bitOr WS_CHILD);
  ^theBut;
}!!

/* Create and return a new event check box. */
Def newActionCheck(self, id, par, bitMask, event, type | box){
  box := new(self, id, par, "", BS_AUTOCHECKBOX, event);
  setAction(box,bitMask);
  setBoxType(box,type);
  ^box;
}!!

/* Create and return a new event check box. */
Def newEventCheck(self, id, par, event | box){
  box := new(self, id, par, "", BS_AUTOCHECKBOX, event);
  setIsEvent(box,#true);
  ^box;
}!!

/* Create and return a new event check box. */
Def newExtCheck(self, id, par, event | box){
  box := new(self, id, par, "", BS_AUTOCHECKBOX, event);
  setIsExt(box,#true);
  ^box;
}!!

now(TriggerCheck)!!

/* Allow function keys to work without using accelerators. */
Def WM_KEYDOWN(self, wp, lp)
{ 
  ^WM_KEYDOWN(parent, wp, lp);
}!!

/* PUBLIC */
Def action(self)
{ 
  ^action
}
!!

/* PUBLIC */
Def boxType(self)
{ 
  ^boxType;
}
!!

/* PUBLIC */
Def eventCondition(self)
{ 
  ^eventCondition
}
!!
/* PUBLIC */
Def isEvent(self)
{ 
  ^isEvent
}
!!

/* PUBLIC */
Def isExt(self)
{ 
  ^isExt
}
!!

/* PUBLIC */
Def setAction(self, mask)
{ 
  ^action := mask
}
!!

/* PUBLIC */
Def setBoxType(self, value)
{ 
  ^boxType := value
}
!!

/* PUBLIC */
Def setEventCondition(self, event)
{ 
  eventCondition := event;
}
!!

/* PUBLIC */
Def setIsEvent(self, flag)
{ 
  ^isEvent := flag;
}
!!

/* PUBLIC */
Def setIsExt(self, val)
{ 
  ^isExt := val
}
!!
